/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user;

import com.atlassian.bamboo.plugins.web.conditions.UserExistsCondition;
import com.atlassian.bamboo.security.LogoutSupport;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.user.User;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={UserExistsCondition.class})
public class ChangeEmail
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ChangeEmail.class);
    private String password;
    private String email;
    @Autowired
    LoginInformationManager loginInformationManager;
    private boolean loginThresholdExceeded = false;

    public String input() throws Exception {
        if (this.getUser() == null) {
            this.addActionError(this.getText("error.403.heading"));
        } else {
            this.email = this.getUser().getEmail();
        }
        return "input";
    }

    public String execute() throws Exception {
        User user = this.getUser();
        if (user == null) {
            this.addActionError("You're not logged in");
            return "error";
        }
        if (this.loginThresholdExceeded) {
            LogoutSupport.logout(RequestCacheThreadLocal.getRequest(), RequestCacheThreadLocal.getResponse());
            return "success";
        }
        this.bambooUserManager.saveUser(user.getName(), null, this.email, user.getFullName(), null, this.getBambooUserManager().getGroupNamesAsList(this.getUser()));
        return "success";
    }

    public void validate() {
        super.validate();
        if (this.getUser() == null) {
            this.addActionError("You're not logged in");
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.password) && !this.bambooUserManager.authenticate(this.getUser().getName(), this.password)) {
            log.info((Object)("wrong password was tried to change user email: " + this.getUser().getName()));
            this.loginThresholdExceeded = this.loginInformationManager.incrementFailedCountAndCheckThreshold(this.getUser().getName());
            if (!this.loginThresholdExceeded) {
                this.addFieldError("password", this.getText("user.changeEmail.password.notCorrect"));
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

