/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.specs;

import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.configuration.external.CredentialsExportService;
import com.atlassian.bamboo.configuration.external.DeploymentExportService;
import com.atlassian.bamboo.configuration.external.PlanConfigExportService;
import com.atlassian.bamboo.configuration.external.PlanPermissionService;
import com.atlassian.bamboo.configuration.external.exporters.RepositoryExporter;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.InternalDeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.codegen.BambooSpecsGenerator;
import com.atlassian.bamboo.specs.util.BambooSpecVersion;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.DescriptionProvider;
import com.atlassian.bamboo.utils.archive.ArchiveUtils;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContextImpl;
import com.atlassian.core.util.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ExportWorldToSpecs
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ExportWorldToSpecs.class);
    private static final String PROJECT = "project";
    private static final String POM_CONTENT = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <parent>\n    <groupId>com.atlassian.bamboo</groupId>\n    <artifactId>bamboo-specs-parent</artifactId>\n    <version>%s</version>\n    <relativePath/>\n  </parent>\n\n  <groupId>%s</groupId>\n  <artifactId>%s</artifactId>\n  <version>1.0.0</version>\n  <packaging>jar</packaging>\n\n  <dependencies>\n    <dependency>\n      <groupId>com.atlassian.bamboo</groupId>\n      <artifactId>bamboo-specs-api</artifactId>\n    </dependency>\n    <dependency>\n      <groupId>com.atlassian.bamboo</groupId>\n      <artifactId>bamboo-specs</artifactId>\n    </dependency>\n\n    <!-- Test dependencies -->\n    <dependency>\n      <groupId>junit</groupId>\n      <artifactId>junit</artifactId>\n      <scope>test</scope>\n    </dependency>\n  </dependencies>\n\n  <!-- run 'mvn test' to perform offline validation of the plan -->\n  <!-- run 'mvn -Ppublish-specs' to upload the plan to your Bamboo server -->\n</project>\n";
    private static final String PLAN = "plan";
    private static final String DEPLOYMENT = "deployment";
    private static final String REPOSITORY = "repository";
    private static final String CREDENTIALS = "credentials";
    private final String TEST_CLASS_CODE = "package %s;\n\nimport %s;\nimport com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;\nimport com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;\nimport org.junit.Test;\n\npublic class %sTest {\n    @Test\n    public void testSpecsOffline() throws PropertiesValidationException {\n        %s %s = new %s().%s();\n\n        EntityPropertiesBuilders.build(%s);\n    }\n}\n";
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String ID_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern FQCN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
    private static final Pattern ALPHA_NUMERIC_DASH = Pattern.compile("\\w[\\w\\-]*");
    @Inject
    private ServletContext servletContext;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private PlanConfigExportService planConfigExportService;
    @Inject
    private PlanPermissionService planPermissionService;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private DeploymentExportService deploymentExportService;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private RepositoryExporter repositoryExporter;
    @Inject
    private CredentialsManager credentialsManager;
    @Inject
    private CredentialsExportService credentialsExportService;
    private Path destinationPath;
    private String destination = SystemDirectory.getConfigurationExportsDirectory().getAbsolutePath();
    private String packageName = "my.bamboo.export";
    private String org = "my.org";
    private String projectName = "myBamboo";
    private Path projectRoot;
    private Path packageRootPath;
    private Path packageTestRootPath;
    private String archiveFile;
    private boolean exportCredentials;
    private boolean exportLinkedRepositories;

    @VisibleForTesting
    public static boolean isInvalidJavaIdentifier(@NotNull String identifier) {
        return !FQCN.matcher(identifier).matches();
    }

    public void validate() {
        super.validate();
        if (StringUtils.isBlank((CharSequence)this.packageName)) {
            this.addFieldError("packageName", "Package name must not be empty");
        } else if (ExportWorldToSpecs.isInvalidJavaIdentifier(this.packageName)) {
            this.addFieldError("packageName", "Package name must be valid Java package identifier");
        }
        if (StringUtils.isBlank((CharSequence)this.org)) {
            this.addFieldError("org", "Group id must not be empty");
        } else if (ExportWorldToSpecs.isInvalidJavaIdentifier(this.org)) {
            this.addFieldError("org", "Group id must be valid Java package identifier");
        }
        if (StringUtils.isBlank((CharSequence)this.projectName)) {
            this.addFieldError("projectName", "Project name cannot be empty");
        } else if (!ALPHA_NUMERIC_DASH.matcher(this.projectName).matches()) {
            this.addFieldError("projectName", "Project name must consist of alphanumeric characters, underscore (_) or dash (-)");
        }
    }

    public String execute() throws Exception {
        try {
            ArrayList<File> files = new ArrayList<File>();
            this.destinationPath = Paths.get(this.destination, new String[0]);
            this.projectRoot = this.destinationPath.resolve(this.projectName);
            String packagePath = this.packageName.replace(".", File.separator);
            this.packageRootPath = this.projectRoot.resolve("src/main/java").resolve(packagePath);
            this.packageTestRootPath = this.projectRoot.resolve("src/test/java").resolve(packagePath);
            BambooPathUtils.deleteDirectory((Path)this.projectRoot);
            Files.createDirectories(this.projectRoot, new FileAttribute[0]);
            files.add(this.writeStringToFile(this.projectRoot, "pom.xml", String.format(POM_CONTENT, BambooSpecVersion.getModelVersion(), this.org, this.projectName)));
            Files.createDirectories(this.packageRootPath, new FileAttribute[0]);
            Files.createDirectories(this.packageTestRootPath, new FileAttribute[0]);
            String projectPackage = this.packageName + "." + PROJECT;
            Path projectPackagePath = this.packageRootPath.resolve(PROJECT);
            Path projectTestPackagePath = this.packageTestRootPath.resolve(PROJECT);
            Files.createDirectory(projectPackagePath, new FileAttribute[0]);
            Files.createDirectory(projectTestPackagePath, new FileAttribute[0]);
            HashMap usedPlanNamesPerProjects = new HashMap();
            for (ImmutableTopLevelPlan plan : this.cachedPlanManager.getPlans()) {
                try {
                    String planPackageName = this.getJavaName(plan.getProject().getName(), new HashSet<String>());
                    Path planPackagePath = projectPackagePath.resolve(planPackageName);
                    Path planTestPackagePath = projectTestPackagePath.resolve(planPackageName);
                    if (!usedPlanNamesPerProjects.containsKey(planPackageName)) {
                        usedPlanNamesPerProjects.put(planPackageName, new HashSet());
                        Files.createDirectory(planPackagePath, new FileAttribute[0]);
                        Files.createDirectory(planTestPackagePath, new FileAttribute[0]);
                    }
                    String className = this.getJavaName(plan.getBuildName(), (Set)usedPlanNamesPerProjects.get(planPackageName));
                    String fullPackageName = projectPackage + "." + planPackageName;
                    String code = this.exportPlanCode(plan, fullPackageName, className);
                    files.add(this.writeStringToFile(planPackagePath, this.getJavaFileNameForClass(className), code));
                    String testCode = this.createTestClassCode(fullPackageName, Plan.class, className, PLAN);
                    files.add(this.writeStringToFile(planTestPackagePath, this.getJavaFileNameForClass(this.getTestClassName(className)), testCode));
                }
                catch (Exception e) {
                    log.error(null, (Throwable)e);
                }
            }
            this.exportItems(DEPLOYMENT, () -> ((DeploymentProjectService)this.deploymentProjectService).getAllDeploymentProjects(), InternalDeploymentProject::getName, this::exportDeploymentCode, Deployment.class, files);
            if (this.exportLinkedRepositories) {
                this.exportItems(REPOSITORY, () -> ((RepositoryDefinitionManager)this.repositoryDefinitionManager).getLinkedRepositories(), DescriptionProvider::getName, this.singleItemExporter(r -> this.repositoryExporter.toSpecsEntity(r, VcsRepositoryContextImpl.emptyContext()), REPOSITORY), VcsRepository.class, files);
            }
            if (this.exportCredentials) {
                this.exportItems(CREDENTIALS, () -> ((CredentialsManager)this.credentialsManager).getAllCredentials(), CredentialsData::getName, this.singleItemExporter(arg_0 -> ((CredentialsExportService)this.credentialsExportService).toSpecsEntity(arg_0), CREDENTIALS), SharedCredentials.class, files);
            }
            String archiveFile = this.destinationPath + File.separator + this.projectName + ".zip";
            BambooPathUtils.deleteQuietly((Path)Paths.get(archiveFile, new String[0]));
            ArchiveUtils.compressFiles((ArchiverType)ArchiverType.ZIP, files, (File)new File(archiveFile), (File)this.destinationPath.toFile());
            this.archiveFile = archiveFile;
        }
        catch (Exception e) {
            log.error((Object)"Export failed", (Throwable)e);
            return "error";
        }
        return super.execute();
    }

    private <I, T extends EntityPropertiesBuilder<?>> void exportItems(String objectTypeName, Supplier<? extends Iterable<I>> itemSupplier, Function<I, String> nameProvider, Exporter<I> exporter, Class<T> exportedItemClass, List<File> files) throws Exception {
        HashSet<String> usedNames = new HashSet<String>();
        String itemPackageName = this.packageName + "." + objectTypeName;
        Path itemPackagePath = this.packageRootPath.resolve(objectTypeName);
        Path itemTestPackagePath = this.packageTestRootPath.resolve(objectTypeName);
        Files.createDirectory(itemPackagePath, new FileAttribute[0]);
        Files.createDirectory(itemTestPackagePath, new FileAttribute[0]);
        for (I item : itemSupplier.get()) {
            try {
                String className = this.getJavaName(nameProvider.apply(item), usedNames);
                String code = exporter.export(item, itemPackageName, className);
                files.add(this.writeStringToFile(itemPackagePath, this.getJavaFileNameForClass(className), code));
                String testCode = this.createTestClassCode(itemPackageName, exportedItemClass, className, objectTypeName);
                files.add(this.writeStringToFile(itemTestPackagePath, this.getJavaFileNameForClass(this.getTestClassName(className)), testCode));
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
            }
        }
    }

    @NotNull
    private String getTestClassName(String className) {
        return className + "Test";
    }

    @NotNull
    private String getJavaFileNameForClass(String className) {
        return className + JAVA_FILE_EXTENSION;
    }

    private File writeStringToFile(Path packagePath, String fileName, String code) throws IOException {
        Path javaFile = packagePath.resolve(fileName);
        FileUtils.saveTextFile((String)code, (File)javaFile.toFile());
        return javaFile.toFile();
    }

    private String exportDeploymentCode(DeploymentProject deploymentProject, String packageName, String className) throws CodeGenerationException {
        EntityProperties e = EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportDeploymentToSpecs(deploymentProject));
        BambooSpecsGenerator specGenerator = new BambooSpecsGenerator();
        specGenerator.addEntity(DEPLOYMENT, e);
        specGenerator.addEntity("deploymentPermission", EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportDeploymentPermissions(deploymentProject)));
        int index = 1;
        for (Environment environment : deploymentProject.getEnvironments()) {
            specGenerator.addEntity("environmentPermission" + index, EntityPropertiesBuilders.build((EntityPropertiesBuilder)this.deploymentExportService.exportEnvironmentPermissions(deploymentProject, environment)));
            ++index;
        }
        return specGenerator.emitCode(this.getBaseUrl(), packageName, className);
    }

    private String exportPlanCode(ImmutableTopLevelPlan immutableTopLevelPlan, String packageName, String className) throws CodeGenerationException {
        Plan plan = this.planConfigExportService.exportPlanToSpecs(immutableTopLevelPlan);
        PlanProperties planProperties = (PlanProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan);
        PlanIdentifierProperties planIdentifierProperties = (PlanIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan.getIdentifier());
        BambooSpecsGenerator specGenerator = new BambooSpecsGenerator();
        specGenerator.addEntity(PLAN, (EntityProperties)planProperties);
        PlanPermissionsProperties planPermissionProperties = this.planPermissionService.exportPlanPermission(planIdentifierProperties);
        specGenerator.addEntity("planPermission", (EntityProperties)planPermissionProperties);
        return specGenerator.emitCode(this.getBaseUrl(), packageName, className);
    }

    private <I> Exporter<I> singleItemExporter(Function<I, ? extends EntityPropertiesBuilder<?>> specConverter, String objectTypeName) {
        return (i, packageName, className) -> {
            EntityPropertiesBuilder builder = (EntityPropertiesBuilder)specConverter.apply(i);
            EntityProperties properties = EntityPropertiesBuilders.build((EntityPropertiesBuilder)builder);
            BambooSpecsGenerator specGenerator = new BambooSpecsGenerator();
            specGenerator.addEntity(objectTypeName, properties);
            return specGenerator.emitCode(this.getBaseUrl(), packageName, className);
        };
    }

    private String createTestClassCode(String packageName, Class<?> entityClass, String className, String objectName) {
        return String.format("package %s;\n\nimport %s;\nimport com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;\nimport com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;\nimport org.junit.Test;\n\npublic class %sTest {\n    @Test\n    public void testSpecsOffline() throws PropertiesValidationException {\n        %s %s = new %s().%s();\n\n        EntityPropertiesBuilders.build(%s);\n    }\n}\n", packageName, entityClass.getCanonicalName(), className, entityClass.getSimpleName(), objectName, className, objectName, objectName);
    }

    private String getJavaName(String bambooObjectName, Set<String> usedNames) {
        String name;
        String baseName = name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, bambooObjectName.replaceAll("\\W+", "_"));
        int index = 0;
        while (usedNames.contains(name.toUpperCase())) {
            name = baseName + "_" + index;
            ++index;
        }
        usedNames.add(name.toUpperCase());
        return name;
    }

    public String getArchiveFile() {
        return this.archiveFile;
    }

    public String getDownloadUrl() {
        return this.getBaseUrl() + "/bambooSpecsExport/" + this.projectName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isExportCredentials() {
        return this.exportCredentials;
    }

    public void setExportCredentials(boolean exportCredentials) {
        this.exportCredentials = exportCredentials;
    }

    public boolean isExportLinkedRepositories() {
        return this.exportLinkedRepositories;
    }

    public void setExportLinkedRepositories(boolean exportLinkedRepositories) {
        this.exportLinkedRepositories = exportLinkedRepositories;
    }

    private static interface Exporter<I> {
        public String export(I var1, String var2, String var3) throws CodeGenerationException;
    }
}

