/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.notification;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.notification.SystemNotificationService;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.UrlBuilder;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureSystemNotifications
extends GlobalAdminAction {
    private List<NotificationRule> systemNotificationRules;
    private final Map<String, NotificationRecipient> notificationRecipients = new HashMap<String, NotificationRecipient>();
    private final Map<String, NotificationType> notificationTypes = new HashMap<String, NotificationType>();
    private String previousTypeData;
    private long lastModified;
    private String conditionKey;
    private String notificationRecipientType;
    private long notificationId;
    private String cancelButton;
    private String redirectUrl;
    private NotificationManager notificationManager;
    private InstantMessagingServerManager instantMessagingServerManager;
    private SystemNotificationService systemNotificationService;

    @Override
    public String doDefault() throws Exception {
        NotificationType notificationType;
        if (StringUtils.isNotBlank((CharSequence)this.previousTypeData) && (notificationType = this.notificationManager.getNotificationTypeFromKey(this.conditionKey)) != null) {
            notificationType.setConfigurationData(this.previousTypeData);
            this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        }
        return "input";
    }

    public String add() {
        if (this.cancelButton != null) {
            return "cancel";
        }
        this.validateNotification();
        if (this.hasAnyErrors()) {
            return "input";
        }
        try {
            NotificationRule newRule = this.notificationManager.createNotificationRuleFromAction(this.conditionKey, this.notificationRecipientType, ConfigureSystemNotifications.getActionParameters());
            this.systemNotificationService.saveSystemNotificationRule(newRule);
            this.lastModified = newRule.getId();
            this.previousTypeData = newRule.getConditionData();
            this.redirectUrl = new UrlBuilder().setUrl("/admin/viewSystemNotifications.action").addParameter("lastModified", (Number)this.lastModified).addParameter("conditionKey", this.conditionKey).addParameter("notificationRecipientType", this.notificationRecipientType).addParameter("previousTypeData", this.previousTypeData).toString();
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
    }

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject json = super.buildJsonObject();
        json.put("redirectUrl", (Object)this.redirectUrl);
        return json;
    }

    public String delete() {
        this.systemNotificationService.removeSystemNotificationRule(this.notificationId);
        return "success";
    }

    public String edit() {
        NotificationRule notificationRule = this.notificationManager.getNotificationRuleById(this.notificationId);
        if (notificationRule == null) {
            this.addActionError("Could not find notification rule with id: " + this.notificationId);
            return "error";
        }
        this.notificationRecipientType = StringUtils.defaultString((String)notificationRule.getRecipientType());
        this.conditionKey = StringUtils.defaultString((String)notificationRule.getConditionKey());
        this.updateObjectsForEdit(notificationRule);
        this.lastModified = this.notificationId;
        return "input";
    }

    public String update() {
        this.validateNotification();
        if (this.hasAnyErrors()) {
            return "input";
        }
        try {
            NotificationRule newRule = this.notificationManager.createNotificationRuleFromAction(this.conditionKey, this.notificationRecipientType, ConfigureSystemNotifications.getActionParameters());
            this.systemNotificationService.removeSystemNotificationRule(this.notificationId);
            this.systemNotificationService.saveSystemNotificationRule(newRule);
            this.lastModified = newRule.getId();
            this.redirectUrl = "/admin/viewSystemNotifications.action?lastModified=" + this.getLastModified();
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
    }

    public List<NotificationType> getAllNotificationEventTypes() {
        return this.getNotificationTypes().values().stream().sorted(Comparator.comparing(NotificationType::getName, Comparator.naturalOrder())).collect(Collectors.toList());
    }

    public List<NotificationRecipient> getAllNotificationRecipientTypes() {
        return this.getAvailableRecipientTypes().values().stream().sorted().collect(Collectors.toList());
    }

    @Nullable
    public String getNotificationErrorMessageKey() {
        if (!this.isJabberServerConfigured()) {
            if (!this.isMailServerConfigured()) {
                return "notification.both.notConfigured";
            }
            return "notification.im.notConfigured";
        }
        if (!this.isMailServerConfigured()) {
            return "notification.mail.notConfigured";
        }
        return null;
    }

    @Nullable
    public String getNotificationAddServerKey() {
        if (!this.isJabberServerConfigured()) {
            if (!this.isMailServerConfigured()) {
                return "notification.both.add";
            }
            return "notification.im.add";
        }
        if (!this.isMailServerConfigured()) {
            return "notification.mail.add";
        }
        return null;
    }

    private static Map<String, String[]> getActionParameters() {
        return ActionParamsUtils.getStringArrayMap();
    }

    private void validateNotification() {
        NotificationType notificationType = this.notificationManager.getNotificationTypeFromKey(this.conditionKey);
        if (notificationType != null) {
            this.addErrorCollection(notificationType.validate(ConfigureSystemNotifications.getActionParameters()));
            if (this.hasAnyErrors()) {
                return;
            }
            this.getNotificationTypes().put(notificationType.getKey(), notificationType);
            notificationType.populate(ConfigureSystemNotifications.getActionParameters());
            String configData = notificationType.getConfigurationData();
            NotificationRecipient notificationRecipient = this.notificationManager.getNotificationRecipientFromKey(this.notificationRecipientType);
            this.addErrorCollection(notificationRecipient.validate(ConfigureSystemNotifications.getActionParameters()));
            this.getAvailableRecipientTypes().put(notificationRecipient.getKey(), notificationRecipient);
            NotificationRule newRule = this.notificationManager.createNotificationRule(this.conditionKey, configData, notificationRecipient.getRecipientConfig(), this.notificationRecipientType);
            NotificationRule oldRule = this.systemNotificationService.doesSystemNotificationSetContainRule(newRule);
            if (oldRule != null && this.notificationId != oldRule.getId()) {
                this.addActionError("Notification already exists");
            }
        } else {
            this.addActionError("Can not find matching notification type for key: " + this.conditionKey);
        }
    }

    private void updateObjectsForEdit(NotificationRule rule) {
        NotificationRecipient notificationRecipient;
        NotificationType notificationType = this.notificationManager.getNotificationType(rule);
        if (notificationType != null) {
            this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        }
        if ((notificationRecipient = this.notificationManager.getNotificationRecipient(rule)) != null) {
            this.getAvailableRecipientTypes().put(notificationRecipient.getKey(), notificationRecipient);
        }
    }

    private boolean isMailServerConfigured() {
        return this.getMailServerManager().isDefaultSMTPMailServerDefined();
    }

    private MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    private boolean isJabberServerConfigured() {
        Collection instantMessagingServers = this.instantMessagingServerManager.getAllInstantMessagingServers();
        return !instantMessagingServers.isEmpty();
    }

    private Map<String, NotificationRecipient> getAvailableRecipientTypes() {
        if (this.notificationRecipients.isEmpty()) {
            this.notificationManager.getAllNotificationRecipients().stream().filter(recipient -> recipient.getScopes().isEmpty() || recipient.getScopes().contains(NotificationRecipient.Scope.SYSTEM)).forEach(recipient -> this.notificationRecipients.put(recipient.getKey(), (NotificationRecipient)recipient));
        }
        return this.notificationRecipients;
    }

    private Map<String, NotificationType> getNotificationTypes() {
        if (this.notificationTypes.isEmpty()) {
            List notificationTypeObjects = this.notificationManager.getSystemNotificationTypes();
            for (NotificationType type : notificationTypeObjects) {
                this.notificationTypes.put(type.getKey(), type);
            }
        }
        return this.notificationTypes;
    }

    public void setConditionKey(String conditionKey) {
        this.conditionKey = conditionKey;
    }

    public void setNotificationRecipientType(String notificationRecipientType) {
        this.notificationRecipientType = notificationRecipientType;
    }

    public Map<String, NotificationRecipient> getNotificationRecipients() {
        return this.notificationRecipients;
    }

    public String getPreviousTypeData() {
        return this.previousTypeData;
    }

    public String getConditionKey() {
        return this.conditionKey;
    }

    public String getNotificationRecipientType() {
        return this.notificationRecipientType;
    }

    public List<NotificationRule> getSystemNotificationRules() {
        if (this.systemNotificationRules == null) {
            this.systemNotificationRules = this.systemNotificationService.getSystemNotificationRules();
        }
        return this.systemNotificationRules;
    }

    public void setSystemNotificationService(SystemNotificationService systemNotificationService) {
        this.systemNotificationService = systemNotificationService;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setInstantMessagingServerManager(InstantMessagingServerManager instantMessagingServerManager) {
        this.instantMessagingServerManager = instantMessagingServerManager;
    }

    public void setCancelButton(String cancelButton) {
        this.cancelButton = cancelButton;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getNotificationId() {
        return this.notificationId;
    }

    public void setPreviousTypeData(String previousTypeData) {
        this.previousTypeData = previousTypeData;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }
}

