/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.migration;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.container.BambooContainer;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionServiceInternal;
import com.atlassian.bamboo.index.IndexerManager;
import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ImportExportManager;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.svn.SVNClientManagerFactory;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.security.LogoutSupport;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.UpgradeLauncher;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.util.Resettable;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.web.utils.JohnsonEventContainerHolder;
import com.atlassian.bamboo.ww2.actions.admin.migration.AbstractMigrationAction;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.cache.CacheManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork2.TextProvider;
import java.io.File;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class Import
extends AbstractMigrationAction {
    private static final Logger log = Logger.getLogger(Import.class);
    private static final String BACKUP_PATH_FIELD_NAME = "backupPath";
    private static final String PATH_FIELD_NAME = "path";
    private String path;
    private String backupFileName;
    private boolean backupSelected;
    private boolean hotSwapSelected;
    private String backupPath;
    private boolean clearArtifacts;
    private AgentManager agentManager;
    private AdminErrorHandler adminErrorHandler;
    private ImportExportManager importExportManager;
    private BootstrapManager bootstrapManager;
    private TextProvider textProvider;
    private IndexerManager indexerManager;
    private SVNClientManagerFactory svnClientManagerFactory;
    private Resettable reloadableBeanFactories;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private BandanaPersister bandanaPersister;
    @Autowired
    private SecretEncryptionServiceInternal secretEncryptionServiceInternal;
    @Inject
    private CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;

    @Override
    public String doDefault() throws Exception {
        this.backupPath = this.getDefaultMigrationLocation();
        this.backupFileName = this.getDefaultBackpuFileName();
        return "input";
    }

    public String confirm() throws Exception {
        return "confirm";
    }

    public void validate() {
        if (!TextUtils.stringSet((String)this.getPath())) {
            this.addFieldError(PATH_FIELD_NAME, this.getText("import.path.error.required"));
        } else {
            this.validateFileExists(this.getPath(), PATH_FIELD_NAME);
            try {
                this.importExportManager.validateImport(this.getPath());
            }
            catch (Exception e) {
                this.addFieldError(PATH_FIELD_NAME, this.getText("import.path.error.importNotValid", Arrays.asList(e.getMessage())));
            }
        }
        if (this.backupSelected) {
            if (StringUtils.isBlank((CharSequence)this.getBackupFileName())) {
                this.addFieldError("backupFileName", this.getText("import.filename.error.required"));
                return;
            }
            this.validatePathIfSetByUser(this.getBackupPath(), BACKUP_PATH_FIELD_NAME);
            if (!this.validateMigrationLocation(this.getBackupPath(), BACKUP_PATH_FIELD_NAME, this.getBackupFileName(), "backupFileName")) {
                return;
            }
        }
    }

    public String execute() throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.backupSelected) {
            try {
                ExportDetailsBean exportDetails = new ExportDetailsBean();
                exportDetails.setPath(this.getBackupCanonicalPath());
                this.importExportManager.bambooExport(exportDetails);
            }
            catch (Exception e) {
                this.addActionError(this.getText("import.error.backup.failed", new String[]{e.getMessage()}));
                log.error((Object)e.toString());
                log.debug(null, (Throwable)e);
                return "input";
            }
        }
        try {
            HttpServletRequest httpServletRequest = RequestCacheThreadLocal.getNonNullRequest();
            HttpServletResponse httpServletResponse = RequestCacheThreadLocal.getNonNullResponse();
            LogoutSupport.logout(httpServletRequest, httpServletResponse);
            ImpersonationHelper.runWithSystemAuthority(() -> this.performImport(startTime));
            return "success";
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performImport(long startTime) throws Exception {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform import");
        this.agentManager.stopLocalAgents();
        this.cachedRepositoryDefinitionManager.disableCache();
        this.importExportManager.bambooImport(this.getPath(), this.clearArtifacts);
        this.importExportManager.bambooOsgiDependentImport(this.getPath());
        this.importExportManager.resetGenerators();
        JohnsonEventContainer johnsonEventContainer = JohnsonEventContainerHolder.getInstance();
        if (this.hotSwapSelected) {
            Event appEvent = new Event(EventType.get((String)"import"), this.textProvider.getText("import.hotrestart"), EventLevel.get((String)"warning"));
            try {
                johnsonEventContainer.addEvent(appEvent);
                BambooContainer bambooContainer = BambooContainer.getBambooContainer();
                bambooContainer.prepareForRestart();
                this.cacheManager.flushCaches();
                this.sessionFactory.getCache().evictQueryRegions();
                this.sessionFactory.getCache().evictDefaultQueryRegion();
                this.bandanaPersister.flushCaches();
                this.secretEncryptionServiceInternal.reloadCipher();
                UpgradeLauncher.upgradeAndStartBamboo(ServletActionContext.getServletContext(), false);
                this.indexerManager.setPendingFullReindex();
                this.reloadableBeanFactories.reset();
                this.svnClientManagerFactory.destroy();
                this.cachedRepositoryDefinitionManager.initialiseCache();
            }
            finally {
                johnsonEventContainer.removeEvent(appEvent);
            }
        } else {
            this.indexerManager.setPendingFullReindex();
            Event event = new Event(EventType.get((String)"import"), this.textProvider.getText("import.complete.restart"), EventLevel.get((String)"warning"));
            johnsonEventContainer.addEvent(event);
            this.addActionMessage(this.getText("import.complete", new String[]{this.getPath(), Long.toString((System.currentTimeMillis() - startTime) / 1000L)}));
        }
    }

    @Override
    public String getDefaultMigrationLocation() {
        return this.bootstrapManager.getApplicationHome() + File.separator + "backups";
    }

    public String getDefaultBackpuFileName() {
        return "backup.zip";
    }

    public String getDefaultExportPath() {
        return this.bootstrapManager.getApplicationHome() + File.separator + "export.zip";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    public void setBackupFileName(String backupFileName) {
        this.backupFileName = backupFileName;
    }

    public boolean isBackupSelected() {
        if (!this.isCheckboxSetInAction("backupSelected")) {
            return true;
        }
        return this.backupSelected;
    }

    public void setBackupSelected(boolean backupSelected) {
        this.backupSelected = backupSelected;
    }

    public String getBackupPath() {
        if (this.isPathManipulationAllowed()) {
            return this.backupPath;
        }
        return this.getDefaultMigrationLocation();
    }

    public void setBackupPath(String backupPath) {
        this.backupPath = backupPath;
    }

    @NotNull
    public String getBackupCanonicalPath() {
        return this.getCanonicalFileName(this.getBackupPath(), this.getBackupFileName());
    }

    public boolean isHotSwapSelected() {
        return this.hotSwapSelected;
    }

    public void setHotSwapSelected(boolean hotSwapSelected) {
        this.hotSwapSelected = hotSwapSelected;
    }

    public boolean isClearArtifacts() {
        return this.clearArtifacts;
    }

    public void setClearArtifacts(boolean clearArtifacts) {
        this.clearArtifacts = clearArtifacts;
    }

    public AdminErrorHandler getAdminErrorHandler() {
        return this.adminErrorHandler;
    }

    public void setAdminErrorHandler(AdminErrorHandler adminErrorHandler) {
        this.adminErrorHandler = adminErrorHandler;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setIndexerManager(IndexerManager indexerManager) {
        this.indexerManager = indexerManager;
    }

    public void setSvnClientManagerFactory(SVNClientManagerFactory svnClientManagerFactory) {
        this.svnClientManagerFactory = svnClientManagerFactory;
    }

    public void setReloadableBeanFactories(Resettable reloadableBeanFactories) {
        this.reloadableBeanFactories = reloadableBeanFactories;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }
}

