/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.migration;

import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ImportExportManagerImpl;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.ww2.actions.admin.migration.AbstractMigrationAction;
import com.atlassian.core.util.DateUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Export
extends AbstractMigrationAction {
    private static final Logger log = Logger.getLogger(Export.class);
    private static final String EXPORT_DIRECTORY = "exports";
    private static final String PATH_FIELD_NAME = "path";
    private static final String FILENAME_FIELD_NAME = "filename";
    private String path;
    private String filename;
    private boolean exportResults;
    private boolean exportArtifacts;
    private boolean exportBuildLogs;
    private BootstrapManager bootstrapManager;
    private ImportExportManagerImpl importExportManager;

    @Override
    public String doDefault() throws Exception {
        this.path = this.getDefaultMigrationLocation();
        this.filename = this.getDefaultExportFilename();
        return super.doDefault();
    }

    public void validate() {
        String canonicalPath = this.getCanonicalFileName(this.getPath(), this.getFilename());
        File canonicalFile = new File(canonicalPath);
        File parentDir = canonicalFile.getParentFile();
        if (StringUtils.isBlank((CharSequence)this.getFilename())) {
            this.addFieldError(FILENAME_FIELD_NAME, this.getText("export.filename.error.required"));
            return;
        }
        String exportPath = this.getPath();
        this.validatePathIfSetByUser(exportPath, PATH_FIELD_NAME);
        if (!this.validateMigrationLocation(this.getPath(), PATH_FIELD_NAME, this.getFilename(), FILENAME_FIELD_NAME)) {
            return;
        }
        if (!(!parentDir.exists() || parentDir.isDirectory() && parentDir.canWrite())) {
            this.addActionError(this.getText("export.error.permission.denied", new String[]{canonicalPath}));
        }
        if (canonicalFile.exists()) {
            this.addFieldError(FILENAME_FIELD_NAME, this.getText("export.filename.already.exists", new String[]{this.getDefaultMigrationLocation()}));
        }
    }

    public String execute() throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            ExportDetailsBean exportDetails = new ExportDetailsBean();
            String exportFilename = this.getCanonicalFileName(this.getPath(), this.getFilename());
            exportDetails.setPath(exportFilename);
            exportDetails.setExportArtifacts(this.isExportArtifacts());
            exportDetails.setExportBuildLogs(this.isExportBuildLogs());
            exportDetails.setExportResults(this.isExportResults());
            exportDetails.setAwaitJobCompletion(false);
            this.importExportManager.bambooExport(exportDetails);
            this.addActionMessage(this.getText("export.complete", new String[]{exportFilename, new DateUtils(ResourceBundle.getBundle("com.atlassian.bamboo.ww2.BambooActionSupport")).formatDurationPretty((System.currentTimeMillis() - startTime) / 1000L)}));
        }
        catch (Exception e) {
            this.addActionError(this.getText("export.error.failed", new String[]{e.getMessage()}));
            log.error((Object)e, (Throwable)e);
            return "input";
        }
        return "success";
    }

    @Override
    public String getDefaultMigrationLocation() {
        return this.getBootstrapManager().getApplicationHome() + File.separator + EXPORT_DIRECTORY;
    }

    public String getDefaultExportFilename() {
        String instanceName = this.getInstanceName();
        String filePrefix = StringUtils.isNotBlank((CharSequence)instanceName) ? "export_" + BambooStringUtils.forceAlphaNumeric((String)instanceName).toLowerCase() : "export";
        return filePrefix + "_" + BuildUtils.getCurrentBuildNumber() + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".zip";
    }

    public String getPath() {
        if (this.isPathManipulationAllowed()) {
            return this.path;
        }
        return this.getDefaultMigrationLocation();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setImportExportManager(ImportExportManagerImpl importExportManager) {
        this.importExportManager = importExportManager;
    }

    public boolean isExportArtifacts() {
        return this.exportArtifacts;
    }

    public void setExportArtifacts(boolean exportArtifacts) {
        this.exportArtifacts = exportArtifacts;
    }

    public boolean isExportBuildLogs() {
        if (!this.isCheckboxSetInAction("exportBuildLogs")) {
            return true;
        }
        return this.exportBuildLogs;
    }

    public void setExportBuildLogs(boolean exportBuildLogs) {
        this.exportBuildLogs = exportBuildLogs;
    }

    public boolean isExportResults() {
        if (!this.isCheckboxSetInAction("exportResults")) {
            return true;
        }
        return this.exportResults;
    }

    public void setExportResults(boolean exportResults) {
        this.exportResults = exportResults;
    }
}

