/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.migration;

import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.ScheduleBackupBeanImpl;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plan.branch.BranchExpiryScheduler;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.ww2.actions.admin.migration.AbstractMigrationAction;
import com.atlassian.core.cron.generator.CronExpressionDescriptor;
import com.atlassian.core.cron.parser.CronExpressionParser;
import com.atlassian.core.i18n.I18nTextProvider;
import com.opensymphony.util.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;

public class Backup
extends AbstractMigrationAction {
    private static final Logger log = Logger.getLogger(Backup.class);
    public static final String DEFAULT_CRON_EXPRESSION = "0 0 0 ? * 7";
    private static final String BACKUP_PATH_FIELD_NAME = "backupPath";
    private String backupPath;
    private String fileDateFormat = "yyyy_MM_dd";
    private String filePrefix = "bamboo_backup_";
    private String fileExample;
    private String backupCronExpression = "0 0 0 ? * 7";
    private String backupDisabled = "false";
    private String exportArtifacts = "false";
    private String awaitJobCompletion = "false";
    private String backupConfigured;
    private ScheduleBackupBeanImpl scheduleBackupBeanImpl;
    private BootstrapManager bootstrapManager;
    private static final String VIEW = "view";

    @Override
    public String doDefault() {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfig();
        ScheduleBackupConfiguration backupProperties = administrationConfiguration.getScheduleBackupConfiguration();
        if (backupProperties == null) {
            this.setBackupConfigured(Boolean.toString(false));
        } else {
            this.setBackupConfigured(Boolean.toString(true));
            this.backupPath = backupProperties.getBackupPath(this.bootstrapManager.getApplicationHome());
            this.setBackupCronExpression(backupProperties.getBackupCronExpression());
            this.setFilePrefix(backupProperties.getBackupFilePrefix());
            this.setFileDateFormat(backupProperties.getBackupFileFormat());
            this.setBackupDisabled(Boolean.toString(backupProperties.isDisabled()));
            this.setExportArtifacts(backupProperties.isExportArtifacts() ? "Yes" : "No");
            this.setAwaitJobCompletion(backupProperties.isAwaitJobCompletion() ? "Yes" : "No");
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.fileDateFormat);
            String today = dateFormat.format(new Date());
            this.setFileExample(this.filePrefix + today + ".zip");
        }
        return VIEW;
    }

    public String edit() {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfig();
        ScheduleBackupConfiguration backupProperties = administrationConfiguration.getScheduleBackupConfiguration();
        if (backupProperties != null) {
            this.backupPath = backupProperties.getBackupPath(this.bootstrapManager.getApplicationHome());
            this.setBackupCronExpression(backupProperties.getBackupCronExpression());
            this.setFilePrefix(backupProperties.getBackupFilePrefix());
            this.setFileDateFormat(backupProperties.getBackupFileFormat());
            this.setBackupDisabled(Boolean.toString(backupProperties.isDisabled()));
            this.setExportArtifacts(Boolean.toString(backupProperties.isExportArtifacts()));
            this.setAwaitJobCompletion(Boolean.toString(backupProperties.isAwaitJobCompletion()));
        }
        return "input";
    }

    public String save() {
        ScheduleBackupConfiguration backupConfig = new ScheduleBackupConfiguration();
        backupConfig.setBackupFileFormat(this.fileDateFormat);
        backupConfig.setBackupFilePrefix(this.filePrefix);
        backupConfig.setBackupCronExpression(this.backupCronExpression);
        backupConfig.setBackupPath(this.backupPath);
        backupConfig.setDisabled(Boolean.parseBoolean(this.backupDisabled));
        backupConfig.setExportArtifacts(Boolean.parseBoolean(this.exportArtifacts));
        backupConfig.setAwaitJobCompletion(Boolean.parseBoolean(this.awaitJobCompletion));
        try {
            this.getScheduleBackupBean().scheduleBackup(backupConfig);
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfig();
        administrationConfiguration.setScheduleBackupConfiguration(backupConfig);
        this.getDefaultPersister().saveAdministrationConfiguration(administrationConfiguration);
        return "success";
    }

    public void validate() {
        if (!TextUtils.stringSet((String)this.getBackupPath())) {
            this.addFieldError(BACKUP_PATH_FIELD_NAME, this.getText("backup.path.error.blank"));
        }
        if (!TextUtils.stringSet((String)this.getFilePrefix())) {
            this.addFieldError("filePrefix", this.getText("backup.prefix.error.blank"));
        }
        if (!this.hasErrors()) {
            this.validatePathIfSetByUser(this.getBackupPath(), BACKUP_PATH_FIELD_NAME);
            if (!this.validateMigrationLocation(this.getBackupPath(), BACKUP_PATH_FIELD_NAME, this.getFilePrefix(), "filePrefix")) {
                return;
            }
        }
        if (StringUtils.isBlank((CharSequence)this.getFileDateFormat())) {
            this.addFieldError("fileDateFormat", this.getText("backup.format.error.blank"));
        }
        try {
            new SimpleDateFormat(this.getFileDateFormat());
        }
        catch (IllegalArgumentException e) {
            this.addFieldError("fileDateFormat", this.getText("backup.format.error.invalid"));
        }
        if (StringUtils.isEmpty((CharSequence)this.backupCronExpression)) {
            this.addFieldError("backupCronExpression", this.getText("backup.cronExpression.error.blank"));
        } else {
            try {
                CronExpression cronExpr = new CronExpression(this.backupCronExpression);
                cronExpr.getNextValidTimeAfter(new Date());
            }
            catch (ParseException e) {
                this.addFieldError("backupCronExpression", this.getText("backup.cronExpression.error.invalid"));
            }
            catch (UnsupportedOperationException e) {
                this.addFieldError("backupCronExpression", this.getText("backup.cronExpression.error.unsupported"));
            }
            catch (Exception e) {
                this.addFieldError("cronEditorBean.cronString", this.getText("backup.cronExpression.error.failure"));
                log.error((Object)"Validation of Cron Expression Failed", (Throwable)e);
            }
        }
    }

    public Date getNextFireTime() {
        try {
            CronExpression cronExpression = new CronExpression(this.backupCronExpression);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).build();
            return trigger.getFireTimeAfter(new Date());
        }
        catch (ParseException e) {
            log.warn((Object)("Unable to parse cron expression:" + this.backupCronExpression), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getDefaultMigrationLocation() {
        return ScheduleBackupConfiguration.getDefaultBackupDirectory((String)this.bootstrapManager.getApplicationHome());
    }

    public String getBackupPath() {
        return this.backupPath != null ? this.backupPath : this.getDefaultMigrationLocation();
    }

    public void setBackupPath(String backupPath) {
        if (this.isPathManipulationAllowed()) {
            this.backupPath = backupPath;
        }
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getBackupDisabled() {
        return this.backupDisabled;
    }

    public void setBackupDisabled(String backupDisabled) {
        this.backupDisabled = backupDisabled;
    }

    public String getBackupCronExpression() {
        return this.backupCronExpression;
    }

    public void setBackupCronExpression(String backupCronExpression) {
        this.backupCronExpression = backupCronExpression;
    }

    public String getFileExample() {
        return this.fileExample;
    }

    public void setFileExample(String fileExample) {
        this.fileExample = fileExample;
    }

    private AdministrationConfiguration getAdministrationConfig() {
        Persister defaultPersister = this.getDefaultPersister();
        return defaultPersister.getAdministrationConfiguration();
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public ScheduleBackupBeanImpl getScheduleBackupBean() {
        return this.scheduleBackupBeanImpl;
    }

    public void setScheduleBackupBean(ScheduleBackupBeanImpl scheduleBackupBeanImpl) {
        this.scheduleBackupBeanImpl = scheduleBackupBeanImpl;
    }

    public String getExportArtifacts() {
        return this.exportArtifacts;
    }

    public void setExportArtifacts(String exportArtifacts) {
        this.exportArtifacts = exportArtifacts;
    }

    public String getAwaitJobCompletion() {
        return this.awaitJobCompletion;
    }

    public void setAwaitJobCompletion(String awaitJobCompletion) {
        this.awaitJobCompletion = awaitJobCompletion;
    }

    public String getBackupConfigured() {
        return this.backupConfigured;
    }

    public void setBackupConfigured(String backupConfigured) {
        this.backupConfigured = backupConfigured;
    }

    @Nullable
    public String getBuildExpiryTime() {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfig();
        BuildExpiryConfig config = administrationConfiguration.getBuildExpiryConfig();
        if (config.isEnabled()) {
            String cron = config.getCronExpression();
            CronExpressionParser parser = new CronExpressionParser(cron);
            CronExpressionDescriptor descriptor = new CronExpressionDescriptor((I18nTextProvider)this);
            return descriptor.getPrettySchedule(parser.getCronEditorBean());
        }
        return null;
    }

    public String getBranchExpiryTime() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("h:mm a");
        return BranchExpiryScheduler.getBranchExpiryScheduledTime().format(dateTimeFormatter).toLowerCase();
    }
}

