/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.migration;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.utils.SystemProperty;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMigrationAction
extends GlobalAdminAction {
    public boolean isPathManipulationAllowed() {
        return SystemProperty.PATH_SET_ALLOWED;
    }

    @NotNull
    protected String getCanonicalFileName(@NotNull String path, @NotNull String filename) {
        String canonicalName = path + File.separator + filename;
        try {
            return new File(canonicalName).getCanonicalPath();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public abstract String getDefaultMigrationLocation();

    protected boolean validateFileExists(@NotNull String path, @NotNull String pathField) {
        File file = new File(path);
        if (!file.exists()) {
            this.addFieldError(pathField, this.getText("migration.file.error.nonexistant"));
            return false;
        }
        if (!file.isFile()) {
            this.addFieldError(pathField, this.getText("migration.path.error.file"));
            return false;
        }
        if (!file.canRead()) {
            this.addFieldError(pathField, this.getText("migration.path.error.read.permission"));
            return false;
        }
        return true;
    }

    protected boolean validateDirectoryExists(@NotNull String path, @NotNull String pathField) {
        File file = new File(path);
        if (!file.exists()) {
            this.addFieldError(pathField, this.getText("migration.path.error.nonexistant"));
            return false;
        }
        if (!file.isAbsolute()) {
            this.addFieldError(pathField, this.getText("migration.path.error.relative"));
            return false;
        }
        if (!file.isDirectory()) {
            this.addFieldError(pathField, this.getText("migration.path.error.directory"));
            return false;
        }
        if (!file.canWrite()) {
            this.addFieldError(pathField, this.getText("migration.path.error.write.permission"));
            return false;
        }
        return true;
    }

    protected boolean validateMigrationLocation(@NotNull String path, @NotNull String pathField, @NotNull String filename, @NotNull String fileField) {
        if (!this.isPathManipulationAllowed()) {
            if (!this.getCanonicalFileName(path, filename).startsWith(this.getDefaultMigrationLocation())) {
                this.addFieldError(fileField, this.getText("migration.error.forbidden.path"));
                return false;
            }
            if (new File(filename).getParent() != null) {
                this.addFieldError(fileField, this.getText("migration.error.forbidden.path"));
                return false;
            }
        }
        return true;
    }

    protected void validatePathIfSetByUser(String path, String fieldName) {
        if (this.isPathManipulationAllowed()) {
            this.validateDirectoryExists(path, fieldName);
        }
    }
}

