/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.mail;

import com.atlassian.bamboo.admin.configuration.MailConfigurationService;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.mail.BambooMailer;
import com.atlassian.bamboo.notification.EmailValidator;
import com.atlassian.bamboo.notification.PortValidator;
import com.atlassian.mail.server.SMTPMailServer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ConfigureMailServer
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ConfigureMailServer.class);
    private String name;
    private String from;
    private String prefix;
    private String userName;
    private String password;
    private String hostName;
    private String smtpPort;
    private String jndiName;
    private boolean removePrecedence;
    private boolean tlsRequired;
    private String passwordChange;
    private String isSendTest;
    private String testRecipient;
    private BambooMailer bambooMailer;
    private MailConfigurationService.MailMode chosenMailSetting;
    private MailConfigurationService mailConfigurationService;

    @Override
    public String doDefault() throws Exception {
        boolean isEmpty;
        boolean bl = isEmpty = !this.mailConfigurationService.isMailServerConfigured() || StringUtils.isBlank((CharSequence)this.mailConfigurationService.getMailServer().getName());
        if (isEmpty) {
            this.setName("Bamboo");
            this.setPrefix("[Bamboo]");
            return "edit";
        }
        this.populateFormFields(this.mailConfigurationService.getMailServer());
        return "input";
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            this.addFieldError("name", this.getText("config.email.server.name.error"));
        }
        if (StringUtils.isBlank((CharSequence)this.from)) {
            this.addFieldError("from", this.getText("config.email.from.error"));
        } else if (!EmailValidator.isValidEmailAddressFormat((String)this.from)) {
            this.addFieldError("from", this.getText("user.email.error.invalid"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.isSendTest) && StringUtils.isBlank((CharSequence)this.testRecipient)) {
            this.addFieldError("testRecipient", this.getText("config.email.test.recipient.error.required"));
        }
        if (this.chosenMailSetting != null) {
            if (MailConfigurationService.MailMode.SMTP == this.chosenMailSetting) {
                this.setJndiName(null);
                if (StringUtils.isBlank((CharSequence)this.hostName)) {
                    this.addFieldError("hostName", this.getText("config.email.error.requiredHost"));
                }
                if (!PortValidator.isValidPortNumber((String)this.smtpPort)) {
                    this.addFieldError("smtpPort", this.getText("config.email.smtp.port.error"));
                }
            }
            if (MailConfigurationService.MailMode.JNDI == this.chosenMailSetting) {
                this.setHostName(null);
                this.setSmtpPort(null);
                this.setUserName(null);
                this.setPassword(null);
                this.setTlsRequired(false);
                if (StringUtils.isBlank((CharSequence)this.jndiName)) {
                    this.addFieldError("jndiName", this.getText("config.email.error.requiredJndi"));
                } else {
                    this.mailConfigurationService.validateJndiLocation(this.jndiName).forEach(errorMessage -> this.addFieldError("jndiName", (String)errorMessage));
                }
            }
        }
    }

    public String edit() throws Exception {
        if (this.mailConfigurationService.isMailServerConfigured()) {
            SMTPMailServer currentMailServer = this.mailConfigurationService.getMailServer();
            this.populateFormFields(currentMailServer);
            if (this.isTesting()) {
                this.testSMTPServer(currentMailServer);
                return "input";
            }
            return "success";
        }
        return "error";
    }

    public String delete() throws Exception {
        if (this.mailConfigurationService.isMailServerConfigured()) {
            this.mailConfigurationService.deleteMailServer();
            return "success";
        }
        this.addActionError("Could not find a mail server to delete. Check that there is one configured");
        return "error";
    }

    public String testSMTPServer(SMTPMailServer testSmtpMailServer) throws Exception {
        String testEmailSubject = "Bamboo test email";
        try {
            this.bambooMailer.send("com/atlassian/bamboo/notification/TestMailServerEmail.ftl", new HashMap(), this.getRecipientList(), "Bamboo test email", testSmtpMailServer);
            this.addActionMessage("The mail settings are correct. A test email has been sent.");
        }
        catch (Exception e) {
            this.addActionError("The mail settings you entered were not valid.\nError thrown was:\n" + e.getMessage());
            log.error((Object)"Mail server test failed: ", (Throwable)e);
        }
        return "input";
    }

    public String save() throws Exception {
        String maybeSmtpPort = this.getChosenMailSetting() == MailConfigurationService.MailMode.SMTP ? (StringUtils.isNotBlank((CharSequence)this.getSmtpPort()) ? this.getSmtpPort() : "25") : null;
        String maybeSetPassword = !this.mailConfigurationService.isMailServerConfigured() || StringUtils.isEmpty((CharSequence)this.mailConfigurationService.getMailServer().getUsername()) || Boolean.parseBoolean(this.getPasswordChange()) ? this.getPassword() : null;
        this.mailConfigurationService.updateMailServer(this.getName(), this.getFrom(), this.getPrefix(), Boolean.valueOf(this.getRemovePrecedence()), this.getChosenMailSetting(), this.getHostName(), maybeSmtpPort, this.getUserName(), maybeSetPassword, Boolean.valueOf(this.isTlsRequired()), this.getJndiName());
        if (this.isTesting()) {
            this.testSMTPServer(this.mailConfigurationService.getMailServer());
            return "input";
        }
        return "success";
    }

    private void populateFormFields(SMTPMailServer config) {
        this.setName(config.getName());
        this.setFrom(config.getDefaultFrom());
        this.setPrefix(config.getPrefix());
        this.setUserName(config.getUsername());
        this.setHostName(config.getHostname());
        this.setJndiName(config.getJndiLocation());
        this.setTlsRequired(config.isTlsRequired());
        if (StringUtils.isBlank((CharSequence)config.getHostname())) {
            this.setChosenMailSetting(MailConfigurationService.MailMode.JNDI);
        } else {
            this.setChosenMailSetting(MailConfigurationService.MailMode.SMTP);
        }
        this.setRemovePrecedence(config.isRemovePrecedence());
        if (StringUtils.isNotBlank((CharSequence)config.getPort()) && !config.getPort().equals("25")) {
            this.setSmtpPort(config.getPort());
        }
    }

    private boolean isTesting() {
        String sendTest = this.getSendTest();
        return sendTest != null && (sendTest.equals(this.getText("global.buttons.test")) || sendTest.equals(this.getText("global.buttons.saveAndTest")));
    }

    private List<String> getRecipientList() {
        ArrayList<String> emailList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.getTestRecipient())) {
            String[] emailAddresses;
            for (String emailAddress : emailAddresses = this.getTestRecipient().split(",")) {
                emailList.add(StringUtils.trim((String)emailAddress));
            }
        }
        return emailList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.trim((String)name);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = StringUtils.trim((String)from);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRemovePrecedence(boolean removePrecedence) {
        this.removePrecedence = removePrecedence;
    }

    public boolean getRemovePrecedence() {
        return this.removePrecedence;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = StringUtils.trim((String)hostName);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = StringUtils.trim((String)jndiName);
    }

    public String getPasswordChange() {
        return this.passwordChange;
    }

    public void setPasswordChange(String passwordChange) {
        this.passwordChange = passwordChange;
    }

    public String getSendTest() {
        return this.isSendTest;
    }

    public void setSendTest(String sendTest) {
        this.isSendTest = sendTest;
    }

    public String getTestRecipient() {
        return this.testRecipient;
    }

    public void setTestRecipient(String testRecipient) {
        this.testRecipient = StringUtils.trim((String)testRecipient);
    }

    public BambooMailer getBambooMailer() {
        return this.bambooMailer;
    }

    public void setBambooMailer(BambooMailer bambooMailer) {
        this.bambooMailer = bambooMailer;
    }

    public boolean isMailServerConfigured() {
        return this.mailConfigurationService.isMailServerConfigured();
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public MailConfigurationService.MailMode getChosenMailSetting() {
        return this.chosenMailSetting;
    }

    public void setChosenMailSetting(MailConfigurationService.MailMode chosenMailSetting) {
        this.chosenMailSetting = chosenMailSetting;
    }

    public List<MailConfigurationService.MailMode> getEmailSettings() {
        return Lists.newArrayList((Object[])new MailConfigurationService.MailMode[]{MailConfigurationService.MailMode.SMTP, MailConfigurationService.MailMode.JNDI});
    }

    public String getSmtpChoice() {
        return MailConfigurationService.MailMode.SMTP.toString();
    }

    public String getJndiChoice() {
        return MailConfigurationService.MailMode.JNDI.toString();
    }

    public boolean isTlsRequired() {
        return this.tlsRequired;
    }

    public void setTlsRequired(boolean tlsRequired) {
        this.tlsRequired = tlsRequired;
    }

    public void setMailConfigurationService(MailConfigurationService mailConfigurationService) {
        this.mailConfigurationService = mailConfigurationService;
    }
}

