/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.instantmessagingserver;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDefinition;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDefinitionImpl;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.bamboo.notification.PortValidator;
import com.atlassian.bamboo.xmpp.BambooSmackClient;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class ConfigureInstantMessagingServer
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ConfigureInstantMessagingServer.class);
    private static final int NEW_IM_SERVER = -1;
    public static final String XMPP_RESOURCE_PATTERN = "^[a-z0-9!$&'()*+,:;=._~-]+$";
    private long instantMessagingServerId = -1L;
    private long affectedInstantMessagingServerId = -1L;
    private String name;
    private String host;
    private String port;
    private String username;
    private String password;
    private String resource;
    private boolean secureConnectionRequired;
    private boolean enforceLegacySsl;
    private String passwordChange;
    private String messageTest;
    private String testRecipients;
    protected InstantMessagingServerDefinition currentInstantMessagingServer;
    protected InstantMessagingServerManager instantMessagingServerManager;
    protected BambooSmackClient bambooSmackClient;

    @Override
    public String doDefault() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            this.setName("Default");
        }
        this.setResource("Bamboo");
        return "input";
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.host)) {
            this.addFieldError("host", this.getText("instantMessagingServer.host.error.required"));
        }
        this.checkFieldXssSafety("host", this.host);
        if (!PortValidator.isValidPortNumber((String)this.port)) {
            this.addFieldError("port", this.getText("instantMessagingServer.port.error.invalid"));
        }
        Pattern pattern = Pattern.compile(XMPP_RESOURCE_PATTERN, 2);
        Matcher matcher = pattern.matcher(this.resource);
        if (StringUtils.isNotBlank((CharSequence)this.resource) && !matcher.matches()) {
            this.addFieldError("resource", this.getText("instantMessagingServer.resource.error.invalid"));
        }
        if (this.isTesting() && StringUtils.isBlank((CharSequence)this.testRecipients)) {
            this.addFieldError("testRecipients", this.getText("instantMessagingServer.test.recipient.error.required"));
        }
    }

    public String doAdd() throws Exception {
        this.setResource("Bamboo");
        return "input";
    }

    public String create() throws Exception {
        this.currentInstantMessagingServer = this.instantMessagingServerManager.getInstantMessagingServer(this.getInstantMessagingServerId());
        if (this.isTesting()) {
            InstantMessagingServerDefinition testDefinition = this.createInstantMessagingServerDefinition();
            if (!Boolean.parseBoolean(this.getPasswordChange()) && this.currentInstantMessagingServer != null) {
                testDefinition.setPassword(this.currentInstantMessagingServer.getPassword());
            }
            this.testImServer(testDefinition);
            return "input";
        }
        if (this.getInstantMessagingServerId() == -1L) {
            this.currentInstantMessagingServer = this.createInstantMessagingServerDefinition();
        } else {
            this.currentInstantMessagingServer.setName(this.getName());
            this.currentInstantMessagingServer.setHost(this.getHost());
            if (StringUtils.isNotBlank((CharSequence)this.getPort())) {
                this.currentInstantMessagingServer.setPort(Integer.valueOf(this.getPort()));
            } else {
                this.currentInstantMessagingServer.setPort(null);
            }
            this.currentInstantMessagingServer.setUsername(this.getUsername());
            if (Boolean.parseBoolean(this.getPasswordChange())) {
                this.currentInstantMessagingServer.setPassword(this.getPassword());
            }
            this.currentInstantMessagingServer.setResource(this.getResource());
            this.currentInstantMessagingServer.setSecureConnectionRequired(this.isSecureConnectionRequired());
            this.currentInstantMessagingServer.setEnforceLegacySsl(this.isEnforceLegacySsl());
        }
        this.instantMessagingServerManager.saveInstantMessagingServer(this.currentInstantMessagingServer);
        try {
            this.bambooSmackClient.connect();
        }
        catch (Exception e) {
            String errorMessage = "Cannot connect to " + this.currentInstantMessagingServer.getHost() + " as user <" + this.currentInstantMessagingServer.getUsername() + ">";
            log.info((Object)errorMessage, (Throwable)e);
            this.addActionError(errorMessage);
            return "error";
        }
        return "success";
    }

    public String doRead() throws Exception {
        return "input";
    }

    public String edit() throws Exception {
        this.currentInstantMessagingServer = this.instantMessagingServerManager.getInstantMessagingServer(this.getInstantMessagingServerId());
        if (this.isTesting()) {
            this.testImServer(this.currentInstantMessagingServer);
            return "input";
        }
        if (this.currentInstantMessagingServer != null) {
            this.setName(this.currentInstantMessagingServer.getName());
            this.setHost(this.currentInstantMessagingServer.getHost());
            if (this.currentInstantMessagingServer.getPort() != null) {
                this.setPort(this.currentInstantMessagingServer.getPort().toString());
            } else {
                this.setPort(null);
            }
            this.setUsername(this.currentInstantMessagingServer.getUsername());
            this.setResource(this.currentInstantMessagingServer.getResource());
            this.setSecureConnectionRequired(this.currentInstantMessagingServer.isSecureConnectionRequired());
            this.setEnforceLegacySsl(this.currentInstantMessagingServer.isEnforceLegacySsl());
        } else {
            this.addActionError(this.getText("instantMessagingServer.admin.edit.failed"));
        }
        return "success";
    }

    public String delete() throws Exception {
        this.instantMessagingServerManager.removeInstantMessagingServer(this.instantMessagingServerId);
        return "success";
    }

    public Collection<InstantMessagingServerDefinition> getInstantMessagingServers() {
        return this.instantMessagingServerManager.getAllInstantMessagingServers();
    }

    private boolean isTesting() {
        return this.getMessageTest() != null && this.getMessageTest().equalsIgnoreCase(this.getText("global.buttons.test"));
    }

    private void testImServer(InstantMessagingServerDefinition definition) {
        try {
            this.bambooSmackClient.connect(definition);
            Set<String> list = this.getTestRecipientList();
            for (String recipient : list) {
                if (!StringUtils.isNotBlank((CharSequence)recipient)) continue;
                Message responseMessage = new Message(recipient, Message.Type.chat);
                responseMessage.setBody(this.getText("instantMessagingServer.test.message"));
                this.bambooSmackClient.send(responseMessage);
            }
            this.addActionMessage(this.getText("instantMessagingServer.test.success"));
        }
        catch (IOException | SmackException | XMPPException e) {
            log.info((Object)"Exception thrown from IM validation", e);
            StringBuilder imServerDesc = new StringBuilder(definition.getHost());
            if (null != definition.getPort()) {
                imServerDesc.append(":").append(definition.getPort());
            }
            if (StringUtils.isNotEmpty((CharSequence)definition.getResource())) {
                imServerDesc.append("/").append(definition.getResource());
            }
            if ("(401)".equals(e.getMessage())) {
                this.addActionError("Cannot connect to [" + imServerDesc + "] as [" + definition.getUsername() + "]");
            }
            this.addActionError("XMPP Error encountered while attempting to send message as [" + definition.getUsername() + "] using [" + imServerDesc + "], error message is: " + e.getMessage());
        }
    }

    public void setBambooSmackClient(BambooSmackClient bambooSmackClient) {
        this.bambooSmackClient = bambooSmackClient;
    }

    public void setInstantMessagingServerManager(InstantMessagingServerManager instantMessagingServerManager) {
        this.instantMessagingServerManager = instantMessagingServerManager;
    }

    public long getInstantMessagingServerId() {
        return this.instantMessagingServerId;
    }

    public void setInstantMessagingServerId(long instantMessagingServerId) {
        this.instantMessagingServerId = instantMessagingServerId;
    }

    public InstantMessagingServerDefinition getCurrentInstantMessagingServer() {
        return this.currentInstantMessagingServer;
    }

    public void setCurrentInstantMessagingServer(InstantMessagingServerDefinition currentInstantMessagingServer) {
        this.currentInstantMessagingServer = currentInstantMessagingServer;
    }

    public String getName() {
        return "Default";
    }

    public void setName(String name) {
        this.name = StringUtils.trim((String)name);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = StringUtils.trim((String)host);
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = StringUtils.trim((String)port);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPasswordChange() {
        return this.passwordChange;
    }

    public void setPasswordChange(String passwordChange) {
        this.passwordChange = passwordChange;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isEnforceLegacySsl() {
        return this.enforceLegacySsl;
    }

    public void setEnforceLegacySsl(boolean enforceLegacySsl) {
        this.enforceLegacySsl = enforceLegacySsl;
    }

    public boolean isSecureConnectionRequired() {
        return this.secureConnectionRequired;
    }

    public void setSecureConnectionRequired(boolean secureConnectionRequired) {
        this.secureConnectionRequired = secureConnectionRequired;
    }

    public String getMessageTest() {
        return this.messageTest;
    }

    public void setMessageTest(String messageTest) {
        this.messageTest = messageTest;
    }

    public String getTestRecipients() {
        return this.testRecipients;
    }

    public void setTestRecipients(String testRecipients) {
        this.testRecipients = StringUtils.trim((String)testRecipients);
    }

    public long getAffectedInstantMessagingServerId() {
        return this.affectedInstantMessagingServerId;
    }

    public void setAffectedInstantMessagingServerId(long affectedInstantMessagingServerId) {
        this.affectedInstantMessagingServerId = affectedInstantMessagingServerId;
    }

    private Set<String> getTestRecipientList() {
        HashSet<String> recipients = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.getTestRecipients())) {
            String[] imAddresses;
            for (String imAddress : imAddresses = this.getTestRecipients().split(",")) {
                recipients.add(StringUtils.trim((String)imAddress));
            }
        }
        return recipients;
    }

    @NotNull
    protected InstantMessagingServerDefinition createInstantMessagingServerDefinition() {
        InstantMessagingServerDefinitionImpl result = new InstantMessagingServerDefinitionImpl();
        result.setId(this.getInstantMessagingServerId());
        result.setName(this.getName());
        result.setHost(this.getHost());
        if (StringUtils.isNotBlank((CharSequence)this.getPort())) {
            result.setPort(Integer.valueOf(Integer.parseInt(this.getPort())));
        }
        result.setUsername(this.getUsername());
        result.setPassword(this.getPassword());
        result.setResource(this.getResource());
        result.setEnforceLegacySsl(this.isEnforceLegacySsl());
        return result;
    }
}

