/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.group;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.impl.EntityValidationException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CreateGroupAction
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(CreateGroupAction.class);
    public static final String GROUP_NAME_FIELD = "groupName";
    private static final int MAX_GROUP_NAME_LENGTH = 255;
    @Inject
    private BambooTransactionHibernateTemplate hibernateTemplate;
    private String groupName;

    public String create() throws Exception {
        return (String)this.hibernateTemplate.execute(transactionStatus -> {
            try {
                if (this.checkCanAddGroup() && !this.checkGroupExists()) {
                    this.bambooUserManager.createGroup(this.groupName);
                    return "success";
                }
                return "input";
            }
            catch (OperationFailedException | EntityValidationException e) {
                return this.handleGenericError((Exception)e);
            }
            catch (EntityException e) {
                log.debug((Object)"Adding group failed", (Throwable)e);
                this.addActionError(this.getText("user.admin.no.create.directory.permissions"));
                return "error";
            }
            catch (Exception e) {
                return this.handleGenericError(e);
            }
        });
    }

    private String handleGenericError(Exception e) {
        log.debug((Object)"Adding group failed", (Throwable)e);
        this.addActionError(this.getText("group.create.error.generic", e.getMessage()));
        return "error";
    }

    public void validate() {
        this.checkGroupName();
        if (!this.hasAnyErrors()) {
            try {
                this.checkGroupExists();
            }
            catch (EntityException e) {
                log.error((Object)"Validation failed", (Throwable)e);
            }
        }
    }

    private boolean checkGroupExists() throws EntityException {
        Group group = this.bambooUserManager.getGroup(this.groupName);
        if (group != null) {
            this.addFieldError(GROUP_NAME_FIELD, this.getText("group.groupName.error.duplicate"));
        }
        return group != null;
    }

    private boolean checkCanAddGroup() {
        if (!this.canCreateGroups()) {
            this.addActionError(this.getText("user.admin.no.create.directory.permissions"));
            return false;
        }
        return true;
    }

    private void checkGroupName() {
        if (StringUtils.isBlank((CharSequence)this.groupName) || this.groupName.length() >= 255) {
            this.addFieldError(GROUP_NAME_FIELD, this.getText("group.groupName.error.invalid"));
        }
    }

    public boolean canCreateGroups() {
        return this.bambooUserManager.canCreateGroups();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName.trim();
    }
}

