/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.group;

import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.user.Group;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ConfigureGroup
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ConfigureGroup.class);
    private String groupName;
    private Group currentGroup;

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    public String edit() throws Exception {
        return "input";
    }

    public String delete() throws Exception {
        Collection adminGroups = this.getBambooPermissionManager().getAdminGroups();
        if (adminGroups.size() == 1 && adminGroups.contains(this.getCurrentGroup().getName())) {
            this.addActionError(this.getText("group.admin.error.deletingAdminGroup"));
            return "error";
        }
        try {
            this.getBambooUserManager().removeGroup(this.getCurrentGroup());
            return "success";
        }
        catch (InfrastructureException e) {
            log.debug((Object)"Group deletion failed", (Throwable)e);
            this.addActionError(this.getText("group.admin.error.notDeletable"));
            return "error";
        }
    }

    public boolean canDelete() {
        return this.bambooUserManager.isDeletable(this.getCurrentGroup());
    }

    public boolean canEdit() {
        return !this.bambooUserManager.isReadOnly(this.getCurrentGroup());
    }

    public Group getCurrentGroup() {
        if (this.groupName != null && this.currentGroup == null) {
            this.currentGroup = this.getBambooUserManager().getGroup(this.groupName);
        }
        return this.currentGroup;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean canCreateGroups() {
        return this.bambooUserManager.canCreateGroups();
    }
}

