/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic.schedule;

import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleScheduler;
import java.util.Comparator;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

class ElasticInstanceScheduleComparator
implements Comparator<ElasticInstanceSchedule> {
    private static final Logger log = Logger.getLogger(ElasticInstanceScheduleComparator.class);
    private final ElasticInstanceScheduleScheduler elasticInstanceScheduleScheduler;

    public ElasticInstanceScheduleComparator(ElasticInstanceScheduleScheduler elasticInstanceScheduleScheduler) {
        this.elasticInstanceScheduleScheduler = elasticInstanceScheduleScheduler;
    }

    @Override
    public int compare(@NotNull ElasticInstanceSchedule o1, @NotNull ElasticInstanceSchedule o2) {
        try {
            Trigger trigger1 = this.elasticInstanceScheduleScheduler.getQuartzTrigger(o1);
            Trigger trigger2 = this.elasticInstanceScheduleScheduler.getQuartzTrigger(o2);
            CompareToBuilder builder = new CompareToBuilder();
            builder.append(!o1.isEnabled(), !o2.isEnabled());
            builder.append(o1.isRunOnStartup(), o2.isRunOnStartup());
            builder.append((Object)(trigger1 != null ? trigger1.getNextFireTime() : null), (Object)(trigger2 != null ? trigger2.getNextFireTime() : null));
            builder.append((Object)o1.getElasticImageConfiguration(), (Object)o2.getElasticImageConfiguration());
            return builder.toComparison();
        }
        catch (SchedulerException e) {
            log.warn((Object)"Unable to get the trigger time. Ordering will be in object creation order", (Throwable)e);
            return 0;
        }
    }
}

