/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic.schedule;

import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleManager;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleScheduler;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.ww2.actions.admin.elastic.schedule.ElasticInstanceScheduleComparator;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.core.cron.generator.CronExpressionDescriptor;
import com.atlassian.core.cron.parser.CronExpressionParser;
import com.atlassian.core.i18n.I18nTextProvider;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ConfigureElasticInstanceSchedules
extends GlobalAdminAction
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureElasticInstanceSchedules.class);
    private long elasticInstanceScheduleId = -1L;
    private ElasticInstanceScheduleManager elasticInstanceScheduleManager;
    private ElasticInstanceScheduleScheduler elasticInstanceScheduleScheduler;

    public String list() throws Exception {
        return "success";
    }

    public String enableAll() throws Exception {
        List<ElasticInstanceSchedule> schedules = this.getElasticInstanceSchedulesUnsorted();
        for (ElasticInstanceSchedule elasticInstanceSchedule : schedules) {
            elasticInstanceSchedule.setEnabled(true);
            this.elasticInstanceScheduleManager.saveElasticInstanceSchedule(elasticInstanceSchedule);
        }
        return "success";
    }

    public String disableAll() throws Exception {
        List<ElasticInstanceSchedule> schedules = this.getElasticInstanceSchedulesUnsorted();
        for (ElasticInstanceSchedule elasticInstanceSchedule : schedules) {
            elasticInstanceSchedule.setEnabled(false);
            this.elasticInstanceScheduleManager.saveElasticInstanceSchedule(elasticInstanceSchedule);
        }
        return "success";
    }

    public List<ElasticInstanceSchedule> getElasticInstanceSchedules() {
        List<ElasticInstanceSchedule> elasticInstanceSchedules = this.getElasticInstanceSchedulesUnsorted();
        Collections.sort(elasticInstanceSchedules, new ElasticInstanceScheduleComparator(this.elasticInstanceScheduleScheduler));
        return elasticInstanceSchedules;
    }

    public String getPrettyCronExpression(String cronExpression) {
        try {
            CronExpressionParser parser = new CronExpressionParser(cronExpression);
            CronExpressionDescriptor descriptor = new CronExpressionDescriptor((I18nTextProvider)this);
            return descriptor.getPrettySchedule(parser.getCronEditorBean());
        }
        catch (Exception e) {
            log.warn((Object)("Exception parsing cron expression: " + cronExpression), (Throwable)e);
            return "Invalid cron expression";
        }
    }

    @Nullable
    public Trigger getTrigger(@NotNull ElasticInstanceSchedule elasticInstanceSchedule) {
        try {
            return this.elasticInstanceScheduleScheduler.getQuartzTrigger(elasticInstanceSchedule);
        }
        catch (SchedulerException e) {
            log.warn((Object)("Unable to get quartz trigger for " + elasticInstanceSchedule), (Throwable)e);
            return null;
        }
    }

    private List<ElasticInstanceSchedule> getElasticInstanceSchedulesUnsorted() {
        return this.elasticInstanceScheduleManager.getElasticInstanceSchedules();
    }

    public long getElasticInstanceScheduleId() {
        return this.elasticInstanceScheduleId;
    }

    public void setElasticInstanceScheduleId(long elasticInstanceScheduleId) {
        this.elasticInstanceScheduleId = elasticInstanceScheduleId;
    }

    public void setElasticInstanceScheduleManager(ElasticInstanceScheduleManager elasticInstanceScheduleManager) {
        this.elasticInstanceScheduleManager = elasticInstanceScheduleManager;
    }

    public void setElasticInstanceScheduleScheduler(ElasticInstanceScheduleScheduler elasticInstanceScheduleScheduler) {
        this.elasticInstanceScheduleScheduler = elasticInstanceScheduleScheduler;
    }
}

