/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic.schedule;

import com.atlassian.bamboo.agent.elastic.schedule.ActiveInstanceAdjustmentType;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleImpl;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.utils.CronUtils;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.IntRangeFieldValidator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ConfigureElasticInstanceSchedule
extends GlobalAdminAction
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureElasticInstanceSchedule.class);
    private boolean confirmed;
    private WhenOption whenOption;
    private WhatOption whatOption;
    private long elasticInstanceScheduleId = -1L;
    private String cronExpression;
    private long elasticImageConfigurationId;
    private String activeInstanceAdjustmentType;
    private int targetActiveInstances;
    private boolean enabled;
    @Autowired
    private ElasticInstanceScheduleManager elasticInstanceScheduleManager;
    @Autowired
    private ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;

    public void validate() {
        if (WhenOption.CRON.equals((Object)this.whenOption)) {
            CronUtils.getCronExpressionValidationError((String)this.cronExpression).ifPresent(error -> this.addFieldError("cronExpression", (String)error));
        } else {
            this.setCronExpression(null);
        }
        if (WhatOption.KILL_ALL.equals((Object)this.whatOption)) {
            this.setElasticImageConfigurationId(-1L);
            this.setActiveInstanceAdjustmentType(ActiveInstanceAdjustmentType.EQUALS.name());
            this.setTargetActiveInstances(0);
        } else {
            try {
                IntRangeFieldValidator validator = (IntRangeFieldValidator)Preconditions.checkNotNull((Object)this.createFieldValidator("targetActiveInstances", IntRangeFieldValidator.class, "elastic.schedule.targetActiveInstances.zeroOrMore", null));
                validator.setMin((Comparable)Integer.valueOf(0));
                validator.validate((Object)this);
            }
            catch (ValidationException e) {
                log.warn((Object)("Should never happen. " + ToStringBuilder.reflectionToString((Object)this)), (Throwable)e);
            }
        }
    }

    public String doRead() {
        return "success";
    }

    public String add() {
        this.setEnabled(true);
        this.setWhenOption(WhenOption.CRON);
        this.setCronExpression("0 50 23 ? * *");
        this.setWhatOption(WhatOption.ADJUST);
        this.setTargetActiveInstances(1);
        return "success";
    }

    public String copy() {
        this.edit();
        this.setElasticInstanceScheduleId(-1L);
        return "success";
    }

    public String enable() {
        ElasticInstanceSchedule elasticInstanceSchedule = this.getElasticInstanceSchedule();
        if (elasticInstanceSchedule != null) {
            elasticInstanceSchedule.setEnabled(true);
            this.elasticInstanceScheduleManager.saveElasticInstanceSchedule(elasticInstanceSchedule);
            return "success";
        }
        this.addActionError(this.getText("elastic.schedule.notfound"));
        return "error";
    }

    public String disable() {
        ElasticInstanceSchedule elasticInstanceSchedule = this.getElasticInstanceSchedule();
        if (elasticInstanceSchedule != null) {
            elasticInstanceSchedule.setEnabled(false);
            this.elasticInstanceScheduleManager.saveElasticInstanceSchedule(elasticInstanceSchedule);
            return "success";
        }
        this.addActionError(this.getText("elastic.schedule.notfound"));
        return "error";
    }

    public String edit() {
        ElasticInstanceSchedule elasticInstanceSchedule = this.getElasticInstanceSchedule();
        if (elasticInstanceSchedule != null) {
            String expression = elasticInstanceSchedule.getCronExpression();
            if (StringUtils.isNotBlank((CharSequence)expression)) {
                this.setCronExpression(expression);
                this.setWhenOption(WhenOption.CRON);
            } else {
                this.setWhenOption(WhenOption.STARTUP);
            }
            ElasticImageConfiguration elasticImageConfiguration = elasticInstanceSchedule.getElasticImageConfiguration();
            if (elasticImageConfiguration != null) {
                this.setElasticImageConfigurationId(elasticImageConfiguration.getId());
                this.setWhatOption(WhatOption.ADJUST);
            } else {
                this.setWhatOption(WhatOption.KILL_ALL);
            }
            this.setActiveInstanceAdjustmentType(elasticInstanceSchedule.getActiveInstanceAdjustmentType().name());
            this.setTargetActiveInstances(elasticInstanceSchedule.getTargetActiveInstances());
            this.setEnabled(elasticInstanceSchedule.isEnabled());
            return "success";
        }
        this.addActionError(this.getText("elastic.schedule.notfound"));
        return "error";
    }

    public String save() {
        ElasticInstanceSchedule schedule;
        ElasticImageConfiguration elasticImageConfiguration = this.elasticImageConfigurationAccessor.getElasticImageConfigurationById(this.elasticImageConfigurationId);
        ActiveInstanceAdjustmentType activeInstanceAdjustmentType = ActiveInstanceAdjustmentType.valueOf((String)this.getActiveInstanceAdjustmentType());
        if (this.getElasticInstanceScheduleId() <= 0L) {
            schedule = new ElasticInstanceScheduleImpl();
        } else {
            schedule = this.getElasticInstanceSchedule();
            if (schedule == null) {
                this.addActionError(this.getText("elastic.schedule.notfound"));
                return "error";
            }
        }
        if (!WhenOption.CRON.equals((Object)this.getWhenOption())) {
            this.cronExpression = "";
        }
        schedule.setCronExpression(this.cronExpression);
        schedule.setElasticImageConfiguration(elasticImageConfiguration);
        schedule.setActiveInstanceAdjustmentType(activeInstanceAdjustmentType);
        schedule.setTargetActiveInstances(this.getTargetActiveInstances());
        schedule.setEnabled(this.isEnabled());
        this.elasticInstanceScheduleManager.saveElasticInstanceSchedule(schedule);
        this.setElasticInstanceScheduleId(schedule.getId());
        return "success";
    }

    public String delete() {
        this.elasticInstanceScheduleManager.removeElasticInstanceSchedule(this.elasticInstanceScheduleId);
        return "success";
    }

    public List<ActiveInstanceAdjustmentType> getActiveInstanceAdjustmentTypes() {
        return Arrays.asList(ActiveInstanceAdjustmentType.values());
    }

    public List<ElasticImageConfiguration> getElasticImageConfigurations() {
        return this.elasticImageConfigurationAccessor.getAllElasticImageConfigurationsForCurrentRegion().stream().sorted(Comparator.comparing(ElasticImageConfiguration::getConfigurationName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    public List<WhenOption> getWhenOptions() {
        return Arrays.asList(WhenOption.values());
    }

    public List<WhatOption> getWhatOptions() {
        return Arrays.asList(WhatOption.values());
    }

    @Nullable
    private ElasticInstanceSchedule getElasticInstanceSchedule() {
        return this.elasticInstanceScheduleManager.getElasticInstanceSchedule(this.elasticInstanceScheduleId);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public long getElasticInstanceScheduleId() {
        return this.elasticInstanceScheduleId;
    }

    public void setElasticInstanceScheduleId(long elasticInstanceScheduleId) {
        this.elasticInstanceScheduleId = elasticInstanceScheduleId;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public long getElasticImageConfigurationId() {
        return this.elasticImageConfigurationId;
    }

    public void setElasticImageConfigurationId(long elasticImageConfigurationId) {
        this.elasticImageConfigurationId = elasticImageConfigurationId;
    }

    public String getActiveInstanceAdjustmentType() {
        return this.activeInstanceAdjustmentType;
    }

    public void setActiveInstanceAdjustmentType(String activeInstanceAdjustmentType) {
        this.activeInstanceAdjustmentType = activeInstanceAdjustmentType;
    }

    public int getTargetActiveInstances() {
        return this.targetActiveInstances;
    }

    public void setTargetActiveInstances(int targetActiveInstances) {
        this.targetActiveInstances = targetActiveInstances;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public WhenOption getWhenOption() {
        return this.whenOption;
    }

    public void setWhenOption(WhenOption whenOption) {
        this.whenOption = whenOption;
    }

    public WhatOption getWhatOption() {
        return this.whatOption;
    }

    public void setWhatOption(WhatOption whatOption) {
        this.whatOption = whatOption;
    }

    static enum WhatOption {
        KILL_ALL,
        ADJUST;

    }

    static enum WhenOption {
        STARTUP,
        CRON;

    }
}

