/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ViewInstancesForConfigurationAction
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ViewInstancesForConfigurationAction.class);
    private List<RemoteElasticInstance> elasticInstances = new ArrayList<RemoteElasticInstance>();
    private long configurationId;
    private ElasticImageConfiguration elasticImageConfiguration;
    private boolean confirmed;
    private ElasticUIBean elasticUIBean;
    private ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;
    private ElasticInstanceManager elasticAgentManager;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;

    public String view() throws Exception {
        this.elasticImageConfiguration = this.elasticImageConfigurationAccessor.getElasticImageConfigurationById(this.configurationId);
        this.elasticInstances = this.elasticAgentManager.getElasticRemoteAgentsByConfiguration(this.configurationId);
        return "success";
    }

    public String shutdownAll() throws Exception {
        if (this.confirmed) {
            this.elasticInstances = this.elasticAgentManager.getElasticRemoteAgentsByConfiguration(this.configurationId);
            for (RemoteElasticInstance instance : this.elasticInstances) {
                this.elasticFunctionalityFacade.shutdownInstance(instance);
            }
            return "success";
        }
        this.elasticImageConfiguration = this.elasticImageConfigurationAccessor.getElasticImageConfigurationById(this.configurationId);
        return "input";
    }

    public boolean isAnyElasticInstancesShutdownable() {
        for (RemoteElasticInstance instance : this.elasticInstances) {
            if (!instance.isShutdownable()) continue;
            return true;
        }
        return false;
    }

    public List<RemoteElasticInstance> getElasticInstances() {
        return this.elasticInstances;
    }

    public long getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(long configurationId) {
        this.configurationId = configurationId;
    }

    public ElasticImageConfiguration getElasticImageConfiguration() {
        return this.elasticImageConfiguration;
    }

    public ElasticUIBean getElasticUIBean() {
        return this.elasticUIBean;
    }

    public void setElasticUIBean(ElasticUIBean elasticUIBean) {
        this.elasticUIBean = elasticUIBean;
    }

    public void setElasticImageConfigurationAccessor(ElasticImageConfigurationAccessor elasticImageConfigurationAccessor) {
        this.elasticImageConfigurationAccessor = elasticImageConfigurationAccessor;
    }

    public void setElasticAgentManager(ElasticInstanceManager elasticAgentManager) {
        this.elasticAgentManager = elasticAgentManager;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }
}

