/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.actions.admin.elastic.RemoteElasticAgentStateUIHelper;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ViewElasticInstanceAction
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ViewElasticInstanceAction.class);
    @Autowired
    private ElasticInstanceManager elasticInstanceManager;
    @Autowired
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private ElasticUIBean elasticUIBean;
    @Autowired
    private AwsAccountBean awsAccountBean;
    private BuildAgent buildAgent;
    private String instanceId;
    private RemoteElasticInstance instance;
    private RemoteEC2Instance ec2Instance;
    private ElasticAgentDefinition agentDefinition;
    private ElasticImageConfiguration image;
    private Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, File> privateKeyLocation;

    public String input() throws Exception {
        return "input";
    }

    public String view() throws Exception {
        if (this.instanceId == null) {
            this.addActionError("Could not show instance, instance id was null");
            return "error";
        }
        this.instance = this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(this.instanceId);
        if (this.instance == null) {
            this.addActionError("Could not show instance with id " + this.instanceId + ".");
            log.info((Object)("Could not show remote elastic instance with id " + this.instanceId + ", instance not found in the elastic instance manager"));
            return "error";
        }
        this.ec2Instance = this.instance.getInstance();
        if (this.ec2Instance == null) {
            this.addActionError("Could not show instance with id " + this.instanceId + ".");
            log.error((Object)("Could not show instance with id " + this.instanceId));
            return "error";
        }
        this.image = this.instance.getConfiguration();
        long remoteAgentId = this.instance.getRemoteAgent();
        this.buildAgent = this.agentManager.getAgent(remoteAgentId);
        if (this.buildAgent != null) {
            if (this.buildAgent.getDefinition().getType() != AgentType.ELASTIC) {
                this.addActionError("Definition of the instance is incorrect.");
                log.error((Object)"Definition of the instance is incorrect.");
                return "error";
            }
            this.agentDefinition = (ElasticAgentDefinition)this.buildAgent.getDefinition();
        }
        return "success";
    }

    @NotNull
    public String getInstanceLog() {
        try {
            return this.elasticInstanceManager.getInstanceLogs(this.instanceId);
        }
        catch (AWSException e) {
            log.info((Object)"An error occurred when fetching EC2 instance logs", (Throwable)e);
            return this.getText("elastic.instance.error.fetching.logs");
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getStateImagePath() {
        return RemoteElasticAgentStateUIHelper.getImagePathForState(this.getAgent().getState());
    }

    public String getStateDescription() {
        return RemoteElasticAgentStateUIHelper.getDescriptionForState(this.getAgent().getState());
    }

    public boolean allowShutdown() {
        return this.instance.isShutdownable();
    }

    public RemoteElasticInstance getAgent() {
        return this.instance;
    }

    public RemoteEC2Instance getInstance() {
        return this.ec2Instance;
    }

    public List<InstanceBlockDeviceMapping> getVolumes(String instanceId) throws AWSException {
        Instance instance = (Instance)Iterables.getOnlyElement((Iterable)this.awsAccountBean.getAwsAccount().describeInstances(new String[]{instanceId}));
        return instance.getBlockDeviceMappings();
    }

    public String getUnvalidatedPkLocation() {
        return this.elasticFunctionalityFacade.getPkFileLocation();
    }

    public String getKeyPairName() {
        return this.elasticFunctionalityFacade.getKeyPairName();
    }

    @NotNull
    public Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, File> getErrorOrPrivateKeyLocation() {
        if (this.privateKeyLocation == null) {
            this.privateKeyLocation = this.elasticFunctionalityFacade.getPrivateKeyLocation();
        }
        return this.privateKeyLocation;
    }

    @Nullable
    public String getPassword() {
        Either password = this.elasticFunctionalityFacade.getPassword(this.instance);
        return ((Optional)password.right().get()).orElse(null);
    }

    private boolean isWindows() {
        return this.image.getPlatform().isWindows();
    }

    public boolean isSshEnabled() {
        return !this.isWindows();
    }

    public boolean isRdcEnabled() {
        return this.isWindows();
    }

    public ElasticAgentDefinition getAgentDefinition() {
        return this.agentDefinition;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public ElasticImageConfiguration getImage() {
        return this.image;
    }

    public void setElasticAgentManager(ElasticInstanceManager elasticInstanceManager) {
        this.elasticInstanceManager = elasticInstanceManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public ElasticUIBean getElasticUIBean() {
        return this.elasticUIBean;
    }

    public void setElasticUIBean(ElasticUIBean elasticUIBean) {
        this.elasticUIBean = elasticUIBean;
    }

    public void setAwsAccountBean(AwsAccountBean awsAccountBean) {
        this.awsAccountBean = awsAccountBean;
    }
}

