/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.bamboo.build.statistics.SuccessPercentageStatisticsBean;
import com.atlassian.bamboo.build.statistics.SuccessPercentageStatisticsBeanImpl;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.resultsummary.AgentResultsSummaryManager;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.LazyPaginationAware;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ViewElasticAgentHistoryAction
extends GlobalAdminAction
implements LazyPaginationAware {
    private static final Logger log = Logger.getLogger(ViewElasticAgentHistoryAction.class);
    private List<ElasticAgentDefinition> offlineElasticAgents;
    private Pager pager;
    private AgentManager agentManager;
    private AgentResultsSummaryManager agentResultsSummaryManager;

    public String deleteHistory() throws Exception {
        List elasticAgents = this.agentManager.getAllElasticAgentDefinitions(0, this.getResultsCount());
        for (ElasticAgentDefinition agent : elasticAgents) {
            this.agentManager.removeAgent(agent.getId());
        }
        return "success";
    }

    private List<ElasticAgentDefinition> getElasticAgentDefinitions(int firstResult, int maxResults) {
        if (this.offlineElasticAgents == null) {
            List allOnlineElasticAgents = this.agentManager.getOnlineElasticAgents();
            List allElasticAgents = this.agentManager.getAllElasticAgentDefinitions(firstResult, maxResults + allOnlineElasticAgents.size());
            for (BuildAgent agent : allOnlineElasticAgents) {
                allElasticAgents.remove(agent.getDefinition());
            }
            this.offlineElasticAgents = allElasticAgents.subList(0, Math.min(allElasticAgents.size(), maxResults));
        }
        return this.offlineElasticAgents;
    }

    public SuccessPercentageStatisticsBean getStatistics(long id) {
        BuildAgent buildAgent = this.agentManager.getAgent(id);
        buildAgent = (BuildAgent)Preconditions.checkNotNull((Object)buildAgent, (Object)("Unknown agent " + id));
        return new SuccessPercentageStatisticsBeanImpl(this.agentResultsSummaryManager.countBuildResultsSummariesForAgent(buildAgent), this.agentResultsSummaryManager.countFailedBuildResultsSummariesForAgent(buildAgent));
    }

    @NotNull
    public List<ElasticAgentDefinition> getFilteredResultsList(int firstResult, int maxResults) {
        return this.getElasticAgentDefinitions(firstResult, maxResults);
    }

    @Override
    public int getResultsCount() {
        return (int)this.agentManager.getAgentCount(ElasticAgentDefinition.class);
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public Pager getPager() {
        return this.pager;
    }

    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public void setAgentResultsSummaryManager(AgentResultsSummaryManager agentResultsSummaryManager) {
        this.agentResultsSummaryManager = agentResultsSummaryManager;
    }
}

