/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceState;

public class RemoteElasticAgentStateUIHelper {
    private RemoteElasticAgentStateUIHelper() {
    }

    public static String getImagePathForState(RemoteElasticInstanceState state) {
        switch (state) {
            case SHUTTING_DOWN: {
                return "/images/icons/icon-agent-stopping-16x16.svg";
            }
            case IDENTIFIED: 
            case INITIAL: 
            case STARTING: 
            case STOPPING: {
                return "/images/iconsv4/icon-building-06.gif";
            }
            case RUNNING: {
                return "/images/icons/icon-elastic-agent-16x16.svg";
            }
            case STOPPED: 
            case TERMINATED: 
            case FAILED_TO_START: 
            case UNKNOWN: {
                return "";
            }
        }
        throw new IllegalStateException("Unrecognized remote elastic agent status (" + state.toString() + ")");
    }

    public static String getDescriptionForState(RemoteElasticInstanceState state) {
        switch (state) {
            case FAILED_TO_START: {
                return "Failed to start";
            }
            case IDENTIFIED: 
            case INITIAL: 
            case STARTING: {
                return "Pending";
            }
            case RUNNING: {
                return "Running";
            }
            case SHUTTING_DOWN: {
                return "Shutting down";
            }
            case TERMINATED: {
                return "Terminated";
            }
            case STOPPING: {
                return "Stopping";
            }
            case STOPPED: {
                return "Stopped";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        throw new IllegalStateException("Unrecognized remote elastic agent status (" + state.toString() + ")");
    }
}

