/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticAgentStartTimeComparator;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.persistence.HibernateLazyReferences;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ManageElasticInstancesAction
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ManageElasticInstancesAction.class);
    private List<RemoteElasticInstance> requestedElasticInstances;
    private List<RemoteElasticInstance> runningElasticInstances;
    private String numAgentsToCreate = "1";
    private Collection<ElasticImageConfiguration> elasticImageConfigurations;
    private ElasticImageConfiguration elasticImageConfiguration;
    private long elasticImageConfigurationId;
    private String instanceId;
    private boolean agentCreationPossible = true;
    private boolean confirmed = false;
    private boolean shutdownAll = false;
    private Collection<ErrorDetails> elasticErrors;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    private ElasticInstanceManager elasticInstanceManager;
    @Autowired
    private ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;
    @Autowired
    private ElasticUIBean elasticUIBean;
    @Autowired
    private ErrorHandler errorHandler;

    public void validateInstanceCreation() {
        super.validate();
        try {
            if (this.elasticImageConfigurationId > 0L) {
                this.elasticImageConfiguration = this.elasticImageConfigurationAccessor.getElasticImageConfigurationById(this.elasticImageConfigurationId);
                if (this.elasticImageConfiguration == null) {
                    this.addFieldError("numAgentsToCreate", this.getText("elastic.manage.create.number.error.invalid"));
                }
            }
        }
        catch (NumberFormatException e) {
            this.addActionError(this.getText("elastic.manage.create.configuration.error.invalid"));
        }
        try {
            int agentsToCreate = Integer.parseInt(this.numAgentsToCreate);
            if (agentsToCreate <= 0) {
                this.addActionError(this.getText("elastic.manage.create.number.error.invalid"));
            }
        }
        catch (NumberFormatException e) {
            this.addActionError(this.getText("elastic.manage.create.number.error.invalid"));
        }
    }

    public String view() throws Exception {
        return "success";
    }

    public String prepareCreate() {
        this.elasticFunctionalityFacade.validateAgentCreation(1, (ErrorCollection)this);
        if (this.hasAnyErrors()) {
            this.agentCreationPossible = false;
        }
        if (this.getElasticImageConfigurations().isEmpty()) {
            this.agentCreationPossible = false;
        }
        return "input";
    }

    public String create() {
        this.validateInstanceCreation();
        if (this.hasAnyErrors()) {
            return "input";
        }
        HibernateLazyReferences.initialise((ElasticImageConfiguration)this.elasticImageConfiguration);
        List<ElasticImageConfiguration> images = Collections.nCopies(Integer.parseInt(this.numAgentsToCreate), this.elasticImageConfiguration);
        try {
            this.elasticFunctionalityFacade.startupAgents(images);
        }
        catch (NumberFormatException e) {
            this.addActionError(this.getText("elastic.manage.create.number.error.invalid"));
            log.error((Object)"Failed to start elastic instances", (Throwable)e);
            return "error";
        }
        catch (Exception e) {
            this.addActionError("Failed to start elastic instances: " + e.getMessage());
            log.error((Object)"Failed to start elastic instances", (Throwable)e);
            return "error";
        }
        return "success";
    }

    public String shutdownAllInstances() {
        this.shutdownAll = true;
        if (this.confirmed) {
            this.elasticFunctionalityFacade.shutdownAllInstances();
            return "success";
        }
        return "input";
    }

    public String shutdownInstance() {
        if (this.confirmed) {
            if (this.instanceId == null) {
                this.addActionError("Could not delete instance, instance id was null");
                log.error((Object)"Could not delete instance, instance id was null");
                return "error";
            }
            try {
                this.elasticFunctionalityFacade.shutdownInstance(this.instanceId);
            }
            catch (AWSException e) {
                log.error((Object)("Error whe shutting down an instance " + this.instanceId), (Throwable)e);
                this.addActionError((Exception)((Object)e));
                return "error";
            }
            return "success";
        }
        return "input";
    }

    public Collection<ErrorDetails> getElasticErrors() {
        if (this.elasticErrors == null) {
            this.elasticErrors = this.errorHandler.getElasticErrors();
        }
        return this.elasticErrors;
    }

    public int getMaxAllowedInstances() {
        ElasticConfiguration elasticConfig;
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        if (administrationConfiguration != null && (elasticConfig = administrationConfiguration.getElasticConfig()) != null) {
            return elasticConfig.getMaxConcurrentInstances();
        }
        return 0;
    }

    public List<RemoteElasticInstance> getRunningElasticInstances() {
        if (this.runningElasticInstances == null) {
            this.runningElasticInstances = this.elasticInstanceManager.getElasticRemoteAgents().stream().sorted(new RemoteElasticAgentStartTimeComparator()).collect(Collectors.toList());
        }
        return this.runningElasticInstances;
    }

    public boolean isAnyRunningElasticInstancesShutdownable() {
        for (RemoteElasticInstance instance : this.getRunningElasticInstances()) {
            if (!instance.isShutdownable()) continue;
            return true;
        }
        return false;
    }

    public List<RemoteElasticInstance> getRequestedElasticInstances() {
        if (this.requestedElasticInstances == null) {
            this.requestedElasticInstances = this.elasticInstanceManager.getRequestedElasticRemoteAgents().stream().sorted(new RemoteElasticAgentStartTimeComparator()).collect(Collectors.toList());
        }
        return this.requestedElasticInstances;
    }

    public String getNumAgentsToCreate() {
        return this.numAgentsToCreate;
    }

    public void setNumAgentsToCreate(String numAgentsToCreate) {
        this.numAgentsToCreate = numAgentsToCreate;
    }

    public Collection<ElasticImageConfiguration> getElasticImageConfigurations() {
        if (this.elasticImageConfigurations == null) {
            this.elasticImageConfigurations = this.elasticImageConfigurationAccessor.getAllElasticImageConfigurationsForCurrentRegion().stream().filter(image -> !image.isDisabled()).sorted(Comparator.comparing(ElasticImageConfiguration::getConfigurationName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        }
        return this.elasticImageConfigurations;
    }

    public void setElasticImageConfigurations(Collection<ElasticImageConfiguration> elasticImageConfigurations) {
        this.elasticImageConfigurations = elasticImageConfigurations;
    }

    public ElasticImageConfiguration getElasticImageConfiguration() {
        return this.elasticImageConfiguration;
    }

    public void setElasticImageConfiguration(ElasticImageConfiguration elasticImageConfiguration) {
        this.elasticImageConfiguration = elasticImageConfiguration;
    }

    public long getElasticImageConfigurationId() {
        return this.elasticImageConfigurationId;
    }

    public void setElasticImageConfigurationId(long elasticImageConfigurationId) {
        this.elasticImageConfigurationId = elasticImageConfigurationId;
    }

    public List<String> getElasticAgentLogs() {
        return this.elasticInstanceManager.getElasticAgentLogs();
    }

    public void setElasticAgentManager(ElasticInstanceManager elasticInstanceManager) {
        this.elasticInstanceManager = elasticInstanceManager;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isShutdownAll() {
        return this.shutdownAll;
    }

    public boolean isBaseUrlMatchesRequestUrl() {
        String requestUrl = ServletActionContext.getRequest().getRequestURL().toString();
        return requestUrl.startsWith(this.getBaseUrl());
    }

    public Map getInstanceTypes() {
        HashMap<String, String> instanceTypes = new HashMap<String, String>();
        for (EC2InstanceType instanceType : this.elasticInstanceManager.getAllowedInstanceTypes()) {
            instanceTypes.put(instanceType.name(), instanceType.getName());
        }
        return instanceTypes;
    }

    public boolean isAgentCreationPossible() {
        return this.agentCreationPossible;
    }

    public ElasticUIBean getElasticUIBean() {
        return this.elasticUIBean;
    }
}

