/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import io.atlassian.fugue.Either;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class GetPkFileAction
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(GetPkFileAction.class);
    @Autowired
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    private URLConnection urlConnection;
    private File privateKeyLocation;

    public String execute() throws IOException {
        Either pkFile = this.elasticFunctionalityFacade.getPrivateKeyLocation();
        if (!pkFile.isRight()) {
            log.warn((Object)("Cannot download private key: " + pkFile.left().get()));
            return "none";
        }
        this.privateKeyLocation = (File)pkFile.right().get();
        URL resource = this.privateKeyLocation.toURI().toURL();
        this.urlConnection = resource.openConnection();
        log.debug((Object)"Fetching elastic key");
        return "success";
    }

    public int getContentLength() {
        return this.urlConnection.getContentLength();
    }

    public String getFilename() {
        return this.privateKeyLocation.getName();
    }

    public InputStream getInputStream() throws IOException {
        return this.urlConnection.getInputStream();
    }
}

