/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.InstancePaymentType;
import com.atlassian.aws.ec2.SpotPrices;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.AutomaticInstanceManagementConfig;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManagerImpl;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceState;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.actions.admin.elastic.RemoteElasticAgentStateUIHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticUIBeanImpl
implements ElasticUIBean {
    private static final Logger log = Logger.getLogger(ElasticUIBeanImpl.class);
    private final List<AutomaticInstanceManagementConfig> automaticInstanceManagementConfigList = ImmutableList.of((Object)AutomaticInstanceManagementConfig.DEFAULT_INSTANCE_MANAGEMENT_CONFIG, (Object)AutomaticInstanceManagementConfig.AGGRESSIVE_INSTANCE_MANAGEMENT_CONFIG, (Object)AutomaticInstanceManagementConfig.PASSIVE_INSTANCE_MANAGEMENT_CONFIG, (Object)AutomaticInstanceManagementConfig.CUSTOM_INSTANCE_MANAGEMENT_CONFIG, (Object)AutomaticInstanceManagementConfig.DISABLED_INSTANCE_MANAGEMENT_CONFIG);
    private final Map<String, AutomaticInstanceManagementConfig> autoInstanceManagementConfigs = Maps.uniqueIndex(this.automaticInstanceManagementConfigList, AutomaticInstanceManagementConfig::getConfigurationName);
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private AwsAccountBean awsAccountBean;
    @Autowired
    private ElasticInstanceManagerImpl elasticInstanceManager;

    @Override
    public String getStateImagePath(RemoteElasticInstanceState state) {
        return RemoteElasticAgentStateUIHelper.getImagePathForState(state);
    }

    @Override
    public String getStateDescription(RemoteElasticInstanceState state) {
        return RemoteElasticAgentStateUIHelper.getDescriptionForState(state);
    }

    @Override
    @Nullable
    public BuildAgent getAgentById(long agentId) {
        return this.agentManager.getAgent(agentId);
    }

    @Override
    public int getActiveInstancesCountForConfiguration(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        return this.elasticInstanceManager.getElasticRemoteAgentsByConfiguration(elasticImageConfiguration).size();
    }

    @Override
    @Nullable
    public Double getInstancePrice(RemoteElasticInstance instance) throws AWSException {
        if (instance.getInstance().getInstanceStatus().getInstancePaymentType() != InstancePaymentType.SPOT) {
            return null;
        }
        SpotPrices spotPrices = this.awsAccountBean.getAwsAccount().getSpotPrices();
        EC2InstanceType instanceType = EC2InstanceType.from((InstanceType)instance.getInstance().getInstanceStatus().getInstanceType());
        SpotPrices.Price price = spotPrices.get(instance.getConfiguration().getProduct(), instanceType.getAwsInstanceType(), instance.getInstance().getInstanceStatus().getAvailabilityZone());
        if (price == null) {
            return null;
        }
        return price.getSpotPrice();
    }

    @Override
    @NotNull
    public Map<String, AutomaticInstanceManagementConfig> getAutoInstanceManagementConfigs() {
        return this.autoInstanceManagementConfigs;
    }
}

