/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.SpotPriceMatrix;
import com.atlassian.aws.ec2.SpotPrices;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.SpotInstanceConfig;
import com.atlassian.bamboo.agent.elastic.server.SpotInstanceConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.SpotInstanceConfigurationManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ConfigureSpotInstancesAction
extends GlobalAdminAction
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureSpotInstancesAction.class);
    private static final String EC2_SPOT_INSTANCES_CONFIG = "EC2_SPOT_INSTANCES_CONFIG";
    private boolean fieldSpotInstancesEnabled;
    private SpotPriceMatrix bids = new SpotPriceMatrix();
    private int fieldSpotInstancesTimeoutMinutes;
    private final AwsAccountBean awsAccountBean;
    private final SpotInstanceConfigurationAccessor spotInstanceConfigurationAccessor;
    private final SpotInstanceConfigurationManager spotInstanceConfigurationManager;

    public ConfigureSpotInstancesAction() {
        this(null, null, null);
    }

    public ConfigureSpotInstancesAction(AwsAccountBean awsAccountBean, SpotInstanceConfigurationAccessor spotInstanceConfigurationAccessor, SpotInstanceConfigurationManager spotInstanceConfigurationManager) {
        this.awsAccountBean = awsAccountBean;
        this.spotInstanceConfigurationAccessor = spotInstanceConfigurationAccessor;
        this.spotInstanceConfigurationManager = spotInstanceConfigurationManager;
    }

    public String read() throws Exception {
        this.processSpotInstancesConfig(this.getSpotInstanceConfig());
        return "success";
    }

    public String save() throws Exception {
        this.validate();
        if (this.hasAnyErrors()) {
            return "error";
        }
        SpotInstanceConfig spotInstanceConfig = this.getSpotInstanceConfig();
        spotInstanceConfig.setEnabled(this.isFieldSpotInstancesEnabled());
        spotInstanceConfig.setSpotRequestTimeoutSeconds((int)TimeUnit.MINUTES.toSeconds(this.fieldSpotInstancesTimeoutMinutes));
        this.save(ActionParamsUtils.getStringArrayMap(), spotInstanceConfig);
        this.spotInstanceConfigurationManager.saveSpotInstanceConfig(spotInstanceConfig);
        return "success";
    }

    public String edit() throws Exception {
        this.processSpotInstancesConfig(this.getSpotInstanceConfig());
        return "success";
    }

    private void processSpotInstancesConfig(SpotInstanceConfig spotInstanceConfig) {
        this.setFieldSpotInstancesEnabled(spotInstanceConfig.isEnabled());
        this.bids = spotInstanceConfig.getBidLevels();
        this.setFieldSpotInstancesTimeoutMinutes((int)TimeUnit.SECONDS.toMinutes(spotInstanceConfig.getSpotRequestTimeoutSeconds()));
    }

    public SpotInstanceConfig getSpotInstanceConfig() {
        return this.spotInstanceConfigurationAccessor.getSpotInstanceConfig();
    }

    public boolean isFieldSpotInstancesEnabled() {
        return this.fieldSpotInstancesEnabled;
    }

    public void setFieldSpotInstancesEnabled(boolean fieldSpotInstancesEnabled) {
        this.fieldSpotInstancesEnabled = fieldSpotInstancesEnabled;
    }

    public int getFieldSpotInstancesTimeoutMinutes() {
        return this.fieldSpotInstancesTimeoutMinutes;
    }

    public void setFieldSpotInstancesTimeoutMinutes(int fieldSpotInstancesTimeoutMinutes) {
        this.fieldSpotInstancesTimeoutMinutes = fieldSpotInstancesTimeoutMinutes;
    }

    @Nullable
    public Double getBid(String product, InstanceType instanceType) {
        SpotPriceMatrix.Price bid = this.bids.getPrice(product, instanceType);
        return bid != null ? Double.valueOf(bid.getSpotPrice()) : null;
    }

    public SpotPrices getCurrentSpotPrices() {
        try {
            return this.awsAccountBean.getAwsAccount().getSpotPrices();
        }
        catch (Exception e) {
            log.warn((Object)"unable to get spot prices", (Throwable)e);
            return new SpotPrices();
        }
    }

    public EC2InstanceType[] getInstanceTypes() {
        return EC2InstanceType.values();
    }

    void save(Map<String, String[]> parameters, SpotInstanceConfig spotInstanceConfig) {
        for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
            this.save(parameter, spotInstanceConfig);
        }
    }

    private void save(Map.Entry<String, String[]> parameter, SpotInstanceConfig spotInstanceConfig) {
        String product2;
        String fieldPrefix = "fieldBid_";
        if (!parameter.getKey().startsWith("fieldBid_") || parameter.getValue() == null) {
            return;
        }
        HashMap<String, String> mangledProductsToProducts = new HashMap<String, String>();
        for (String product2 : this.getCurrentSpotPrices().getProducts()) {
            mangledProductsToProducts.put(BambooStringUtils.forceValidHtmlId((String)product2), product2);
        }
        String toParse = StringUtils.replaceOnce((String)parameter.getKey(), (String)"fieldBid_", (String)"");
        product2 = null;
        for (Map.Entry mangledProductToProduct : mangledProductsToProducts.entrySet()) {
            String token = (String)mangledProductToProduct.getKey() + "_XYZ_";
            if (!toParse.startsWith(token)) continue;
            product2 = (String)mangledProductToProduct.getValue();
            toParse = StringUtils.replaceOnce((String)toParse, (String)token, (String)"");
            break;
        }
        if (product2 == null) {
            log.warn((Object)("Error persisting " + parameter.getKey() + " (" + toParse + ")"));
            return;
        }
        try {
            InstanceType instanceType = InstanceType.fromValue((String)toParse);
            double price = NumberUtils.toDouble((String)parameter.getValue()[0], (double)0.0);
            spotInstanceConfig.setBid(product2, instanceType, price);
        }
        catch (Exception ignored) {
            log.warn((Object)("Error persisting " + parameter.getKey() + " (" + toParse + ")"));
        }
    }
}

