/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementsMatcher;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.opensymphony.xwork2.Preparable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ConfigureElasticImageConfigurationAssignments
extends GlobalAdminAction
implements GlobalAdminSecurityAware,
Preparable {
    private static final Logger log = Logger.getLogger(ConfigureElasticImageConfigurationAssignments.class);
    private long configurationId;
    private ElasticImageConfiguration image;
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    @Autowired
    private EnvironmentService environmentService;
    private CapabilityRequirementsMatcher capabilityRequirementsMatcher;

    public void prepare() throws Exception {
        this.image = this.elasticImageConfigurationManager.getElasticImageConfigurationById(this.configurationId);
    }

    private boolean isCapabilitiesMatch(ReadOnlyCapabilitySet capabilitySet, long environmentId) {
        RequirementSet requirementSet = this.environmentService.getEnvironmentRequirementSet(environmentId);
        return this.capabilityRequirementsMatcher.matches(capabilitySet, (MinimalRequirementSet)requirementSet);
    }

    public long getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(long configurationId) {
        this.configurationId = configurationId;
    }

    public ElasticImageConfiguration getImage() {
        return this.image;
    }

    public List<AgentAssignment.ExecutableType> getAssignmentTypes() {
        return new ArrayList<AgentAssignment.ExecutableType>(Arrays.asList(AgentAssignment.ExecutableType.values()));
    }

    public void setElasticImageConfigurationManager(ElasticImageConfigurationManager elasticImageConfigurationManager) {
        this.elasticImageConfigurationManager = elasticImageConfigurationManager;
    }

    public void setCapabilityRequirementsMatcher(CapabilityRequirementsMatcher capabilityRequirementsMatcher) {
        this.capabilityRequirementsMatcher = capabilityRequirementsMatcher;
    }
}

