/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VirtualizationType;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.AvailabilityZoneId;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationCapabilities;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.core.Script;
import com.atlassian.bamboo.core.ScriptImpl;
import com.atlassian.bamboo.deployments.environments.DecoratedEnvironment;
import com.atlassian.bamboo.deployments.environments.EnvironmentComparators;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySetImpl;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.struts.TextProvider;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;
import io.atlassian.fugue.Suppliers;
import io.atlassian.util.concurrent.Lazy;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ConfigureElasticImageConfiguration
extends GlobalAdminAction
implements GlobalAdminSecurityAware,
Preparable {
    private static final Logger log = Logger.getLogger(ConfigureElasticImageConfiguration.class);
    @Autowired
    private AwsAccountBean awsAccountBean;
    @Autowired
    private BambooCachingPermissionManagerFacade cachingPermissionManagerFacade;
    @Autowired
    private CapabilityHelper capabilityHelper;
    @Autowired
    private DeploymentProjectService deploymentProjectService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    @Autowired
    private ElasticInstanceManager elasticInstanceManager;
    @Autowired
    private ElasticInstanceScheduleManager elasticInstanceScheduleManager;
    @Autowired
    private ElasticUIBean elasticUIBean;
    @Autowired
    private ExecutableAgentsHelper executableAgentsHelper;
    private long configurationId = 0L;
    private ElasticImageConfiguration configuration;
    private String configurationName;
    private String configurationDescription;
    private String amiId;
    private Integer rootFsSizeOverride;
    private boolean ebsEnabled;
    private String ebsSnapshotId;
    private boolean useLegacyEbsHandling;
    private Collection<EC2InstanceType> instanceTypes;
    private Iterable<String> availabilityZones;
    private AwsSupportConstants.Region region;
    private String mode;
    private String product;
    @NotNull
    private Collection<String> subnetIds = Collections.emptyList();
    private String startupScript;
    private String iamInstanceProfile;
    private boolean isEbsOptimised;
    private boolean vpcEnabled;
    private boolean perSecondBillingEnabled;
    private boolean confirmDelete;
    private boolean confirmDisable;
    private AwsSupportConstants.Architecture architecture;
    private AwsSupportConstants.Platform platform;
    private AwsSupportConstants.RootDeviceType rootDeviceType;
    private AwsSupportConstants.Virtualisation virtualisationType;
    private Supplier<Collection<ImmutableBuildable>> executableBuildables = Suppliers.memoize(this::fetchExecutableBuildables);
    private Supplier<List<DecoratedEnvironment>> executableEnvironments = Suppliers.memoize(this::fetchExecutableEnvironments);
    private LoadingCache<Long, DeploymentProject> deploymentProjectMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, DeploymentProject>(){

        public DeploymentProject load(@NotNull Long deploymentProjectId) throws Exception {
            return ConfigureElasticImageConfiguration.this.deploymentProjectService.getDeploymentProject(deploymentProjectId.longValue());
        }
    });
    private final Supplier<Map<String, String>> nameToSubnetId = Lazy.supplier((Supplier)new Supplier<Map<String, String>>(){

        @Override
        public Map<String, String> get() {
            Collator collator = Collator.getInstance();
            TreeMap<String, String> nameToSubnetId = new TreeMap<String, String>(collator::compare);
            try {
                Map vpcs = ConfigureElasticImageConfiguration.this.awsAccountBean.getAwsAccount().describeVpcs();
                vpcs.forEach((vpc, subnets) -> subnets.forEach(subnet -> nameToSubnetId.put(ConfigureElasticImageConfiguration.getSubnetName(vpc, subnet), subnet.getSubnetId())));
            }
            catch (AWSException e) {
                log.warn((Object)"Unable to get VPCs", (Throwable)e);
            }
            return nameToSubnetId;
        }
    });

    public void prepare() throws Exception {
        if (this.configurationId <= 0L) {
            this.perSecondBillingEnabled = true;
            return;
        }
        this.configuration = this.elasticImageConfigurationManager.getElasticImageConfigurationById(this.configurationId);
        if (this.configuration != null && !StringUtils.equals((CharSequence)this.mode, (CharSequence)"edit")) {
            this.configurationName = this.configuration.getConfigurationName();
            this.configurationDescription = this.configuration.getConfigurationDescription();
            this.amiId = this.configuration.getAmiId();
            this.rootFsSizeOverride = this.configuration.getRootFsSizeOverride();
            this.ebsEnabled = this.configuration.isEbsEnabled();
            this.perSecondBillingEnabled = this.configuration.isPerSecondBillingEnabled();
            this.ebsSnapshotId = this.configuration.getEbsSnapshotId();
            this.useLegacyEbsHandling = this.configuration.isLegacyEbsHandlingEnabled();
            this.instanceTypes = Lists.newArrayList((Iterable)this.configuration.getInstanceTypes());
            this.availabilityZones = this.configuration.getAvailabilityZones();
            this.product = this.configuration.getProduct();
            this.subnetIds = ImmutableList.copyOf((Collection)this.configuration.getSubnetIds());
            this.iamInstanceProfile = ElasticImageConfigurationCapabilities.getIamInstanceProfile((ElasticImageConfiguration)this.configuration);
            this.isEbsOptimised = ElasticImageConfigurationCapabilities.isEbsOptimised((ElasticImageConfiguration)this.configuration);
            if (!this.configuration.getStartupScripts().isEmpty()) {
                this.startupScript = ((Script)Iterables.getOnlyElement((Iterable)this.configuration.getStartupScripts())).getBody();
            }
        }
    }

    public String create() throws Exception {
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.elasticImageConfigurationManager.saveElasticImageConfiguration(this.createElasticImageConfiguration());
        return "success";
    }

    public String disable() {
        if (!this.confirmDisable) {
            return "input";
        }
        return this.setDisabledState(true);
    }

    public String enable() {
        return this.setDisabledState(false);
    }

    private String setDisabledState(boolean state) {
        if (this.configuration == null) {
            this.addActionError("Setting disabled state to" + state + " failed, could not find elastic image configuration with id: " + this.configurationId);
            return "error";
        }
        if (state) {
            this.elasticImageConfigurationManager.disableElasticImageSchedules(this.configuration);
        }
        this.configuration.setDisabled(state);
        this.elasticImageConfigurationManager.saveElasticImageConfiguration(this.configuration);
        return "success";
    }

    public String delete() {
        if (this.configuration == null) {
            this.addActionError("Delete failed, could not find elastic image configuration with id: " + this.configurationId);
            return "error";
        }
        if (this.configuration.isShippedWithBamboo()) {
            this.addActionError("Can not delete stock Elastic Image Configurations");
            return "error";
        }
        if (!this.confirmDelete) {
            return "input";
        }
        try {
            this.elasticImageConfigurationManager.removeElasticImageConfiguration(this.configuration);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            this.addActionError("Failed to delete configuration " + this.configuration.getConfigurationName() + ": " + e.getMessage());
            return "error";
        }
        return "success";
    }

    public String edit() throws Exception {
        return "input";
    }

    public String list() throws Exception {
        return "success";
    }

    public String save() throws Exception {
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.elasticImageConfigurationManager.saveElasticImageConfiguration(this.updateElasticImageConfiguration());
        return "success";
    }

    public String view() throws Exception {
        return "success";
    }

    public CapabilityRequirementSetDecorator getCapabilitySetDecorator() {
        return new CapabilityRequirementSetDecorator((ReadOnlyCapabilitySet)this.configuration.getCapabilitySet(), null, (TextProvider)this, this.capabilityHelper);
    }

    private ElasticImageConfiguration createElasticImageConfiguration() throws AWSException {
        ElasticImageConfigurationImpl elasticImageConfiguration = new ElasticImageConfigurationImpl();
        this.setElasticImageConfigurationProperties(elasticImageConfiguration);
        ImageCapabilitySetImpl imageCapabilitySet = new ImageCapabilitySetImpl();
        this.elasticImageConfigurationManager.populateDefaultCapabilitySet((CapabilitySet)imageCapabilitySet, (ElasticImageConfiguration)elasticImageConfiguration);
        elasticImageConfiguration.setCapabilitySet((ImageCapabilitySet)imageCapabilitySet);
        return elasticImageConfiguration;
    }

    private ElasticImageConfiguration updateElasticImageConfiguration() throws AWSException {
        if (this.configuration instanceof ElasticImageConfigurationImpl) {
            ElasticImageConfigurationImpl elasticImageConfiguration = (ElasticImageConfigurationImpl)this.configuration;
            elasticImageConfiguration.setId(this.configurationId);
            this.setElasticImageConfigurationProperties(elasticImageConfiguration);
        }
        return this.configuration;
    }

    private void setElasticImageConfigurationProperties(@NotNull ElasticImageConfigurationImpl elasticImageConfiguration) throws AWSException {
        if (!this.vpcEnabled) {
            this.subnetIds = Collections.emptyList();
        }
        elasticImageConfiguration.setConfigurationName(this.configurationName);
        elasticImageConfiguration.setConfigurationDescription(this.configurationDescription);
        elasticImageConfiguration.setAmiId(this.amiId);
        elasticImageConfiguration.setEbsSnapshotId(this.ebsEnabled ? this.ebsSnapshotId : "");
        elasticImageConfiguration.setLegacyEbsHandlingEnabled(this.ebsEnabled && this.useLegacyEbsHandling);
        elasticImageConfiguration.setPerSecondBillingEnabled(this.perSecondBillingEnabled);
        elasticImageConfiguration.setInstanceTypes(this.instanceTypes);
        elasticImageConfiguration.setAvailabilityZones(this.getAvailabilityZonesForSubnetsOrFromUi());
        elasticImageConfiguration.setArchitecture(this.architecture);
        elasticImageConfiguration.setRootDeviceType(this.rootDeviceType);
        elasticImageConfiguration.setRootFsSizeOverride(this.rootFsSizeOverride);
        elasticImageConfiguration.setVirtualisationType(this.virtualisationType);
        elasticImageConfiguration.setPlatform(this.platform);
        elasticImageConfiguration.setProduct(this.product);
        elasticImageConfiguration.setRegion(this.region);
        elasticImageConfiguration.setSubnetIds(this.subnetIds);
        ElasticImageConfigurationCapabilities.setIamInstanceProfile((ElasticImageConfiguration)elasticImageConfiguration, (String)this.iamInstanceProfile);
        ElasticImageConfigurationCapabilities.setEbsOptimised((ElasticImageConfigurationImpl)elasticImageConfiguration, (boolean)this.isEbsOptimised);
        if (this.instanceTypes.size() == 1) {
            ElasticImageConfigurationCapabilities.setEc2InstanceType((ElasticImageConfiguration)elasticImageConfiguration, (InstanceType)((EC2InstanceType)Iterables.getOnlyElement(this.instanceTypes)).getAwsInstanceType());
        }
        if (this.startupScript != null) {
            String startupScriptUnixNl = BambooStringUtils.dos2unix((String)this.startupScript);
            List startupScripts = elasticImageConfiguration.getStartupScripts();
            if (startupScripts.isEmpty()) {
                if (StringUtils.isNotBlank((CharSequence)startupScriptUnixNl)) {
                    startupScripts.add(new ScriptImpl(startupScriptUnixNl));
                }
            } else {
                ((Script)Iterables.getOnlyElement((Iterable)startupScripts)).setBody(startupScriptUnixNl);
            }
        }
    }

    private Iterable<AvailabilityZoneId> getAvailabilityZonesForSubnetsOrFromUi() {
        if (this.subnetIds.isEmpty()) {
            return AvailabilityZoneId.from(this.availabilityZones);
        }
        String[] subnetArray = (String[])Iterables.toArray(this.subnetIds, String.class);
        Collection subnets = this.awsAccountBean.getAwsAccount().describeSubnets(subnetArray);
        return AvailabilityZoneId.fromSubnets((Iterable)subnets);
    }

    public void validate() {
        if (this.ebsEnabled && StringUtils.isEmpty((CharSequence)this.getEbsSnapshotId())) {
            this.addFieldError("ebsEnabled", this.getText("elastic.image.configuration.ebsSnapshotId.error.required"));
        }
        this.checkFieldXssSafety("configurationName", this.configurationName);
        if (StringUtils.isBlank((CharSequence)this.configurationName)) {
            this.addFieldError("configurationName", this.getText("elastic.image.configuration.error.configurationName.required"));
        } else {
            List otherConfigs = this.elasticImageConfigurationManager.getElasticImageConfigurationsByName(this.configurationName, this.getCurrentRegion());
            if (!(otherConfigs.isEmpty() || otherConfigs.size() <= 1 && ((ElasticImageConfiguration)Iterables.getOnlyElement((Iterable)otherConfigs)).getId() == this.configurationId)) {
                this.addFieldError("configurationName", this.getText("elastic.image.configuration.error.configurationName.notUnique"));
            }
        }
        if (this.configuration != null && this.configuration.isShippedWithBamboo()) {
            this.amiId = this.configuration.getAmiId();
        } else if (StringUtils.isBlank((CharSequence)this.amiId)) {
            this.addFieldError("amiId", this.getText("elastic.image.configuration.error.amiId.required"));
        }
        if (this.vpcEnabled && this.subnetIds.isEmpty()) {
            this.addFieldError("vpcEnabled", this.getText("elastic.instance.vpc.subnet.missing"));
        }
        try {
            Image image = this.getImage();
            if (image == null) {
                this.addFieldError("amiId", this.getTextWithArgs("elastic.image.configuration.error.amiId.emptyResult", new String[0]));
            } else {
                this.architecture = AwsSupportConstants.Architecture.fromAwsName((String)image.getArchitecture());
                this.platform = image.getPlatform() != null ? AwsSupportConstants.Platform.fromAwsName((String)image.getPlatform()) : AwsSupportConstants.Platform.linux;
                this.rootDeviceType = AwsSupportConstants.RootDeviceType.fromAwsName((String)image.getRootDeviceType());
                this.virtualisationType = AwsSupportConstants.Virtualisation.fromAwsName((String)image.getVirtualizationType());
                this.region = this.getCurrentRegion();
                if (CollectionUtils.isEmpty(this.instanceTypes)) {
                    AwsSupportConstants.Architecture imageArchitecture = AwsSupportConstants.Architecture.fromAwsName((String)image.getArchitecture());
                    EC2InstanceType instanceType = imageArchitecture == AwsSupportConstants.Architecture.i386 ? ElasticInstanceManager.DEFAULT_INSTANCE_TYPE_32 : ElasticInstanceManager.DEFAULT_INSTANCE_TYPE_64;
                    this.instanceTypes = Collections.singleton(instanceType);
                }
            }
        }
        catch (RuntimeException e) {
            this.addFieldError("amiId", this.getTextWithArgs("elastic.image.configuration.error.amiId.awsUnavailable", e.toString()));
        }
        if (this.platform == AwsSupportConstants.Platform.windows && !StringUtils.containsIgnoreCase((CharSequence)this.product, (CharSequence)"Windows")) {
            this.addFieldError("product", this.getTextWithArgs("elastic.image.configuration.error.product.doesNotMatchPlatform", this.product));
        }
        if (this.platform == AwsSupportConstants.Platform.linux && !StringUtils.containsIgnoreCase((CharSequence)this.product, (CharSequence)"Linux")) {
            this.addFieldError("product", this.getTextWithArgs("elastic.image.configuration.error.product.doesNotMatchPlatform", this.product));
        }
    }

    @Nullable
    private Image getImage() {
        if (this.amiId == null) {
            return null;
        }
        return (Image)Iterables.getOnlyElement((Iterable)this.awsAccountBean.getAwsAccount().describeImages(new String[]{this.amiId}), null);
    }

    public List<ElasticImageConfiguration> getElasticImageConfigurations() {
        return this.elasticImageConfigurationManager.getAllElasticImageConfigurationsForCurrentRegion().stream().sorted(this::compareElasticImageConfigurations).collect(Collectors.toList());
    }

    private int compareElasticImageConfigurations(ElasticImageConfiguration o1, ElasticImageConfiguration o2) {
        if (o2.isShippedWithBamboo() && o1.isShippedWithBamboo()) {
            return new CompareToBuilder().append((Object)o2.getConfigurationName(), (Object)o1.getConfigurationName(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }
        return new CompareToBuilder().append(o2.isShippedWithBamboo(), o1.isShippedWithBamboo()).append((Object)o1.getConfigurationName(), (Object)o2.getConfigurationName(), String.CASE_INSENSITIVE_ORDER).toComparison();
    }

    private AwsSupportConstants.Region getCurrentRegion() {
        return this.getElasticConfig().getRegion();
    }

    public int getAgentCountForImage(long id) {
        return this.elasticImageConfigurationManager.getElasticAgentCountForImageConfiguration(id);
    }

    public int getScheduleCountForImage(ElasticImageConfiguration elasticImageConfiguration) {
        return this.elasticInstanceScheduleManager.getElasticInstanceSchedules(elasticImageConfiguration).size();
    }

    public int getBuildCountForImage(long id) {
        return this.elasticImageConfigurationManager.getBuildsCountForImageConfiguration(id);
    }

    public Collection<EC2InstanceType> getAvailableInstanceTypes() {
        VirtualizationType virtualizationType = this.getVirtualizationTypeForImage();
        return this.elasticInstanceManager.getAllowedInstanceTypes().stream().filter(i -> virtualizationType == null || i.supports(virtualizationType)).collect(Collectors.toList());
    }

    public Collection<CapabilityType> getCapabilityTypes() {
        return this.capabilityHelper.getCapabilityTypes();
    }

    @NotNull
    public TreeMap<String, AvailabilityZone> getAvailabilityZones() {
        try {
            return new TreeMap<String, AvailabilityZone>(this.awsAccountBean.getAvailabilityZones());
        }
        catch (AWSException e) {
            log.warn((Object)"Unable to get availability zones", (Throwable)e);
            return new TreeMap<String, AvailabilityZone>();
        }
    }

    @Override
    public boolean hasPlanPermission(String permission, PlanIdentifier plan) {
        return this.cachingPermissionManagerFacade.hasPermission(BambooPermission.buildFromName((String)permission), (Object)plan);
    }

    @NotNull
    public Collection<ImmutableBuildable> getExecutableBuildables() {
        return this.executableBuildables.get();
    }

    @NotNull
    private Collection<ImmutableBuildable> fetchExecutableBuildables() {
        ImageCapabilitySet capabilitySet = this.configuration.getCapabilitySet();
        Collection buildables = this.executableAgentsHelper.getExecutableBuildables(ExecutableAgentsHelper.ExecutableQuery.newQuery((ReadOnlyCapabilitySet)capabilitySet, (Iterable)AgentAssignmentServiceHelper.asExecutors((ElasticImageConfiguration)this.configuration)));
        this.cachingPermissionManagerFacade.primeAclCache((Iterable)buildables);
        return buildables;
    }

    @NotNull
    public List<DecoratedEnvironment> getExecutableEnvironments() {
        return this.executableEnvironments.get();
    }

    private List<DecoratedEnvironment> fetchExecutableEnvironments() {
        ExecutableAgentsHelper.ExecutableQuery query = ExecutableAgentsHelper.ExecutableQuery.newQuery((ReadOnlyCapabilitySet)this.configuration.getCapabilitySet(), (Iterable)AgentAssignmentServiceHelper.asExecutors((ElasticImageConfiguration)this.configuration));
        return (List)this.executableAgentsHelper.getExecutableEnvironments(query).stream().map(this.environmentService.getEnvironmentDecorator()).sorted(EnvironmentComparators.byDeploymentProjectIdEnvironmentPositionAndName()).collect(this.cachingPermissionManagerFacade.aclCachePrimerCollector(Collectors.toList()));
    }

    public DeploymentProject getDeploymentProject(long deploymentProjectId) {
        return (DeploymentProject)this.deploymentProjectMap.getUnchecked((Object)deploymentProjectId);
    }

    public Map<String, String> getSubnetMap() {
        return this.nameToSubnetId.get();
    }

    public Collection<String> getSubnets() {
        return this.subnetIds;
    }

    public void setSubnets(Collection<String> subnetIds) {
        this.subnetIds = subnetIds;
    }

    @NotNull
    private static String getSubnetName(Vpc vpc, Subnet subnet) {
        String vpcName = (String)StringUtils.defaultIfEmpty((CharSequence)ConfigureElasticImageConfiguration.getNameFromTag(vpc.getTags()), (CharSequence)vpc.getVpcId());
        String subnetName = (String)StringUtils.defaultIfEmpty((CharSequence)ConfigureElasticImageConfiguration.getNameFromTag(subnet.getTags()), (CharSequence)subnet.getSubnetId());
        return String.format("%s - %s (%s) %s", vpcName, subnetName, subnet.getCidrBlock(), subnet.getAvailabilityZone());
    }

    @Nullable
    private static String getNameFromTag(Iterable<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getKey().equalsIgnoreCase("Name")) continue;
            return tag.getValue();
        }
        return null;
    }

    public Collection<String> getProducts() {
        try {
            return this.awsAccountBean.getAwsAccount().getSpotPrices().getProducts();
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean isVpcEnabled() {
        return !this.subnetIds.isEmpty();
    }

    public void setVpcEnabled(boolean value) {
        this.vpcEnabled = true;
    }

    public long getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(long configurationId) {
        this.configurationId = configurationId;
    }

    public ElasticImageConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfirmDelete(boolean confirmDelete) {
        this.confirmDelete = confirmDelete;
    }

    public void setConfirmDisable(boolean confirmDisable) {
        this.confirmDisable = confirmDisable;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getConfigurationDescription() {
        return this.configurationDescription;
    }

    public void setConfigurationDescription(String configurationDescription) {
        this.configurationDescription = configurationDescription;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    public Integer getRootFsSizeOverride() {
        return this.rootFsSizeOverride;
    }

    public void setRootFsSizeOverride(Integer rootFsSizeOverride) {
        this.rootFsSizeOverride = rootFsSizeOverride;
    }

    public boolean isEbsEnabled() {
        return this.ebsEnabled;
    }

    public void setEbsEnabled(boolean ebsEnabled) {
        this.ebsEnabled = ebsEnabled;
    }

    public boolean isPerSecondBillingEnabled() {
        return this.perSecondBillingEnabled;
    }

    public void setPerSecondBillingEnabled(boolean value) {
        this.perSecondBillingEnabled = value;
    }

    public String getEbsSnapshotId() {
        return this.ebsSnapshotId;
    }

    public void setEbsSnapshotId(String ebsSnapshotId) {
        this.ebsSnapshotId = ebsSnapshotId;
    }

    public boolean isLegacyEbsHandlingEnabled() {
        return this.useLegacyEbsHandling;
    }

    public void setLegacyEbsHandlingEnabled(boolean useLegacyEbsHandling) {
        this.useLegacyEbsHandling = useLegacyEbsHandling;
    }

    public Collection<String> getInstanceTypes() {
        return this.instanceTypes.stream().map(Enum::name).collect(Collectors.toList());
    }

    @Nullable
    private VirtualizationType getVirtualizationTypeForImage() {
        Image image = this.getImage();
        VirtualizationType virtualizationType = null;
        if (image != null) {
            try {
                virtualizationType = VirtualizationType.fromValue((String)image.getVirtualizationType());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return virtualizationType;
    }

    public void setInstanceTypes(Collection<EC2InstanceType> instanceTypes) {
        this.instanceTypes = instanceTypes;
    }

    public String getAvailabilityZone() {
        return (String)Iterables.getFirst(this.availabilityZones, null);
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZones = Collections.singletonList(availabilityZone);
    }

    public String getStartupScript() {
        return this.startupScript;
    }

    public void setStartupScript(String startupScript) {
        this.startupScript = startupScript;
    }

    public ElasticUIBean getElasticUIBean() {
        return this.elasticUIBean;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getDefaultAvailabilityZone() {
        return "bamboo-default-availability-zone";
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public void setIamInstanceProfile(String iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public boolean isEbsOptimised() {
        return this.isEbsOptimised;
    }

    public void setEbsOptimised(boolean value) {
        this.isEbsOptimised = value;
    }
}

