/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.AutomaticInstanceManagementConfig;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfigurationImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.event.aws.ElasticBambooConfigChangedEventImpl;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.admin.elastic.BambooAwsUtils;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.aware.BypassValidationAware;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.struts.Preparable;
import com.atlassian.xwork.ParameterSafe;
import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
@Component
public class ConfigureElasticCloudAction
extends GlobalAdminAction
implements GlobalAdminSecurityAware,
BypassValidationAware,
Preparable {
    private static final String PRIVATE_KEY_NAME = "ebsPrivateKey.pem";
    private static final String CERTIFICATE_FILE_NAME = "ebsCertificate.pem";
    private static final String FIELD_PRIVATE_KEY_FILE_UPLOAD = "fieldAwsPrivateKeyFileUpload";
    private static final String FIELD_CERT_FILE_UPLOAD = "fieldAwsCertFileUpload";
    private boolean elasticIpManagementEnabled;
    private AwsSupportConstants.Region region;
    private static final Logger log = Logger.getLogger(ConfigureElasticCloudAction.class);
    private ElasticConfiguration elasticConfig;
    private String awsSecretAccessKeyChange;
    private String isSendTest;
    private String fieldAwsAccessKeyId;
    private String fieldAwsSecretAccessKey;
    private int fieldMaxConcurrentInstances;
    private boolean fieldAutoShutdownEnabled;
    private String fieldAutoShutdownDelay;
    private boolean fieldUploadingOfAwsAccountDetailsEnabled;
    private String elasticConfigureKeysMethod;
    private Map<String, File> fileParameters;
    private String fieldAwsPrivateKeyFile;
    private String fieldAwsCertFile;
    private boolean showHint = false;
    private int fieldMaxNonBambooInstances;
    private int fieldAverageTimeInQueueThresholdInMinutes;
    private int fieldElasticBuildsInQueueThreshold;
    private int fieldTotalBuildInQueueThreshold;
    private int fieldMaxElasticInstancesToStartAtOnce;
    private int fieldInstanceIdleTimeThresholdInMinutes;
    private boolean fieldAutoInstanceManagementEnabled;
    private String autoInstanceManagementConfigPreset;
    private boolean fieldElasticWizard;
    private List<RemoteElasticInstance> requestedElasticInstances;
    private List<RemoteElasticInstance> runningElasticInstances;
    private Map<String, AutoElasticConfigPreset> presetsMap = new LinkedHashMap<String, AutoElasticConfigPreset>();
    @Autowired
    private BambooLicenseManager bambooLicenseManager;
    @Autowired
    private ElasticAccountBean elasticAccountBean;
    @Autowired
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    @Autowired
    private ElasticInstanceManager elasticInstanceManager;
    @Autowired
    private ElasticUIBean elasticUIBean;
    @Autowired
    private EventPublisher eventPublisher;

    public void prepare() throws Exception {
        for (AutomaticInstanceManagementConfig config : this.elasticUIBean.getAutoInstanceManagementConfigs().values()) {
            if (config == AutomaticInstanceManagementConfig.DISABLED_INSTANCE_MANAGEMENT_CONFIG || config == AutomaticInstanceManagementConfig.CUSTOM_INSTANCE_MANAGEMENT_CONFIG) {
                this.presetsMap.put(config.getConfigurationName(), new AutoElasticConfigPreset(this.getText("elastic.configure.field.automaticInstanceManagement." + config.getConfigurationName()), this.getText("elastic.configure.field.automaticInstanceManagement." + config.getConfigurationName() + ".description"), this.generateJsValuesArray(config), this.getText("elastic.configure.field.automaticInstanceManagement.user.defined")));
                continue;
            }
            this.presetsMap.put(config.getConfigurationName(), new AutoElasticConfigPreset(this.getText("elastic.configure.field.automaticInstanceManagement." + config.getConfigurationName()), this.getText("elastic.configure.field.automaticInstanceManagement." + config.getConfigurationName() + ".description"), this.generateJsValuesArray(config), this.getText("elastic.configure.field.automaticInstanceManagement.presets")));
        }
    }

    public void validate() {
        KeyProvisioningMethod keyProvisioningMethod;
        boolean needToValidateFilesOnServer;
        this.elasticFunctionalityFacade.isElasticSupportPossible((ErrorCollection)this);
        if (this.hasAnyErrors()) {
            return;
        }
        if (this.getFieldMaxConcurrentInstances() <= 0) {
            this.addFieldError("fieldMaxConcurrentInstances", "Please enter a whole number larger than zero");
        } else if (this.getFieldMaxConcurrentInstances() > this.getBambooLicenseManager().getAllowedNumberOfRemoteAgents() && this.bambooLicenseManager.getAllowedNumberOfRemoteAgents() >= 0) {
            this.addFieldError("fieldMaxConcurrentInstances", "Your license only permits " + this.bambooLicenseManager.getAllowedNumberOfRemoteAgents() + " remote agents, you can not set the maximum elastic instances higher than your remote agent allowance.");
        }
        if (StringUtils.isBlank((CharSequence)this.getFieldAwsAccessKeyId())) {
            this.addFieldError("fieldAwsAccessKeyId", this.getText("elastic.configure.aws.field.accessKeyId.required"));
        }
        if (this.getAwsSecretAccessKeyChange() != null && StringUtils.isBlank((CharSequence)this.getFieldAwsSecretAccessKey())) {
            this.addFieldError("fieldAwsSecretAccessKey", this.getText("elastic.configure.aws.field.secretAccessKey.required"));
        }
        boolean bl = needToValidateFilesOnServer = (keyProvisioningMethod = KeyProvisioningMethod.valueOf(this.elasticConfigureKeysMethod)) == KeyProvisioningMethod.BAMBOO_SERVER_LOCATION && (!StringUtils.isBlank((CharSequence)this.getFieldAwsPrivateKeyFile()) || !StringUtils.isBlank((CharSequence)this.getFieldAwsCertFile()));
        if (keyProvisioningMethod == KeyProvisioningMethod.UPLOAD) {
            ActionParametersMapImpl params = new ActionParametersMapImpl(ActionContext.getContext(), true);
            this.fileParameters = params.getFiles();
        }
        if (this.isFieldUploadingOfAwsAccountDetailsEnabled() || needToValidateFilesOnServer || !MapUtils.isEmpty(this.fileParameters)) {
            switch (keyProvisioningMethod) {
                case BAMBOO_SERVER_LOCATION: {
                    File awsCertFile;
                    String awsCertFileLocation;
                    File awsPrivateKeyFile;
                    String awsPrivateKeyFileLocation = this.getFieldAwsPrivateKeyFile();
                    if (!(StringUtils.isBlank((CharSequence)awsPrivateKeyFileLocation) || (awsPrivateKeyFile = new File(awsPrivateKeyFileLocation)).exists() && awsPrivateKeyFile.isFile() && awsPrivateKeyFile.canRead())) {
                        this.addFieldError("fieldAwsPrivateKeyFile", this.getText("elastic.configure.aws.field.privateKeyFile.file"));
                    }
                    if (StringUtils.isBlank((CharSequence)(awsCertFileLocation = this.getFieldAwsCertFile())) || (awsCertFile = new File(awsCertFileLocation)).exists() && awsCertFile.isFile() && awsCertFile.canRead()) break;
                    this.addFieldError("fieldAwsCertFile", this.getText("elastic.configure.aws.field.certFile.file"));
                    break;
                }
                case UPLOAD: {
                    File file = this.fileParameters.get(FIELD_PRIVATE_KEY_FILE_UPLOAD);
                    if (file == null) {
                        this.addFieldError(FIELD_PRIVATE_KEY_FILE_UPLOAD, this.getText("elastic.configure.field.awsPrivateKeyFile.upload.required"));
                    } else if (!(file.isFile() && file.canRead() && file.canWrite())) {
                        this.addFieldError(FIELD_PRIVATE_KEY_FILE_UPLOAD, this.getText("elastic.configure.field.awsPrivateKey.file.upload.missing"));
                    }
                    file = this.fileParameters.get(FIELD_CERT_FILE_UPLOAD);
                    if (file == null) {
                        this.addFieldError(FIELD_CERT_FILE_UPLOAD, this.getText("elastic.configure.field.awsCertFile.upload.required"));
                        break;
                    }
                    if (file.isFile() && file.canRead() && file.canWrite()) break;
                    this.addFieldError(FIELD_CERT_FILE_UPLOAD, this.getText("elastic.configure.field.awsCertFile.upload.missing"));
                }
            }
        }
        if (this.isFieldAutoShutdownEnabled() && !NumberUtils.isPositiveInteger((String)this.fieldAutoShutdownDelay)) {
            this.addFieldError("fieldAutoShutdownDelay", this.getText("elastic.configure.aws.autoShutdown.delay.error.numeric"));
        }
        this.validateAutomaticInstanceManagementConfig();
        if (!this.hasAnyErrors()) {
            String testPassword = this.getAwsSecretAccessKeyChange() != null ? this.getFieldAwsSecretAccessKey() : this.elasticConfig.getAwsSecretKey();
            this.testAWSCredentials(this.getFieldAwsAccessKeyId(), testPassword);
        }
    }

    private void validateAutomaticInstanceManagementConfig() {
        AutomaticInstanceManagementConfig autoInstanceManagmentConfig = this.elasticUIBean.getAutoInstanceManagementConfigs().get(this.autoInstanceManagementConfigPreset);
        if ("Custom".equals(autoInstanceManagmentConfig.getConfigurationName())) {
            this.validatePositiveField(this.fieldAverageTimeInQueueThresholdInMinutes, "fieldAverageTimeInQueueThreshold");
            this.validatePositiveField(this.fieldElasticBuildsInQueueThreshold, "fieldElasticBuildsInQueueThreshold");
            this.validatePositiveField(this.fieldTotalBuildInQueueThreshold, "fieldTotalBuildInQueueThreshold");
            this.validatePositiveField(this.fieldMaxElasticInstancesToStartAtOnce, "fieldMaxElasticInstancesToStartAtOnce");
            this.validatePositiveField(this.fieldMaxNonBambooInstances, "fieldMaxNonBambooInstances");
            this.validatePositiveField(this.fieldInstanceIdleTimeThresholdInMinutes, "fieldInstanceIdleTimeThreshold");
            if (this.fieldTotalBuildInQueueThreshold < this.fieldElasticBuildsInQueueThreshold) {
                this.addFieldError("fieldElasticBuildsInQueueThreshold", this.getText("elastic.configure.field.automaticInstanceManagement.elastic.builds.in.queue.error"));
            }
        }
    }

    public Map<String, AutoElasticConfigPreset> getAutomaticInstanceManagementPresets() {
        return this.presetsMap;
    }

    public List<AutoElasticConfigPreset> getAutomaticInstanceManagementPresetList() {
        return new ArrayList<AutoElasticConfigPreset>(this.presetsMap.values());
    }

    private String generateJsValuesArray(AutomaticInstanceManagementConfig config) {
        return "[" + config.getInstanceIdleTimeThreshold() / 60000L + "," + config.getMaxElasticInstancesToStartAtOnce() + "," + config.getTotalBuildInQueueThreshold() + "," + config.getElasticBuildsInQueueThreshold() + "," + config.getAverageTimeInQueueThreshold() / 60000L + "]";
    }

    public void setAutomaticInstanceManagementPreset(String presetName) {
        this.autoInstanceManagementConfigPreset = presetName;
    }

    public String getAutomaticInstanceManagementPreset() {
        return this.autoInstanceManagementConfigPreset;
    }

    private void validatePositiveField(int fieldValue, String fieldName) {
        if (fieldValue <= 0) {
            this.addFieldError(fieldName, this.getText("elastic.configure.field.automaticInstanceManagement.error"));
        }
    }

    public String read() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        if (administrationConfiguration != null) {
            this.elasticConfig = administrationConfiguration.getElasticConfig();
            this.setAutomaticInstanceManagementFields(this.elasticConfig);
        }
        this.elasticFunctionalityFacade.isElasticSupportPossible((ErrorCollection)this);
        return "success";
    }

    public String save() throws Exception {
        this.elasticConfig = this.getOrCreateElasticConfig(this.elasticConfig);
        boolean wasEnabled = this.elasticConfig.isEnabled();
        this.validate();
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.getAwsSecretAccessKeyChange() != null) {
            this.elasticConfig.setAwsSecretKey(this.getFieldAwsSecretAccessKey());
        }
        this.elasticConfig.setAwsAccessKeyId(this.getFieldAwsAccessKeyId());
        this.elasticConfig.setMaxConcurrentInstances(this.getFieldMaxConcurrentInstances());
        this.elasticConfig.setEnabled(true);
        this.elasticConfig.setAutoShutdownEnabled(this.isFieldAutoShutdownEnabled());
        this.elasticConfig.setAutoShutdownDelay(Integer.parseInt(this.getFieldAutoShutdownDelay()));
        this.elasticConfig.setUploadingOfAwsAccountDetailsEnabled(this.isFieldUploadingOfAwsAccountDetailsEnabled());
        try {
            this.saveKeys(this.elasticConfig);
        }
        catch (IOException ex) {
            this.addActionError(ex);
            return "error";
        }
        AutomaticInstanceManagementConfig autoInstanceManagmentConfig = this.elasticUIBean.getAutoInstanceManagementConfigs().get(this.autoInstanceManagementConfigPreset);
        if ("Custom".equals(autoInstanceManagmentConfig.getConfigurationName())) {
            autoInstanceManagmentConfig.setAverageTimeInQueueThreshold((long)this.fieldAverageTimeInQueueThresholdInMinutes * 60000L);
            autoInstanceManagmentConfig.setElasticBuildsInQueueThreshold(this.fieldElasticBuildsInQueueThreshold);
            autoInstanceManagmentConfig.setInstanceIdleTimeThreshold((long)this.fieldInstanceIdleTimeThresholdInMinutes * 60000L);
            autoInstanceManagmentConfig.setMaxElasticInstancesToStartAtOnce(this.fieldMaxElasticInstancesToStartAtOnce);
            autoInstanceManagmentConfig.setMaxNonBambooInstances(this.fieldMaxNonBambooInstances);
            autoInstanceManagmentConfig.setTotalBuildInQueueThreshold(this.fieldTotalBuildInQueueThreshold);
        }
        this.elasticConfig.setAutomaticInstanceManagementConfig(autoInstanceManagmentConfig);
        this.elasticConfig.setPublicIpForVpcEnabled(this.featureManager.isPublicIpRequiredForVpc() || this.elasticIpManagementEnabled);
        this.elasticConfig.setRegion(this.region);
        this.elasticAccountBean.saveElasticConfig(this.elasticConfig);
        this.eventPublisher.publish((Object)new ElasticBambooConfigChangedEventImpl(this.region.toString(), this.isFieldElasticWizard(), wasEnabled));
        return "success";
    }

    private void saveKeys(ElasticConfiguration elasticConfig) throws IOException {
        switch (KeyProvisioningMethod.valueOf(this.elasticConfigureKeysMethod)) {
            case BAMBOO_SERVER_LOCATION: {
                elasticConfig.setAwsPrivateKeyFile(this.getFieldAwsPrivateKeyFile());
                elasticConfig.setAwsCertFile(this.getFieldAwsCertFile());
                break;
            }
            case UPLOAD: {
                File certFile;
                File privateKeyFile = this.fileParameters.get(FIELD_PRIVATE_KEY_FILE_UPLOAD);
                if (privateKeyFile != null) {
                    elasticConfig.setAwsPrivateKeyFile(this.storeUploadedFile(privateKeyFile, PRIVATE_KEY_NAME));
                }
                if ((certFile = this.fileParameters.get(FIELD_CERT_FILE_UPLOAD)) == null) break;
                elasticConfig.setAwsCertFile(this.storeUploadedFile(certFile, CERTIFICATE_FILE_NAME));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key provisioning method " + this.elasticConfigureKeysMethod);
            }
        }
    }

    private String storeUploadedFile(@NotNull File temp, @NotNull String name) throws IOException {
        File configDirectory = SystemDirectory.getConfigDirectory();
        File newFile = new File(configDirectory, name);
        if (newFile.exists()) {
            String date = DateTimeFormat.forPattern((String)"YYYYMMdd_hhmmss_").print((ReadableInstant)new DateTime());
            String prefixedName = date + name;
            newFile = new File(configDirectory, prefixedName);
        }
        FileUtils.moveFile((File)temp, (File)newFile);
        newFile.setReadable(false, false);
        newFile.setReadable(true, true);
        newFile.setReadOnly();
        newFile.setExecutable(false, false);
        return newFile.getAbsolutePath();
    }

    public boolean isFieldAutoInstanceManagementEnabled() {
        return this.fieldAutoInstanceManagementEnabled;
    }

    public boolean isFieldElasticWizard() {
        return this.fieldElasticWizard;
    }

    public void setFieldElasticWizard(boolean fieldElasticWizard) {
        this.fieldElasticWizard = fieldElasticWizard;
    }

    public String edit() throws Exception {
        KeyProvisioningMethod.BAMBOO_SERVER_LOCATION.setDisplayName(this.getText("elastic.configure.key.provide.local"));
        KeyProvisioningMethod.UPLOAD.setDisplayName(this.getText("elastic.configure.key.provide.upload"));
        this.elasticConfig = this.getOrCreateElasticConfig(this.elasticConfig);
        this.setFieldAwsAccessKeyId(this.elasticConfig.getAwsAccessKeyId());
        this.setFieldMaxConcurrentInstances(this.elasticConfig.getMaxConcurrentInstances());
        this.setFieldAutoShutdownEnabled(this.elasticConfig.isAutoShutdownEnabled());
        this.setFieldAutoShutdownDelay(String.valueOf(this.elasticConfig.getAutoShutdownDelay()));
        this.setFieldUploadingOfAwsAccountDetailsEnabled(this.elasticConfig.isUploadingOfAwsAccountDetailsEnabled());
        this.setFieldAwsPrivateKeyFile(this.elasticConfig.getAwsPrivateKeyFile());
        this.setFieldAwsCertFile(this.elasticConfig.getAwsCertFile());
        this.setAutomaticInstanceManagementFields(this.elasticConfig);
        this.region = this.elasticConfig.getRegion();
        return "success";
    }

    @NotNull
    public List<KeyProvisioningMethod> getKeyProvideMethods() {
        return Arrays.asList(KeyProvisioningMethod.values());
    }

    public String getRegion() {
        return this.region.name();
    }

    public void setRegion(@NotNull String region) {
        this.region = AwsSupportConstants.Region.valueOf((String)region);
    }

    @NotNull
    public Collection<AwsSupportConstants.Region> getAvailableRegions() {
        return BambooAwsUtils.getBambooSupportedRegions();
    }

    private void setAutomaticInstanceManagementFields(@Nullable ElasticConfiguration elasticConfig) {
        if (elasticConfig == null) {
            return;
        }
        this.autoInstanceManagementConfigPreset = this.elasticConfig.getAutomaticInstanceManagementConfig().getConfigurationName();
        this.setFieldAutoInstanceManagementEnabled(this.elasticConfig.getAutomaticInstanceManagementConfig().isAutomaticInstanceManagementEnabled());
        this.setFieldAverageTimeInQueueThreshold((int)this.elasticConfig.getAutomaticInstanceManagementConfig().getAverageTimeInQueueThreshold() / 60000);
        this.setFieldElasticBuildsInQueueThreshold(this.elasticConfig.getAutomaticInstanceManagementConfig().getElasticBuildsInQueueThreshold());
        this.setFieldInstanceIdleTimeThreshold((int)this.elasticConfig.getAutomaticInstanceManagementConfig().getInstanceIdleTimeThreshold() / 60000);
        this.setFieldMaxElasticInstancesToStartAtOnce(this.elasticConfig.getAutomaticInstanceManagementConfig().getMaxElasticInstancesToStartAtOnce());
        this.setFieldMaxNonBambooInstances(this.elasticConfig.getAutomaticInstanceManagementConfig().getMaxNonBambooInstances());
        this.setFieldTotalBuildInQueueThreshold(this.elasticConfig.getAutomaticInstanceManagementConfig().getTotalBuildInQueueThreshold());
    }

    private void testAWSCredentials(String login, String password) {
        if (new SystemProperty.BooleanSystemProperty(false, false, new String[]{"functestmode"}).getTypedValue()) {
            return;
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.elasticInstanceManager.validateAwsCredentials(this.region, login, password, (ErrorCollection)errorCollection);
        this.addErrorCollection((ErrorCollection)errorCollection);
    }

    public String disable() throws Exception {
        this.elasticFunctionalityFacade.setElasticSupportEnabled(false);
        return "success";
    }

    public String confirmDisable() throws Exception {
        return "input";
    }

    public String enable() throws Exception {
        return "success";
    }

    private ElasticConfiguration getOrCreateElasticConfig(ElasticConfiguration elasticConfig) {
        ElasticConfiguration existingElasticConfig;
        if (elasticConfig != null) {
            return elasticConfig;
        }
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        if (administrationConfiguration != null && (existingElasticConfig = administrationConfiguration.getElasticConfig()) != null) {
            return existingElasticConfig;
        }
        ElasticConfigurationImpl configuration = new ElasticConfigurationImpl();
        configuration.setMaxConcurrentInstances(this.getDefaultConcurrentInstances());
        return configuration;
    }

    @Override
    public boolean isValidationBypassed() {
        return this.elasticConfig == null || !this.elasticConfig.isEnabled();
    }

    private int getDefaultConcurrentInstances() {
        return this.elasticFunctionalityFacade.getMaxConcurrentInstances();
    }

    @Override
    @ParameterSafe
    public ElasticConfiguration getElasticConfig() {
        return this.elasticConfig;
    }

    public void setElasticConfig(ElasticConfiguration elasticConfig) {
        this.elasticConfig = elasticConfig;
    }

    public String getAwsSecretAccessKeyChange() {
        return this.awsSecretAccessKeyChange;
    }

    public void setAwsSecretAccessKeyChange(String awsSecretAccessKeyChange) {
        this.awsSecretAccessKeyChange = awsSecretAccessKeyChange;
    }

    public String getSendTest() {
        return this.isSendTest;
    }

    public void setSendTest(String sendTest) {
        this.isSendTest = sendTest;
    }

    public String getFieldAwsSecretAccessKey() {
        return this.fieldAwsSecretAccessKey;
    }

    public void setFieldAwsSecretAccessKey(String fieldAwsSecretAccessKey) {
        this.fieldAwsSecretAccessKey = fieldAwsSecretAccessKey;
    }

    public String getFieldAwsAccessKeyId() {
        return this.fieldAwsAccessKeyId;
    }

    public void setFieldAwsAccessKeyId(String fieldAwsAccessKeyId) {
        this.fieldAwsAccessKeyId = fieldAwsAccessKeyId;
    }

    public int getFieldMaxConcurrentInstances() {
        return this.fieldMaxConcurrentInstances;
    }

    public void setFieldMaxConcurrentInstances(int fieldMaxConcurrentInstances) {
        this.fieldMaxConcurrentInstances = fieldMaxConcurrentInstances;
    }

    public boolean isFieldAutoShutdownEnabled() {
        return this.fieldAutoShutdownEnabled;
    }

    public void setFieldAutoShutdownEnabled(boolean fieldAutoShutdownEnabled) {
        this.fieldAutoShutdownEnabled = fieldAutoShutdownEnabled;
    }

    public void setFieldAutoInstanceManagementEnabled(boolean fieldAutoInstanceManagementEnabled) {
        this.fieldAutoInstanceManagementEnabled = fieldAutoInstanceManagementEnabled;
    }

    public String getFieldAutoShutdownDelay() {
        return this.fieldAutoShutdownDelay;
    }

    public void setFieldAutoShutdownDelay(String fieldAutoShutdownDelay) {
        this.fieldAutoShutdownDelay = fieldAutoShutdownDelay;
    }

    public boolean isFieldUploadingOfAwsAccountDetailsEnabled() {
        return this.fieldUploadingOfAwsAccountDetailsEnabled;
    }

    public void setFieldUploadingOfAwsAccountDetailsEnabled(boolean fieldUploadingOfAwsAccountDetailsEnabled) {
        this.fieldUploadingOfAwsAccountDetailsEnabled = fieldUploadingOfAwsAccountDetailsEnabled;
    }

    public String getFieldAwsPrivateKeyFile() {
        return this.fieldAwsPrivateKeyFile;
    }

    public void setFieldAwsPrivateKeyFile(String fieldAwsPrivateKeyFile) {
        this.fieldAwsPrivateKeyFile = fieldAwsPrivateKeyFile;
    }

    public String getElasticConfigureKeysMethod() {
        return this.elasticConfigureKeysMethod;
    }

    public void setElasticConfigureKeysMethod(String elasticConfigureKeysMethod) {
        this.elasticConfigureKeysMethod = elasticConfigureKeysMethod;
    }

    public String getFieldAwsCertFile() {
        return this.fieldAwsCertFile;
    }

    public void setFieldAwsCertFile(String fieldAwsCertFile) {
        this.fieldAwsCertFile = fieldAwsCertFile;
    }

    public boolean isRemoteAgentFunctionEnabled() {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        return administrationConfiguration != null && administrationConfiguration.isRemoteAgentFunctionEnabled();
    }

    public boolean isShowHint() {
        return this.showHint;
    }

    public void setShowHint(boolean showHint) {
        this.showHint = showHint;
    }

    public int getFieldAverageTimeInQueueThreshold() {
        return this.fieldAverageTimeInQueueThresholdInMinutes;
    }

    public void setFieldAverageTimeInQueueThreshold(int fieldAverageTimeInQueueThreshold) {
        this.fieldAverageTimeInQueueThresholdInMinutes = fieldAverageTimeInQueueThreshold;
    }

    public int getFieldElasticBuildsInQueueThreshold() {
        return this.fieldElasticBuildsInQueueThreshold;
    }

    public void setFieldElasticBuildsInQueueThreshold(int fieldElasticBuildsInQueueThreshold) {
        this.fieldElasticBuildsInQueueThreshold = fieldElasticBuildsInQueueThreshold;
    }

    public int getFieldTotalBuildInQueueThreshold() {
        return this.fieldTotalBuildInQueueThreshold;
    }

    public void setFieldTotalBuildInQueueThreshold(int fieldTotalBuildInQueueThreshold) {
        this.fieldTotalBuildInQueueThreshold = fieldTotalBuildInQueueThreshold;
    }

    public int getFieldMaxElasticInstancesToStartAtOnce() {
        return this.fieldMaxElasticInstancesToStartAtOnce;
    }

    public void setFieldMaxElasticInstancesToStartAtOnce(int fieldMaxElasticInstancesToStartAtOnce) {
        this.fieldMaxElasticInstancesToStartAtOnce = fieldMaxElasticInstancesToStartAtOnce;
    }

    public int getFieldMaxNonBambooInstances() {
        return this.fieldMaxNonBambooInstances;
    }

    public void setFieldMaxNonBambooInstances(int fieldMaxNonBambooInstances) {
        this.fieldMaxNonBambooInstances = fieldMaxNonBambooInstances;
    }

    public int getFieldInstanceIdleTimeThreshold() {
        return this.fieldInstanceIdleTimeThresholdInMinutes;
    }

    public void setFieldInstanceIdleTimeThreshold(int fieldInstanceIdleTimeThreshold) {
        this.fieldInstanceIdleTimeThresholdInMinutes = fieldInstanceIdleTimeThreshold;
    }

    public int getRequestedElasticInstancesCount() {
        if (this.requestedElasticInstances == null) {
            this.requestedElasticInstances = this.elasticInstanceManager.getRequestedElasticRemoteAgents();
        }
        return this.requestedElasticInstances.size();
    }

    public int getRunningElasticInstancesCount() {
        if (this.runningElasticInstances == null) {
            this.runningElasticInstances = this.elasticInstanceManager.getElasticRemoteAgents();
        }
        return this.runningElasticInstances.size();
    }

    public boolean isElasticIpManagementEnabled() {
        return this.elasticConfig.isPublicIpForVpcEnabled();
    }

    public void setElasticIpManagementEnabled(boolean elasticIpManagementEnabled) {
        this.elasticIpManagementEnabled = elasticIpManagementEnabled;
    }

    public String getLicenseTier() {
        BambooLicense license = this.bambooLicenseManager.getLicense();
        return license != null ? license.getDescription() : this.getText("license.error.missing");
    }

    public boolean isOnDemand() {
        return false;
    }

    public static class AutoElasticConfigPreset {
        private final String name;
        private final String explanation;
        private final String jsArrayValues;
        private String group;

        public AutoElasticConfigPreset(String name, String explanation, String jsArrayValues, String group) {
            this.name = name;
            this.explanation = explanation;
            this.jsArrayValues = jsArrayValues;
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public String getJsArrayValues() {
            return this.jsArrayValues;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public static enum KeyProvisioningMethod {
        BAMBOO_SERVER_LOCATION("Files stored on your Bamboo server"),
        UPLOAD("Upload Files");

        private String displayName;

        private KeyProvisioningMethod(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String name) {
            this.displayName = name;
        }

        public String getKey() {
            return this.name();
        }
    }
}

