/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.configuration.agent.CapabilityConfigurationSupport;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySetImpl;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import org.apache.log4j.Logger;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class ConfigureElasticCapability
extends CapabilityConfigurationSupport {
    private static final Logger log = Logger.getLogger(ConfigureElasticCapability.class);
    private long configurationId;
    private ElasticImageConfiguration configuration;
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    private AuditLogService auditLogService;

    public void prepare() throws Exception {
        this.configuration = this.elasticImageConfigurationManager.getElasticImageConfigurationById(this.configurationId);
        if (this.configuration != null) {
            this.capabilitySet = this.configuration.getCapabilitySet();
        } else {
            this.addActionError("Could not find appropriate image configuration: " + this.configurationId);
        }
    }

    public String addCapability() {
        Capability capability;
        if (!this.validateCapability()) {
            return "input";
        }
        if (this.capabilitySet == null) {
            this.capabilitySet = new ImageCapabilitySetImpl();
        }
        if (this.capabilitySet.getCapability((capability = this.capabilityHelper.getCapabilityTypeFromTypeString(this.capabilityType).getCapability(ActionParamsUtils.getStringArrayMap())).getKey()) != null) {
            this.addActionError("Cannot add this capability as it already exists");
            return "input";
        }
        this.capabilitySet.addCapability(capability);
        this.capabilitySetManager.saveCapabilitySet(this.capabilitySet);
        this.auditLogService.log("Capability added to Elastic Image Configuration " + this.configuration.getConfigurationName(), null, capability.toString(), null);
        return "success";
    }

    public String removeCapability() {
        if (this.capabilitySet == null) {
            this.addActionError("Failed to remove cability, capability set could not be found");
            return "error";
        }
        Capability capability = this.capabilitySet.getCapability(this.capabilityKey);
        this.capabilitySet.removeCapability(this.capabilityKey);
        this.capabilitySetManager.saveCapabilitySet(this.capabilitySet);
        this.auditLogService.log("Capability removed from Elastic Image Configuration " + this.configuration.getConfigurationName(), capability.toString(), null, null);
        return "success";
    }

    public String reloadDefaultCapabilities() {
        this.elasticImageConfigurationManager.populateDefaultCapabilitySet((CapabilitySet)this.configuration.getCapabilitySet(), this.configuration);
        this.elasticImageConfigurationManager.saveElasticImageConfiguration(this.configuration);
        this.addActionMessage(this.getText("elastic.image.capabilities.update.description"));
        this.auditLogService.log("Capability reset to defaults for Elastic Image Configuration " + this.configuration.getConfigurationName());
        return "success";
    }

    public long getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(long configurationId) {
        this.configurationId = configurationId;
    }

    public ElasticImageConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setElasticImageConfigurationManager(ElasticImageConfigurationManager elasticImageConfigurationManager) {
        this.elasticImageConfigurationManager = elasticImageConfigurationManager;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }
}

