/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.elastic;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.util.Throwables;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountManagementService;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.ManageElasticBambooPermissionCondition;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;

@ConditionallyAccessible(condition={ManageElasticBambooPermissionCondition.class})
public class AllElasticInstancesAction
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(AllElasticInstancesAction.class);
    private AwsAccountBean awsAccountBean;
    private AWSAccount awsAccount;
    private ElasticAccountManagementService elasticAccountManagementService;
    private Collection<Instance> unrelatedElasticInstances;
    private Collection<Instance> disconnectedElasticInstances;
    private ElasticUIBean elasticUIBean;
    private Collection<Volume> detachedVolumes;
    private String instanceId;
    private String volumeId;
    private static final Predicate<Volume> volumeDetached = new Predicate<Volume>(){

        public boolean apply(Volume input) {
            return input.getAttachments().isEmpty();
        }
    };

    public void validate() {
        super.validate();
        try {
            this.awsAccount = this.awsAccountBean.getAwsAccount();
        }
        catch (Exception e) {
            log.error((Object)"Unable to get the information about AWS account", Throwables.getRootCause((Throwable)e));
            this.addActionError(this.getText("elastic.manage.aws.account.error"));
        }
    }

    public Collection<Instance> getDisconnectedElasticInstances() {
        if (this.disconnectedElasticInstances == null) {
            try {
                this.disconnectedElasticInstances = this.elasticAccountManagementService.getDisconnectedElasticInstances();
            }
            catch (AWSException e) {
                log.error((Object)"Unable to retrieve the list of disconnected elastic instances", (Throwable)e);
                this.addActionError(this.getText("elastic.manage.error.get.instances"));
            }
        }
        return this.disconnectedElasticInstances;
    }

    public Collection<SpotInstanceRequest> getAllSpotInstanceRequests() {
        return this.awsAccount.describePendingSpotInstanceRequests(new String[0]);
    }

    public Collection<Instance> getUnrelatedElasticInstances() {
        if (this.unrelatedElasticInstances == null) {
            try {
                this.unrelatedElasticInstances = this.elasticAccountManagementService.getUnrelatedElasticInstances();
            }
            catch (AWSException e) {
                log.error((Object)"Unable to retrieve the list of unrelated elastic instances", (Throwable)e);
                this.addActionError(this.getText("elastic.manage.error.get.instances"));
            }
        }
        return this.unrelatedElasticInstances;
    }

    public String shutdownDisconnectedInstance() {
        try {
            this.awsAccount.shutdownInstance(this.instanceId);
            return "success";
        }
        catch (AWSException e) {
            log.error((Object)"Error when shuting down elastic instace", (Throwable)e);
            this.addActionError(this.getText("elastic.manage.error.shutdow.instance"));
            return "error";
        }
    }

    public String shutdownAllDisconnectedInstances() {
        boolean failure = false;
        for (Instance instance : this.getDisconnectedElasticInstances()) {
            try {
                this.awsAccount.shutdownInstance(instance.getInstanceId());
            }
            catch (AWSException e) {
                log.error((Object)("Error when shuting down elastic instace with id '" + instance.getInstanceId() + "'"), (Throwable)e);
                failure = true;
            }
        }
        if (failure) {
            this.addActionError(this.getText("elastic.manage.error.shutdow.one.or.more.instance"));
            return "error";
        }
        return "success";
    }

    public String deleteAllDetachedEbsVolumes() {
        boolean failure = false;
        for (Volume volume : this.getDetachedVolumes()) {
            try {
                this.awsAccount.deleteVolume(volume.getVolumeId());
            }
            catch (AWSException e) {
                log.error((Object)("Error occurred when deleting ebs volume with id '" + volume.getVolumeId() + "'"), (Throwable)e);
                failure = true;
            }
        }
        if (failure) {
            this.addActionError(this.getText("elastic.manage.error.delete.volume"));
            return "error";
        }
        return "success";
    }

    public String deleteEbsVolume() {
        try {
            this.awsAccount.deleteVolume(this.volumeId);
        }
        catch (AWSException e) {
            log.error((Object)"Error occurred when deleting ebs volume", (Throwable)e);
            this.addActionError("Error occurred when deleting ebs volume");
            return "error";
        }
        return "success";
    }

    public Collection<Volume> getDetachedVolumes() {
        if (this.detachedVolumes == null) {
            try {
                this.detachedVolumes = Collections2.filter((Collection)this.awsAccount.describeVolumes(), volumeDetached);
            }
            catch (AWSException e) {
                log.error((Object)"Unable to retrieve a list of ebs volumes", (Throwable)e);
                return Collections.emptyList();
            }
        }
        return this.detachedVolumes;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public ElasticUIBean getElasticUIBean() {
        return this.elasticUIBean;
    }

    public void setElasticUIBean(ElasticUIBean elasticUIBean) {
        this.elasticUIBean = elasticUIBean;
    }

    public void setAwsAccountBean(AwsAccountBean awsAccountBean) {
        this.awsAccountBean = awsAccountBean;
    }

    public void setElasticAccountManagementService(ElasticAccountManagementService elasticAccountManagementService) {
        this.elasticAccountManagementService = elasticAccountManagementService;
    }
}

