/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.bulk.trigger;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.TriggerUIConfigBean;
import com.atlassian.bamboo.ww2.aware.BareBuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceTriggersAction
extends ChainActionSupport
implements PlanEditSecurityAware,
BareBuildConfigurationAware {
    private static final Logger log = Logger.getLogger(ReplaceTriggersAction.class);
    private BuildConfiguration buildConfiguration;
    private List<TriggerUIConfigBean.TriggerSelector> triggerSelectors;
    private Iterable<TriggerModuleDescriptor> triggerModuleDescriptors;
    private UIConfigSupport uiConfigBean;
    private TriggerConfigurationService triggerConfigurationService;
    private TriggerTypeManager triggerTypeManager;
    private TriggerUIConfigBean triggerUIConfigBean;

    public String view() {
        return "success";
    }

    public String execute() {
        try {
            TriggerModuleDescriptor triggerModuleDescriptor;
            String buildStrategyKey = this.buildConfiguration.getString("selectedBuildStrategy");
            boolean isManual = "manualOnly".equals(buildStrategyKey);
            TriggerModuleDescriptor triggerModuleDescriptor2 = triggerModuleDescriptor = isManual ? null : this.triggerTypeManager.getTriggerDescriptor(buildStrategyKey);
            if (!isManual) {
                if (triggerModuleDescriptor == null) {
                    this.addFieldError("selectedBuildStrategy", this.getText("chain.trigger.invalid.plugin"));
                } else {
                    this.triggerUIConfigBean.validateTriggerConfiguration(triggerModuleDescriptor, this);
                }
                if (this.hasErrors()) {
                    return "error";
                }
            }
            List triggerDefinitions = this.getImmutableChain().getTriggerDefinitions();
            PlanKey planKey = this.getTypedPlanKey();
            for (TriggerDefinition triggerDefinition : triggerDefinitions) {
                this.triggerConfigurationService.deleteTrigger(planKey, triggerDefinition.getId());
            }
            if (isManual) {
                return "success";
            }
            this.triggerConfigurationService.createTrigger(planKey, triggerModuleDescriptor, "", true, this.triggeringRepositoriesFromInput(triggerModuleDescriptor), this.triggerUIConfigBean.getTriggerConfigurationMap(triggerModuleDescriptor, null), this.triggerConditionsConfigurationFromInput());
            return "success";
        }
        catch (Exception e) {
            this.addErrorMessage("An error occurred while replacing plan triggers.", e);
            return "error";
        }
    }

    public String getKeysOfTriggersExpectingRepository() {
        this.initTriggerModuleDescriptors();
        StringBuilder builder = new StringBuilder();
        for (TriggerModuleDescriptor triggerModuleDescriptor : this.triggerModuleDescriptors) {
            TriggerConfigurator triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator();
            if (triggerConfigurator == null || TriggerConfigurator.RepositorySelectionMode.SELECTED != triggerConfigurator.getRepositorySelectionMode()) continue;
            builder.append(triggerModuleDescriptor.getCompleteKey()).append(' ');
        }
        return builder.toString();
    }

    public List<TriggerUIConfigBean.TriggerSelector> getTriggerSelectors() {
        if (this.triggerSelectors == null) {
            this.initTriggerModuleDescriptors();
            this.triggerSelectors = new ArrayList<TriggerUIConfigBean.TriggerSelector>();
            for (TriggerModuleDescriptor triggerModuleDescriptor : this.triggerModuleDescriptors) {
                TriggerConfigurator triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator();
                if (triggerConfigurator == null) continue;
                this.triggerSelectors.add(new TriggerUIConfigBean.TriggerSelector(triggerModuleDescriptor.getCompleteKey(), triggerModuleDescriptor.getName(), triggerModuleDescriptor.getDescription(), this.triggerUIConfigBean.prepareCreateHtml(triggerModuleDescriptor, TaskRenderMode.SUCCESS, (Triggerable)this.getImmutableChain())));
            }
            this.triggerSelectors.add(new TriggerUIConfigBean.TriggerSelector("manualOnly", "Manual", "", ""));
        }
        return this.triggerSelectors;
    }

    public TriggerUIConfigBean.TriggerSelector getSelectedTrigger(String buildStrategyKey) {
        if ("manualOnly".equals(buildStrategyKey)) {
            return new TriggerUIConfigBean.TriggerSelector("manualOnly", "Manual", "Build only when triggered manually", "");
        }
        TriggerModuleDescriptor triggerModuleDescriptor = this.triggerTypeManager.getTriggerDescriptor(buildStrategyKey);
        if (triggerModuleDescriptor == null) {
            return null;
        }
        TriggerDefinition triggerDefinition = new TriggerDefinitionImpl.Builder().fromDescriptor(triggerModuleDescriptor).id(1L).configuration(this.triggerUIConfigBean.getTriggerConfigurationMap(triggerModuleDescriptor, null)).build();
        return new TriggerUIConfigBean.TriggerSelector(triggerModuleDescriptor.getCompleteKey(), triggerModuleDescriptor.getName(), triggerModuleDescriptor.getDescription(), this.triggerUIConfigBean.prepareViewHtml(triggerModuleDescriptor, triggerDefinition, null));
    }

    private void initTriggerModuleDescriptors() {
        if (this.triggerModuleDescriptors == null) {
            this.triggerModuleDescriptors = this.triggerTypeManager.getAvailableTriggerDescriptorsByType(ImmutableChain.class);
        }
    }

    private boolean repositoriesNotUsed(TriggerModuleDescriptor triggerDescriptor) {
        return triggerDescriptor.getTriggerConfigurator() == null || TriggerConfigurator.RepositorySelectionMode.NONE.equals((Object)triggerDescriptor.getTriggerConfigurator().getRepositorySelectionMode());
    }

    @Nullable
    private Set<Long> triggeringRepositoriesFromInput(TriggerModuleDescriptor triggerDescriptor) {
        HashSet triggeringRepositories = null;
        if (!this.repositoriesNotUsed(triggerDescriptor)) {
            triggeringRepositories = Sets.newHashSet((Iterable)Iterables.transform((Iterable)this.getImmutableChain().getPlanRepositoryDefinitions(), (Function)BambooFunctions.getBambooObjectId()));
        }
        return triggeringRepositories;
    }

    @NotNull
    private Map<String, String> triggerConditionsConfigurationFromInput() {
        return Collections.emptyMap();
    }

    public UIConfigSupport getUiConfigBean() {
        return this.uiConfigBean;
    }

    public void setUiConfigBean(UIConfigSupport uiConfigBean) {
        this.uiConfigBean = uiConfigBean;
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        if (this.buildConfiguration == null) {
            this.buildConfiguration = new BuildConfiguration();
        }
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public void setTriggerConfigurationService(TriggerConfigurationService triggerConfigurationService) {
        this.triggerConfigurationService = triggerConfigurationService;
    }

    public void setTriggerUIConfigBean(TriggerUIConfigBean triggerUIConfigBean) {
        this.triggerUIConfigBean = triggerUIConfigBean;
    }

    public void setTriggerTypeManager(TriggerTypeManager triggerTypeManager) {
        this.triggerTypeManager = triggerTypeManager;
    }
}

