/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.bulk.repository;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.LegacyRepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.admin.bulk.BulkAction;
import com.atlassian.bamboo.ww2.actions.admin.bulk.repository.AbstractRepositoryBulkAction;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UpdateWebUrlBulkAction
extends AbstractRepositoryBulkAction {
    private static final Logger log = Logger.getLogger(UpdateWebUrlBulkAction.class);
    private WebRepositoryViewerManager webRepositoryManager;

    public UpdateWebUrlBulkAction(WebRepositoryViewerManager webRepositoryManager) {
        this.webRepositoryManager = webRepositoryManager;
    }

    @Override
    @NotNull
    public String getKey() {
        return "bulk.action.web.url.update";
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.getText("bulkAction.webRepo.title");
    }

    @Override
    @NotNull
    public String getChangedItem() {
        return this.getText("bulkAction.webRepo.changedItem");
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getViewAction() {
        return new BulkAction.WebWorkActionImpl("/chain/admin", "viewWebUrl");
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getViewUpdatedAction() {
        return new BulkAction.WebWorkActionImpl("/build/admin", "viewUpdatedWebUrl");
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getEditSnippetAction() {
        return new BulkAction.WebWorkActionImpl("/admin", "editWebUrlSnippet");
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getExecuteAction() {
        return new BulkAction.WebWorkActionImpl("/chain/admin/config", "updateRepository");
    }

    @Override
    public boolean isApplicable(ImmutablePlan plan) {
        return !PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)plan).isEmpty();
    }

    @Override
    public List<PlanRepositoryDefinition> getRepositoryDefinitions(@NotNull ImmutablePlan plan) {
        return new ArrayList<PlanRepositoryDefinition>(PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)plan));
    }

    public List<WebRepositoryViewer> getWebRepositoryViewers() {
        return this.webRepositoryManager.getWebRepositoryViewers();
    }

    public Chain getMockBuildForView(Map<String, String[]> params) {
        String webKey = StringUtils.join((Object[])params.get("selectedWebRepositoryViewer"));
        WebRepositoryViewer webRepository = this.webRepositoryManager.getNewWebRepositoryViewerInstance(webKey);
        if (webRepository != null) {
            webRepository.populateFromParams((ActionParametersMap)new ActionParametersMapImpl(params));
            return new UpdateWebUrlBulkActionMockChain(webRepository);
        }
        return new DefaultChain();
    }

    private static class UpdateWebUrlBulkActionMockChain
    extends DefaultChain {
        private final List<RepositoryDefinition> repositoryDefinitions;

        private UpdateWebUrlBulkActionMockChain(WebRepositoryViewer webRepository) {
            this.repositoryDefinitions = Lists.newArrayList((Object[])new RepositoryDefinition[]{new UpdateWebUrlBulkActionMockRepositoryDefinitionImpl(webRepository)});
        }

        @NotNull
        public List<RepositoryDefinition> getEffectiveRepositoryDefinitions() {
            return this.repositoryDefinitions;
        }
    }

    private static class UpdateWebUrlBulkActionMockRepositoryDefinitionImpl
    extends LegacyRepositoryDefinitionImpl {
        private final transient WebRepositoryViewer webRepository;

        private UpdateWebUrlBulkActionMockRepositoryDefinitionImpl(WebRepositoryViewer webRepository) {
            super(0L, "", "", 0, "", "", false, false);
            this.webRepository = webRepository;
        }

        public WebRepositoryViewer getWebRepositoryViewer() {
            return this.webRepository;
        }
    }
}

