/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.bulk.repository;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.admin.bulk.BulkAction;
import com.atlassian.bamboo.ww2.actions.admin.bulk.repository.RepositoryAwareBulkAction;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRepositoryBulkAction
extends BambooActionSupport
implements RepositoryAwareBulkAction {
    @Override
    public boolean isApplicable(ImmutablePlan plan) {
        List repositories = this.getRepositoryDefinitions(plan);
        return !Iterables.isEmpty((Iterable)repositories);
    }

    @Override
    public boolean isApplicableForRepositories() {
        return true;
    }

    @Override
    public boolean hasUpdates() {
        return true;
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getResultAction() {
        return this.getViewAction();
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getExecuteAction() {
        return new BulkAction.WebWorkActionImpl("/chain/admin/config", "updateRepository");
    }

    @Override
    public void populateActionParameters(@NotNull ActionParametersMap actionParameters, @NotNull Plan plan) {
    }

    @Override
    public void populateActionParameters(@NotNull ActionParametersMap actionParameters, @NotNull Plan plan, @NotNull PlanRepositoryDefinition repositoryDefinition) {
        actionParameters.put((Object)"repositoryId", (Object)Long.toString(repositoryDefinition.getId()));
        actionParameters.put((Object)"repositoryName", (Object)repositoryDefinition.getName());
    }
}

