/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.bulk;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.LegacyRepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.admin.bulk.BulkAction;
import com.atlassian.bamboo.ww2.actions.admin.bulk.repository.RepositoryAwareBulkAction;
import com.atlassian.bamboo.ww2.aware.BypassValidationAware;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.HttpParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulkPlanAction
extends BambooActionSupport
implements GlobalAdminSecurityAware,
BypassValidationAware {
    private static final Logger log = Logger.getLogger(BulkPlanAction.class);
    private List<Project> projects;
    private String backButton;
    private String selectedBulkActionKey;
    private String[] selectedBuilds;
    private String[] selectedRepositories;
    private List<Plan> selectedPlans;
    private List<RepositoryDefinition> selectedRepositoryDefinitions;
    private Map<String, String[]> params;
    private final ListOrderedMap results = new ListOrderedMap();
    private List<BulkAction> availableBulkActions;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private ActionProxyFactory actionProxyFactory;
    private static AtomicBoolean wireOnce = new AtomicBoolean();

    @Override
    public boolean isValidationBypassed() {
        return this.backButton != null;
    }

    public void validate() {
        if (this.getSelectedPlans().isEmpty()) {
            this.addActionError(this.getText("bulkAction.selectNone"));
        } else {
            for (String selectedBuild : this.selectedBuilds) {
                Plan build = this.planManager.getPlanByKey(selectedBuild);
                if (build != null) continue;
                String[] args = new String[]{selectedBuild};
                this.addActionError(this.getText("builds.delete.error.NonExistantBuild", args));
            }
        }
    }

    public String view() throws Exception {
        if (this.isValidationBypassed()) {
            return "back";
        }
        if (this.getSelectedPlans().isEmpty()) {
            this.addActionError(this.getText("bulkAction.selectNone"));
            return "error";
        }
        return "view";
    }

    public String confirm() throws Exception {
        if (this.isValidationBypassed()) {
            return "back";
        }
        this.params = ActionParamsUtils.getStringArrayMap();
        return "confirm";
    }

    public String execute() throws Exception {
        if (this.isValidationBypassed()) {
            return "back";
        }
        BulkAction bulkAction = this.getBulkAction();
        if (!this.getSelectedPlans().isEmpty()) {
            for (Plan plan : this.selectedPlans) {
                RepositoryAwareBulkAction repositoryAction = (RepositoryAwareBulkAction)Narrow.reinterpret((Object)bulkAction, RepositoryAwareBulkAction.class);
                if (repositoryAction != null) {
                    for (PlanRepositoryDefinition repositoryDefinition : repositoryAction.getRepositoryDefinitions((ImmutablePlan)plan)) {
                        String returnCode = this.runBulkAction(plan.getKey(), repositoryDefinition, repositoryAction);
                        log.info((Object)("returnCode: " + returnCode + " for " + plan.getKey()));
                    }
                    continue;
                }
                String returnCode = this.runBulkAction(plan.getKey(), null, bulkAction);
                log.info((Object)("returnCode: " + returnCode + " for " + plan.getKey()));
            }
        } else {
            this.addActionError(this.getText("bulkAction.selectNone"));
            return "error";
        }
        return "success";
    }

    public boolean isApplicable(BulkAction bulkAction, Project project) {
        if (bulkAction != null && project != null) {
            for (TopLevelPlan plan : this.planManager.getPlansByProject(project)) {
                if (bulkAction.isApplicable((ImmutablePlan)plan)) {
                    return true;
                }
                for (Job job : plan.getAllJobs()) {
                    if (!bulkAction.isApplicable((ImmutablePlan)job)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isApplicableForRepositories(BulkAction bulkAction) {
        return bulkAction.isApplicableForRepositories();
    }

    public boolean isPlanSelected(String planKey) {
        return ArrayUtils.contains((Object[])this.selectedBuilds, (Object)planKey);
    }

    public boolean isRepositorySelected(long repositoryId) {
        return ArrayUtils.contains((Object[])this.selectedRepositories, (Object)Long.toString(repositoryId));
    }

    private String runBulkAction(@NotNull String planKey, @Nullable PlanRepositoryDefinition repositoryDefinition, @NotNull BulkAction bulkAction) throws Exception {
        RepositoryAwareBulkAction repositoryAwareBulkAction;
        Plan plan = this.planManager.getPlanByKey(planKey);
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        ValueStack stack = ActionContext.getContext().getValueStack();
        extraContext.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", stack);
        ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext());
        actionParametersMap.put("buildKey", planKey);
        if (plan != null) {
            bulkAction.populateActionParameters((ActionParametersMap)actionParametersMap, plan);
        }
        if ((repositoryAwareBulkAction = (RepositoryAwareBulkAction)Narrow.to((Object)bulkAction, RepositoryAwareBulkAction.class)) != null && repositoryDefinition != null) {
            repositoryAwareBulkAction.populateActionParameters((ActionParametersMap)actionParametersMap, plan, repositoryDefinition);
        }
        Map parameters = actionParametersMap.getParameters();
        extraContext.put("com.opensymphony.xwork2.ActionContext.parameters", HttpParameters.create((Map)parameters).build());
        extraContext.put("buildKey", planKey);
        BulkAction.WebWorkAction finalAction = bulkAction.getExecuteAction();
        ActionProxy proxy = this.actionProxyFactory.createActionProxy(finalAction.getNamespace(), finalAction.getActionName(), null, extraContext, false, true);
        String retrn = proxy.execute();
        this.results.put((Object)plan, proxy.getAction());
        stack.pop();
        return retrn;
    }

    public void setSelectedBuilds(String[] selectedBuilds) {
        this.selectedBuilds = selectedBuilds;
    }

    public String[] getSelectedBuilds() {
        return this.selectedBuilds;
    }

    public String[] getSelectedRepositories() {
        return this.selectedRepositories;
    }

    public void setSelectedRepositories(String[] selectedRepositories) {
        this.selectedRepositories = selectedRepositories;
    }

    @Nullable
    public BulkAction getBulkAction() {
        if (this.selectedBulkActionKey != null) {
            for (BulkAction availableBulkAction : this.availableBulkActions) {
                if (!availableBulkAction.getKey().equals(this.selectedBulkActionKey)) continue;
                return availableBulkAction;
            }
        }
        return null;
    }

    @Nullable
    public List<Plan> getSelectedPlans() {
        this.selectedPlans = new ArrayList<Plan>();
        if (this.selectedBuilds != null && this.selectedBuilds.length > 0) {
            for (String planKey : this.selectedBuilds) {
                this.selectedPlans.add(this.planManager.getPlanByKey(planKey));
            }
        }
        Collections.sort(this.selectedPlans, Comparators.getPlanNameProviderCaseInsensitiveOrdering());
        return this.selectedPlans;
    }

    @Nullable
    public List<RepositoryDefinition> getSelectedRepositoryDefinitions(Plan plan) {
        this.selectedRepositoryDefinitions = new ArrayList<RepositoryDefinition>();
        if (this.selectedRepositories != null && this.selectedRepositories.length > 0) {
            for (String selectedRepository : this.selectedRepositories) {
                PlanRepositoryLink planRepository = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, Long.parseLong(selectedRepository));
                if (planRepository == null) continue;
                this.selectedRepositoryDefinitions.add((RepositoryDefinition)new LegacyRepositoryDefinitionImpl(planRepository));
            }
        }
        return this.selectedRepositoryDefinitions;
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public List<Project> getSortedProjects() {
        if (this.projects == null) {
            this.projects = this.projectManager.getSortedProjects();
        }
        return this.projects;
    }

    public List<? extends Plan> getSortedPlans(Project project) {
        return Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.planManager.getPlansByProject(project));
    }

    public List<ImmutableTopLevelPlan> getSortedTopLevelPlans(Project project) {
        return this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class).stream().filter(PlanPredicates.withEqualProjectKey((Project)project)).sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList());
    }

    public String getSelectedBulkActionKey() {
        return this.selectedBulkActionKey;
    }

    public void setSelectedBulkActionKey(String selectedBulkActionKey) {
        this.selectedBulkActionKey = selectedBulkActionKey;
    }

    public List<BulkAction> getAvailableBulkActions() {
        return this.availableBulkActions;
    }

    public ListOrderedMap getResults() {
        return this.results;
    }

    public void setBackButton(String backButton) {
        this.backButton = backButton;
    }

    @Override
    public Object getSecuredDomainObject() {
        return GlobalApplicationSecureObject.INSTANCE;
    }

    public void setAvailableBulkActions(List<BulkAction> availableBulkActions) {
        this.availableBulkActions = availableBulkActions;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @Inject
    public void setActionProxyFactory(ActionProxyFactory actionProxyFactory) {
        this.actionProxyFactory = actionProxyFactory;
    }

    @Inject
    public void setContainer(Container container) {
        super.setContainer(container);
        if (wireOnce.compareAndSet(false, true)) {
            this.availableBulkActions.forEach(arg_0 -> ((Container)container).inject(arg_0));
        }
    }
}

