/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.bulk;

import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.ww2.actions.admin.bulk.AbstractNotificationBulkAction;
import com.atlassian.bamboo.ww2.actions.admin.bulk.BulkAction;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddNotificationBulkAction
extends AbstractNotificationBulkAction {
    private static final Logger log = Logger.getLogger(AddNotificationBulkAction.class);
    private final NotificationManager notificationManager;

    public AddNotificationBulkAction(@NotNull PlanManager planManager, @NotNull NotificationManager notificationManager) {
        this.planManager = planManager;
        this.notificationManager = notificationManager;
    }

    @Override
    @NotNull
    public String getKey() {
        return "bulk.action.notification.add";
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.getText("bulkAction.notification.title");
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getViewUpdatedAction() {
        return new BulkAction.WebWorkActionImpl("/build/admin", "viewUpdatedNotifications");
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getEditSnippetAction() {
        return new BulkAction.WebWorkActionImpl("/chain/admin/config", "editChainNotificationSnippet");
    }

    @Override
    @NotNull
    public BulkAction.WebWorkAction getExecuteAction() {
        return new BulkAction.WebWorkActionImpl("/chain/admin/config", "configureChainNotification");
    }

    @Nullable
    public NotificationRule getNewNotification(Map<String, String[]> params) {
        if (params.get("conditionKey") == null || params.get("notificationRecipientType") == null) {
            log.error((Object)"No new notification available - null conditionKey or notificationRecipientType");
            return null;
        }
        String conditionKey = params.get("conditionKey")[0];
        String notificationRecipientType = params.get("notificationRecipientType")[0];
        try {
            return this.notificationManager.createNotificationRuleFromAction(conditionKey, notificationRecipientType, params);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

