/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.PaginationAware;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ViewAuthors
extends BambooActionSupport
implements GlobalAdminSecurityAware,
PaginationAware<Author> {
    private static final Logger log = Logger.getLogger(ViewAuthors.class);
    private static final String AUTHOR_NAME = "Author Name";
    private static final String LINKED_USER_NAME = "Linked User Name";
    private Pager<Author> pager;
    private List<Author> authors;
    private List<String> searchOptions = Lists.newArrayList((Object[])new String[]{"Author Name", "Linked User Name"});
    private String searchOption;
    private String searchString;
    private ExtendedAuthorManager extendedAuthorManager;

    @Override
    public Pager<Author> getPager() {
        return this.pager;
    }

    @Override
    public void setPager(Pager<Author> pager) {
        this.pager = pager;
    }

    @Override
    public List getResultsList() {
        if (this.authors == null) {
            this.authors = StringUtils.isNotBlank((CharSequence)this.searchString) ? (LINKED_USER_NAME.equals(this.searchOption) ? new ArrayList<Author>(this.extendedAuthorManager.findAuthorsByUser(this.searchString.trim().toLowerCase())) : new ArrayList<Author>(this.extendedAuthorManager.findAuthorsByName(this.searchString.trim().toLowerCase()))) : new ArrayList<Author>(this.extendedAuthorManager.getAllAuthors());
        }
        Collections.sort(this.authors, Comparators.getNameProviderCaseInsensitiveOrdering());
        return this.authors;
    }

    public String getSearchOption() {
        return this.searchOption;
    }

    public void setSearchOption(String searchOption) {
        this.searchOption = searchOption;
    }

    public List<String> getSearchOptions() {
        return this.searchOptions;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }
}

