/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.author;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AdministerAuthors
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(AdministerAuthors.class);
    private ExtendedAuthorManager extendedAuthorManager;
    private long authorId;
    private String userName;

    public String linkUser() {
        if (StringUtils.isNotBlank((CharSequence)this.userName)) {
            BambooUser bambooUser = this.bambooUserManager.getBambooUser(this.userName);
            if (bambooUser != null) {
                if (this.authorId > 0L) {
                    ExtendedAuthor authorById = this.extendedAuthorManager.getAuthorById(this.authorId);
                    if (authorById != null) {
                        authorById.setLinkedUserName(this.userName);
                        this.extendedAuthorManager.saveAuthor(authorById);
                        return "success";
                    }
                    this.addActionError("Failed to unlink user, no author found");
                } else {
                    this.addActionError("Failed to unlink user, no author found");
                }
            } else {
                this.addFieldError("userName", "Please enter a user name");
            }
        } else {
            this.addFieldError("userName", "Please enter a user name");
        }
        return "error";
    }

    public String unlinkUser() {
        ExtendedAuthor authorById;
        if (this.authorId > 0L && (authorById = this.extendedAuthorManager.getAuthorById(this.authorId)) != null) {
            authorById.setLinkedUserName(null);
            this.extendedAuthorManager.saveAuthor(authorById);
            return "success";
        }
        this.addActionError("Failed to unlink user, no author found");
        return "error";
    }

    public String unlinkAll() {
        this.extendedAuthorManager.unlinkAllAuthors();
        return "success";
    }

    public String relinkAll() {
        this.extendedAuthorManager.relinkUnlinkedAuthors();
        return "success";
    }

    public long getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(long authorId) {
        this.authorId = authorId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }
}

