/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.event.spi.BambooSingletonUnboundedEventExecutorFactory;
import com.atlassian.bamboo.event.spi.EventLoggingThreadPoolExecutor;
import com.atlassian.bamboo.event.spi.EventStats;
import com.atlassian.bamboo.event.spi.ExecutorStats;
import com.atlassian.bamboo.event.spi.ExecutorStatsImpl;
import com.atlassian.bamboo.plan.NonBlockingPlanExecutionService;
import com.atlassian.bamboo.plan.cache.BambooCacheStats;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.impl.matchers.GroupMatcher;

public class ViewBambooInternals
extends GlobalAdminAction {
    private ExecutorStats eventExecutorStats;
    private ExecutorStats planExecutorStats;
    private final Multimap<String, JobDetail> jobDetailMultimap = TreeMultimap.create((Comparator)String.CASE_INSENSITIVE_ORDER, Comparator.comparing(ViewBambooInternals::getJobFullName, String.CASE_INSENSITIVE_ORDER));
    private Scheduler scheduler;
    private BambooSingletonUnboundedEventExecutorFactory eventExecutorFactory;
    private EventStats eventStats;
    private BambooCacheStats planCacheStats;
    private HibernateMutableAclService aclService;
    private BambooCacheStats aclCacheStats;
    private NonBlockingPlanExecutionService nonBlockingPlanExecutionService;
    private ImmutablePlanCacheService immutablePlanCacheService;

    public String execute() throws Exception {
        this.planCacheStats = this.immutablePlanCacheService.getCacheStats();
        this.aclCacheStats = this.aclService.getCacheStats();
        EventLoggingThreadPoolExecutor executor = this.eventExecutorFactory.getExecutor();
        this.eventExecutorStats = new ExecutorStatsImpl(executor);
        List jobGroupNames = this.scheduler.getJobGroupNames();
        for (String jobGroupName : jobGroupNames) {
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)jobGroupName));
            for (JobKey jobKey : jobKeys) {
                JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                this.jobDetailMultimap.put((Object)jobGroupName, (Object)jobDetail);
            }
        }
        this.planExecutorStats = this.nonBlockingPlanExecutionService.getExecutorStats();
        return "success";
    }

    private static String getJobFullName(JobDetail jobDetail) {
        JobKey key = jobDetail.getKey();
        return key.getGroup() + "." + key.getName();
    }

    public Multimap<String, JobDetail> getJobDetailMultimap() {
        return this.jobDetailMultimap;
    }

    public ExecutorStats getEventExecutorStats() {
        return this.eventExecutorStats;
    }

    public BambooCacheStats getPlanCacheStats() {
        return this.planCacheStats;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setEventExecutorFactory(BambooSingletonUnboundedEventExecutorFactory eventExecutorFactory) {
        this.eventExecutorFactory = eventExecutorFactory;
    }

    public EventStats getEventStats() {
        return this.eventStats;
    }

    public void setEventStats(EventStats eventStats) {
        this.eventStats = eventStats;
    }

    public void setAclService(HibernateMutableAclService aclService) {
        this.aclService = aclService;
    }

    public BambooCacheStats getAclCacheStats() {
        return this.aclCacheStats;
    }

    public ExecutorStats getPlanExecutorStats() {
        return this.planExecutorStats;
    }

    public void setNonBlockingPlanExecutionService(NonBlockingPlanExecutionService nonBlockingPlanExecutionService) {
        this.nonBlockingPlanExecutionService = nonBlockingPlanExecutionService;
    }

    public void setImmutablePlanCacheService(ImmutablePlanCacheService immutablePlanCacheService) {
        this.immutablePlanCacheService = immutablePlanCacheService;
    }
}

