/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.build.BuildSuspensionCheckBean;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.web.utils.JohnsonEventContainerHolder;
import com.atlassian.bamboo.ww2.actions.setup.AbstractSetupAction;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.XmlJohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.Nullable;

public class UpdateLicenseAction
extends AbstractSetupAction
implements GlobalBypassSecurityAware {
    public static final long ALMOST_EXPIRED_PERIOD = 42L;
    private String licenseString;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    private BambooLicenseManager bambooLicenseManager;
    @Nullable
    private BuildSuspensionCheckBean buildSuspensionCheckBean;

    public BambooLicense getLicense() {
        return this.getBambooLicenseManager().getLicense();
    }

    public String getSid() {
        return this.getBootstrapManager().getServerID();
    }

    public Date getSupportPeriodEnd() {
        return this.getLicense().getMaintenanceExpiryDate();
    }

    public boolean isSupportPeriodExpired() {
        return this.getLicense().isMaintenanceExpired();
    }

    public boolean isSupportPeriodAlmostExpired() {
        return (long)this.getLicense().getNumberOfDaysBeforeMaintenanceExpiry() <= 42L;
    }

    public boolean isOldLicenseWithNewInstall() {
        return this.getBambooLicenseManager().isMaintenanceExpiredForBuild();
    }

    public boolean isCommercialLicense() {
        return this.getBambooLicenseManager().isCommercial();
    }

    public boolean isAcademicLicense() {
        return this.getBambooLicenseManager().isAcademic();
    }

    public boolean isOpenSourceLicense() {
        return this.getBambooLicenseManager().isOpenSource();
    }

    public boolean isEvaluationLicense() {
        return this.getBambooLicenseManager().isEvaluation();
    }

    public int getAllowedNumberOfRemoteAgents() {
        return this.getBambooLicenseManager().getAllowedNumberOfRemoteAgents();
    }

    public int getAllowedNumberOfLocalAgents() {
        return this.getBambooLicenseManager().getAllowedNumberOfLocalAgents();
    }

    public int getAllowedNumberOfPlans() {
        return this.getBambooLicenseManager().getAllowedNumberOfPlans();
    }

    public boolean isDataCenter() {
        return Optional.ofNullable(this.getBambooLicenseManager().getLicense()).map(ProductLicense::isClusteringEnabled).orElse(false);
    }

    @Nullable
    public String getSupportEntitlementNumber() {
        BambooLicense license = this.getLicense();
        if (license != null) {
            return license.getSupportEntitlementNumber();
        }
        return null;
    }

    public String getVersionInfo() {
        return BuildUtils.getCurrentVersion() + "#" + BuildUtils.getCurrentBuildNumber();
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.licenseString)) {
            this.addFieldError("licenseString", this.getText("license.error.required"));
        } else if (!this.getBambooLicenseManager().authenticateLicense(this.licenseString)) {
            this.addFieldError("licenseString", this.getText("license.error.invalid"));
        } else if (this.planManager != null) {
            int currentPlans = this.planManager.getPlanCount();
            int allowedPlans = this.getBambooLicenseManager().getAllowedNumberOfPlans(this.licenseString);
            if (-1 != allowedPlans && currentPlans > allowedPlans) {
                this.addActionError(this.getText("license.error.tooManyPlans", Lists.newArrayList((Object[])new Integer[]{currentPlans, allowedPlans, currentPlans - allowedPlans})));
            }
        }
    }

    public String execute() throws Exception {
        this.getBambooLicenseManager().setLicense(this.licenseString);
        if (this.elasticFunctionalityFacade != null) {
            this.elasticFunctionalityFacade.recheckElasticSupportEnabledFlag();
        }
        this.addActionMessage(this.getText("license.updated"));
        JohnsonEventContainer agentJohnson = JohnsonEventContainerHolder.get((ServletContext)ServletActionContext.getServletContext());
        if (agentJohnson.hasEvents()) {
            Collection errors = agentJohnson.getEvents();
            for (Object error : errors) {
                Event event = (Event)error;
                if (!"license-too-old".equals(event.getKey().getType())) continue;
                XmlJohnsonConfig johnsonConfig = XmlJohnsonConfig.fromFile((String)"johnson-config.xml");
                agentJohnson.removeEvent(event);
                agentJohnson.addEvent(new Event(johnsonConfig.getEventType("restart"), "Bamboo has successfully updated your license.  Please restart Bamboo", johnsonConfig.getEventLevel("fatal")));
                break;
            }
        }
        if (this.buildSuspensionCheckBean != null) {
            this.buildSuspensionCheckBean.isSuspended();
        }
        return "success";
    }

    @Override
    public BambooLicenseManager getBambooLicenseManager() {
        if (this.bambooLicenseManager == null) {
            this.bambooLicenseManager = (BambooLicenseManager)BootstrapUtils.getBootstrapContext().getBean("bambooLicenseManager");
        }
        return this.bambooLicenseManager;
    }

    @Override
    public void setBambooLicenseManager(BambooLicenseManager bambooLicenseManager) {
        this.bambooLicenseManager = bambooLicenseManager;
    }

    public void setBuildSuspensionCheckBean(@Nullable BuildSuspensionCheckBean buildSuspensionCheckBean) {
        this.buildSuspensionCheckBean = buildSuspensionCheckBean;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getVersion() {
        return BuildUtils.getCurrentVersion();
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }
}

