/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.notification.EmailValidator;
import com.atlassian.bamboo.repository.CacheHandler;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.svn.SvnWcFormat;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork2.Preparable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RepositorySettingsAction
extends BambooActionSupport
implements GlobalAdminSecurityAware,
Preparable {
    private static final Logger log = Logger.getLogger(RepositorySettingsAction.class);
    static final List<String> validFormats = ImmutableList.of((Object)SvnWcFormat.WC_1_5.getSvnVersion(), (Object)SvnWcFormat.WC_1_6.getSvnVersion(), (Object)SvnWcFormat.WC_1_7.getSvnVersion(), (Object)SvnWcFormat.WC_1_8.getSvnVersion());
    private PluginAccessor pluginAccessor;
    private final Map<String, CacheHandler> cacheDescriptionProviderMap = new HashMap<String, CacheHandler>();
    private String providerId;
    private Collection<String> selectedCaches = Collections.emptyList();
    private boolean deleteUnusedButtonPressed;
    private boolean deleteSelectedButtonPressed;
    private boolean singleCacheSelected;
    private String userName;
    private String email;
    private String commitMessage;
    private String subversionWorkingCopyFormat;
    private boolean useNtlmAuth;

    public void prepare() throws Exception {
        List cacheHandlers = this.pluginAccessor.getEnabledModulesByClass(CacheHandler.class);
        for (CacheHandler cacheHandler : cacheHandlers) {
            String key = cacheHandler.getKey();
            this.cacheDescriptionProviderMap.put(key, cacheHandler);
        }
        if (this.cacheDescriptionProviderMap.isEmpty()) {
            this.addActionMessage(this.getText("manageCaches.noneFound"));
        }
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
        this.userName = repositorySettings.getAuthorName();
        this.email = repositorySettings.getAuthorEmail();
        this.commitMessage = repositorySettings.getIntegrationCommitMessage();
        this.subversionWorkingCopyFormat = repositorySettings.getSubversionWorkingCopyFormat();
    }

    public String input() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
        this.useNtlmAuth = repositorySettings.isUseNtlmAuth();
        return "input";
    }

    public String doDelete() throws Exception {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot delete caches");
        CacheHandler provider = this.cacheDescriptionProviderMap.get(this.providerId);
        if (provider == null) {
            this.addActionError(this.getText("manageCaches.providerNotFound", Collections.singletonList(this.providerId)));
            return "input";
        }
        if (this.deleteUnusedButtonPressed) {
            provider.deleteUnusedCaches((ValidationAware)this);
        } else if (this.deleteSelectedButtonPressed || this.singleCacheSelected) {
            for (String selectedCache : this.selectedCaches) {
                Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((CharSequence)selectedCache), (Object)"directory traversal blocked");
            }
            provider.deleteCaches(this.selectedCaches, (ValidationAware)this);
        }
        return "success";
    }

    public Collection<CacheHandler> getCacheProviders() {
        return this.cacheDescriptionProviderMap.values();
    }

    @Override
    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public void setSelectedCaches(Collection<String> selectedCaches) {
        this.selectedCaches = selectedCaches;
    }

    public void setDeleteUnusedButton(String value) {
        this.deleteUnusedButtonPressed = true;
    }

    public void setDeleteSelectedButton(String value) {
        this.deleteSelectedButtonPressed = true;
    }

    public void setSingleCacheSelected(boolean singleCacheSelected) {
        this.singleCacheSelected = singleCacheSelected;
    }

    public String doUpdateAutomaticCommits() {
        if (EmailValidator.isValidEmailAddressFormat((String)this.email)) {
            AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
            RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
            repositorySettings.setAuthorEmail(this.email);
            repositorySettings.setAuthorName(this.userName);
            repositorySettings.setIntegrationCommitMessage(this.commitMessage);
            this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
            return "success";
        }
        this.addFieldError("email", this.getText("user.email.error.invalid"));
        return "input";
    }

    public String doUpdateSubversionPreferences() {
        if (validFormats.contains(this.subversionWorkingCopyFormat)) {
            AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
            RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
            repositorySettings.setSubversionWorkingCopyFormat(this.subversionWorkingCopyFormat);
            repositorySettings.setUseNtlmAuth(this.useNtlmAuth);
            this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
            return "success";
        }
        this.addFieldError("subversionWorkingCopyFormat", "Invalid format. Please use one of " + validFormats.toString() + ".");
        return "input";
    }

    public List<NameValuePair> getValidSubversionWorkingCopyFormats() {
        return validFormats.stream().map(format -> new NameValuePair(format, format)).collect(Collectors.toList());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getSubversionWorkingCopyFormat() {
        return this.subversionWorkingCopyFormat;
    }

    public void setSubversionWorkingCopyFormat(String subversionWorkingCopyFormat) {
        this.subversionWorkingCopyFormat = subversionWorkingCopyFormat;
    }

    public boolean isUseNtlmAuth() {
        return this.useNtlmAuth;
    }

    public void setUseNtlmAuth(boolean useNtlmAuth) {
        this.useNtlmAuth = useNtlmAuth;
    }
}

