/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.build.test.QuarantineConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.task.QuarantineExpiryCleanupScheduler;
import com.atlassian.bamboo.utils.CronUtils;
import com.atlassian.struts.Preparable;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Logger;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class QuarantineSettingsAction
extends GlobalAdminAction
implements Preparable {
    private static final Logger log = Logger.getLogger(QuarantineSettingsAction.class);
    public static final PeriodFormatter PERIOD_FORMATTER = PeriodFormat.getDefault();
    private QuarantineConfiguration quarantineConfiguration;
    private boolean enabled;
    private int expiryDuration;
    private String expiryPeriod;
    private boolean expiryOverridable;
    private String cronExpression;
    private QuarantineExpiryCleanupScheduler quarantineExpiryCleanupScheduler;

    public void prepare() throws Exception {
        this.quarantineConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration().getQuarantineConfiguration();
    }

    public void validate() {
        if (this.enabled && this.featureManager.isLimitedTimeQuarantineEnabled()) {
            if (this.expiryDuration <= 0) {
                this.addFieldError("expiryDuration", this.getText("admin.quarantineSettings.expiryDuration.error.negative"));
            }
            if (!("days".equals(this.expiryPeriod) || "weeks".equals(this.expiryPeriod) || "months".equals(this.expiryPeriod))) {
                this.addFieldError("expiryDuration", this.getText("admin.quarantineSettings.expiryDuration.error.invalid", Collections.singletonList(this.expiryPeriod)));
            }
            CronUtils.getCronExpressionValidationError((String)this.cronExpression).ifPresent(error -> this.addFieldError("cronExpression", (String)error));
        }
    }

    public String input() throws Exception {
        this.enabled = this.quarantineConfiguration.isEnabled();
        if (this.featureManager.isLimitedTimeQuarantineEnabled()) {
            this.expiryOverridable = this.quarantineConfiguration.isExpiryOverridable();
            this.cronExpression = this.quarantineConfiguration.getCronExpression();
            Period period = (Period)ObjectUtils.defaultIfNull((Object)this.quarantineConfiguration.getExpiryPeriod(), (Object)QuarantineConfiguration.DEFAULT_EXPIRY_PERIOD);
            if (period.getMonths() != 0) {
                this.expiryDuration = period.getMonths();
                this.expiryPeriod = "months";
            } else if (period.getWeeks() != 0) {
                this.expiryDuration = period.getWeeks();
                this.expiryPeriod = "weeks";
            } else if (period.getDays() != 0) {
                this.expiryDuration = period.getDays();
                this.expiryPeriod = "days";
            } else {
                log.warn((Object)("Invalid quarantine expiry period found in configuration: " + PERIOD_FORMATTER.print((ReadablePeriod)period)));
                this.expiryDuration = 0;
                this.expiryPeriod = "days";
            }
        }
        return "input";
    }

    public String execute() throws Exception {
        this.quarantineConfiguration.setEnabled(this.enabled);
        if (this.featureManager.isLimitedTimeQuarantineEnabled()) {
            this.quarantineConfiguration.setExpiryOverridable(this.expiryOverridable);
            this.quarantineConfiguration.setExpiryPeriod(PERIOD_FORMATTER.parsePeriod(this.expiryDuration + " " + this.expiryPeriod));
            this.quarantineConfiguration.setCronExpression(this.cronExpression);
        }
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        administrationConfiguration.setQuarantineConfiguration(this.quarantineConfiguration);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        log.info((Object)("Quarantine settings updated: " + this.quarantineConfiguration));
        if (this.featureManager.isLimitedTimeQuarantineEnabled()) {
            this.quarantineExpiryCleanupScheduler.initialiseSchedule();
            log.info((Object)"Quarantine expiry schedule re-initialized");
        }
        return "success";
    }

    public void setQuarantineExpiryCleanupScheduler(QuarantineExpiryCleanupScheduler quarantineExpiryCleanupScheduler) {
        this.quarantineExpiryCleanupScheduler = quarantineExpiryCleanupScheduler;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getExpiryDuration() {
        return this.expiryDuration;
    }

    public void setExpiryDuration(int expiryDuration) {
        this.expiryDuration = expiryDuration;
    }

    public String getExpiryPeriod() {
        return this.expiryPeriod;
    }

    public void setExpiryPeriod(String expiryPeriod) {
        this.expiryPeriod = expiryPeriod;
    }

    public boolean isExpiryOverridable() {
        return this.expiryOverridable;
    }

    public void setExpiryOverridable(boolean expiryOverridable) {
        this.expiryOverridable = expiryOverridable;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }
}

