/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.creation.JobCreationConstants;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.JobParamMapHelper;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.collections.SimpleActionParametersMap;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingStrategy;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.admin.ImportMavenPlanAction;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupportImpl;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.ActionContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportMavenPlanCreatePlanAction
extends ImportMavenPlanAction {
    private static final Logger log = Logger.getLogger(ImportMavenPlanCreatePlanAction.class);
    private static final String TMP_CREATE_AS_ENABLED_PROPERTY = "tmp.createAsEnabled";
    private static final String TMP_MAVEN_CAPABILITY_KEY = "tmp.mavenExecutable";
    private static final String KEY_MAVEN_TASK_PREFIX = "com.atlassian.bamboo.plugins.maven:task.builder.";
    private static final String MAVEN_CFG_GOAL = "goal";
    private static final String MAVEN_DEFAULT_GOALS = "clean test";
    private static final long TASK_ID = 1L;
    private static final String POLLING_TRIGGER_PLUGIN_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll";
    private PlanKey jobKey;
    private String repositoryName;
    private JobCreationService jobCreationService;
    private TriggerTypeManager triggerTypeManager;
    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> viewerTypeSelectors;
    private String selectedWebRepositoryViewer = VcsViewerUIConfigBean.NO_VIEWER.getKey();
    @Autowired
    protected VcsConfigurationHelper vcsConfigurationHelper;

    @Override
    public void validate() {
        super.validate();
        this.chainCreationService.validateChainDetails((com.opensymphony.xwork.ValidationAware)this, (ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()));
        this.vcsConfigurationHelper.validateSharedRepositoryName(this.repositoryName, (ValidationAware)this);
        if (this.hasErrors()) {
            this.initVcsTypeSelectors(TaskRenderMode.ERROR);
        }
    }

    @Override
    protected void initVcsTypeSelectors(@NotNull TaskRenderMode renderMode) {
        PartialVcsRepositoryData existingData = this.getBambooSession().getVcsRepositoryData();
        String repositoryKey = this.getBuildConfiguration().getString("selectedRepository");
        List vcsRepositoryModuleDescriptors = this.vcsRepositoryManager.getAvailableRepositoryDescriptors();
        this.vcsTypeSelectors = vcsRepositoryModuleDescriptors.stream().map(input -> {
            if (existingData.getPluginKey().equals(input.getCompleteKey())) {
                return new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryModuleDescriptor)input, this.vcsUIConfigBean.prepareEditHtmlFragments((VcsRepositoryModuleDescriptor)input, existingData, input.getCompleteKey().equals(repositoryKey) ? renderMode : TaskRenderMode.SUCCESS, null));
            }
            return new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryModuleDescriptor)input, this.vcsUIConfigBean.prepareCreateHtmlFragments((VcsRepositoryModuleDescriptor)input, input.getCompleteKey().equals(repositoryKey) ? renderMode : TaskRenderMode.SUCCESS, null));
        }).collect(Collectors.toList());
        this.viewerTypeSelectors = this.vcsViewerUIConfigBean.getViewerOptionsForRepositoryType(repositoryKey, existingData.getViewerConfiguration(), renderMode);
    }

    public String input() throws Exception {
        this.initVcsTypeSelectors(TaskRenderMode.SUCCESS);
        if (this.getBambooSession().getVcsRepositoryData().getViewerConfiguration() != null) {
            this.selectedWebRepositoryViewer = this.getBambooSession().getVcsRepositoryData().getViewerConfiguration().getPluginKey();
        }
        if (this.planLimitReached) {
            this.planLimitReached = false;
            return "planCreationDeniedError";
        }
        return "input";
    }

    public String execute() throws Exception {
        if (this.planLimitReached) {
            this.planLimitReached = false;
            return "planCreationDeniedError";
        }
        PlanCreationService.EnablePlan enablePlan = this.getBuildConfiguration().getBoolean(TMP_CREATE_AS_ENABLED_PROPERTY, false) ? PlanCreationService.EnablePlan.ENABLED : PlanCreationService.EnablePlan.DISABLED;
        BuildConfiguration chainBuildConfiguration = new BuildConfiguration(this.getBuildConfiguration().asXml());
        if (!this.createRepository(chainBuildConfiguration)) {
            this.initVcsTypeSelectors(TaskRenderMode.ERROR);
            return "error";
        }
        ImmutableList<TriggerDefinition> triggerDefinitions = this.createPollingTrigger();
        TriggerConfigurationUtils.addTriggerDefinitionsToConfig(triggerDefinitions, (HierarchicalConfiguration)chainBuildConfiguration.getProjectConfig());
        this.buildConfiguration.setProperty("custom.dependencies.trigger.remote.strategy", (Object)DependencyBlockingStrategy.BuildParentIfChangesDetected.getValue());
        chainBuildConfiguration.setProperty("custom.dependency.automaticManagement.enabled", (Object)true);
        chainBuildConfiguration.setProperty("custom.dependency.automaticManagement.providerJobKey", (Object)"JOB1");
        String chainKey = this.chainCreationService.createPlan(chainBuildConfiguration, (ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext()), enablePlan);
        BuildConfiguration jobBuildConfiguration = new BuildConfiguration(this.getBuildConfiguration().asXml());
        this.addMavenTaskToConfiguration(jobBuildConfiguration);
        ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(new HashMap());
        JobParamMapHelper.setBuildKey((ActionParametersMap)actionParametersMap, (String)chainKey);
        JobParamMapHelper.setBuildName((ActionParametersMap)actionParametersMap, (String)"Default Job");
        JobParamMapHelper.setSubBuildKey((ActionParametersMap)actionParametersMap, (String)"JOB1");
        JobParamMapHelper.setStageName((ActionParametersMap)actionParametersMap, (String)"Default Stage");
        JobParamMapHelper.setExistingStage((ActionParametersMap)actionParametersMap, (String)JobCreationConstants.NEW_STAGE_MARKER);
        this.jobKey = (PlanKey)Iterables.getOnlyElement((Iterable)this.jobCreationService.createJobAndBranches(jobBuildConfiguration, (ActionParametersMap)actionParametersMap, PlanCreationService.EnablePlan.ENABLED));
        this.jobCreationService.triggerCreationCompleteEvents(this.jobKey);
        Job job = (Job)this.planManager.getPlanByKey(this.jobKey, Job.class);
        if (job != null) {
            List tasks = job.getBuildDefinition().getTaskDefinitions();
            for (TaskDefinition task : tasks) {
                this.taskManager.calculateRequirementsForTaskDefinition(job, task);
                this.buildDefinitionManager.savePlanAndDefinition((Plan)job, job.getBuildDefinition());
            }
        }
        if (!this.getNotificationSet().getNotificationRules().isEmpty()) {
            Chain chain = (Chain)this.planManager.getPlanByKey(chainKey, Chain.class);
            if (chain == null) {
                throw new IllegalStateException("We just created a plan but can't find it in the database");
            }
            for (NotificationRule rule : this.getNotificationSet().getNotificationRules()) {
                chain.getNotificationSet().addNotification(rule);
            }
            this.planManager.savePlan((Plan)chain);
        }
        this.getBambooSession().setPlan(null);
        this.getBambooSession().setBuildConfiguration(null);
        this.chainCreationService.triggerCreationCompleteEvents(PlanKeys.getPlanKey((String)chainKey));
        return "success";
    }

    private boolean createRepository(BuildConfiguration chainBuildConfiguration) {
        long repositoryId;
        String repositoryKey = this.buildConfiguration.getString("selectedRepository");
        if (this.vcsConfigurationHelper.currentUserHasPermissionToCreateSharedRepository()) {
            VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryKey);
            String userDescription = "";
            VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
            boolean createPlan = true;
            PartialVcsRepositoryData dataFromSession = this.getBambooSession().getVcsRepositoryData();
            PartialVcsRepositoryData existingData = repositoryKey.equals(dataFromSession.getPluginKey()) ? dataFromSession : null;
            PartialVcsRepositoryData newRepositoryData = (PartialVcsRepositoryData)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(vcsRepositoryModuleDescriptor, this.repositoryName, "", existingData, createPlan, VcsConfigurationHelper.OVERRIDE_ALL));
            try {
                VcsRepositoryConfigurationService.LinkedRepositoryAccess repositoryAccess = VcsRepositoryConfigurationService.LinkedRepositoryAccess.valueOf((String)this.buildConfiguration.getString("linkedRepositoryAccessOption", VcsRepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS.name()));
                PartialVcsRepositoryData linkedRepository = this.vcsRepositoryConfigurationService.createLinkedRepository(newRepositoryData, this.getUser(), repositoryAccess);
                repositoryId = linkedRepository.getId();
            }
            catch (Exception e) {
                this.addActionError(e);
                return false;
            }
        } else {
            this.addActionError(this.getText("plan.create.repository.no.permission"));
            return false;
        }
        chainBuildConfiguration.setProperty("selectedRepository", (Object)Long.toString(repositoryId));
        return true;
    }

    private ImmutableList<TriggerDefinition> createPollingTrigger() {
        TriggerModuleDescriptor pollingTriggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(POLLING_TRIGGER_PLUGIN_KEY);
        if (pollingTriggerDescriptor != null) {
            TriggerConfigurator pollingTriggerConfigurator = pollingTriggerDescriptor.getTriggerConfigurator();
            HashMap fakeContext = new HashMap();
            pollingTriggerConfigurator.populateContextForCreate(fakeContext);
            Map cfgMap = pollingTriggerConfigurator.generateTriggerConfigMap((ActionParametersMap)new SimpleActionParametersMap(fakeContext), null);
            HashSet triggeringRepositories = new HashSet();
            return ImmutableList.of((Object)new TriggerDefinitionImpl.Builder().fromDescriptor(pollingTriggerDescriptor).id(1L).triggeringRepositories(triggeringRepositories).configuration(cfgMap).build());
        }
        return ImmutableList.of();
    }

    public Collection<Project> getExistingProjects() {
        return Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.projectManager.getProjects());
    }

    public NotificationSet getNotificationSet() {
        TopLevelPlan build;
        Plan plan = this.getBambooSession().getPlan();
        if (plan != null && (build = (TopLevelPlan)Narrow.downTo((Object)plan, TopLevelPlan.class)) != null) {
            return build.getNotificationSet();
        }
        return new NotificationSetImpl();
    }

    private void addMavenTaskToConfiguration(BuildConfiguration buildConfiguration) {
        String mavenCapabilityKey = buildConfiguration.getString(TMP_MAVEN_CAPABILITY_KEY);
        String mavenType = UIConfigSupportImpl.capabilityKeyToExecutableType(mavenCapabilityKey);
        String mavenTaskId = KEY_MAVEN_TASK_PREFIX + mavenType;
        TaskDefinitionImpl mavenTask = new TaskDefinitionImpl(1L, mavenTaskId, "", true, new HashMap());
        mavenTask.getConfiguration().put("label", UIConfigSupportImpl.capabilityKeyToExecutableLabel(mavenCapabilityKey));
        mavenTask.getConfiguration().put("buildJdk", this.uiConfigBean.getDefaultJdkLabel());
        mavenTask.getConfiguration().put(MAVEN_CFG_GOAL, MAVEN_DEFAULT_GOALS);
        mavenTask.getConfiguration().put("testChecked", Boolean.TRUE.toString());
        mavenTask.getConfiguration().put("testDirectoryOption", "standardTestDirectory");
        XMLConfiguration config = buildConfiguration.getProjectConfig();
        TaskConfigurationUtils.addTaskDefinitionsToConfig((List)Lists.newArrayList((Object[])new TaskDefinition[]{mavenTask}), (HierarchicalConfiguration)config, (String)"buildTasks.");
    }

    public void setJobCreationService(JobCreationService jobCreationService) {
        this.jobCreationService = jobCreationService;
    }

    public void setTriggerTypeManager(TriggerTypeManager triggerTypeManager) {
        this.triggerTypeManager = triggerTypeManager;
    }

    public String getJobKey() {
        return this.jobKey.getKey();
    }

    public long getTaskId() {
        return 1L;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public int getRepositoryNameMaxLength() {
        return 255;
    }

    public String getSelectedWebRepositoryViewer() {
        return this.selectedWebRepositoryViewer;
    }

    public void setSelectedWebRepositoryViewer(String selectedWebRepositoryViewer) {
        this.selectedWebRepositoryViewer = selectedWebRepositoryViewer;
    }

    public List<VcsViewerUIConfigBean.VcsViewerTypeSelector> getViewerSelectors() {
        return this.viewerTypeSelectors;
    }
}

