/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.maven.embedder.MavenConfiguration;
import com.atlassian.bamboo.maven.embedder.MavenEmbedderException;
import com.atlassian.bamboo.maven.embedder.MavenEmbedderService;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.chain.AllChainNotificationType;
import com.atlassian.bamboo.notification.chain.ChainFailedAndFirstFixedNotificationType;
import com.atlassian.bamboo.notification.recipients.EmailRecipient;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.NoContextVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.admin.ImportMavenPlanAction;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.project.ProjectBuildingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportMavenPlanCheckoutPomAction
extends ImportMavenPlanAction
implements Preparable {
    private static final Logger log = Logger.getLogger(ImportMavenPlanCheckoutPomAction.class);
    @Autowired
    private MavenEmbedderService mavenEmbedderService;
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private VcsConfigurationHelper vcsConfigurationHelper;
    private String mavenPath;

    @Override
    public void prepare() throws Exception {
        super.prepare();
    }

    @Override
    public void validate() {
        super.validate();
        if (StringUtils.isNotBlank((CharSequence)this.mavenPath) && this.mavenPath.contains("..")) {
            this.addFieldError("mavenPath", this.getText("repository.git.messages.invalidPomPath"));
        }
    }

    @Override
    protected void initVcsTypeSelectors(@NotNull TaskRenderMode renderMode) {
        String repositoryKey = this.getBuildConfiguration().getString("selectedRepository");
        List vcsRepositoryModuleDescriptors = this.vcsRepositoryManager.getAvailableRepositoryDescriptors();
        this.vcsTypeSelectors = vcsRepositoryModuleDescriptors.stream().filter(VcsRepositoryModuleDescriptor::supportsImportFromMaven).map(input -> new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryModuleDescriptor)input, this.vcsUIConfigBean.prepareMavenImportHtmlFragments((VcsRepositoryModuleDescriptor)input, input.getCompleteKey().equals(repositoryKey) ? renderMode : TaskRenderMode.SUCCESS, null))).collect(Collectors.toList());
    }

    public String input() throws Exception {
        if (this.planLimitReached) {
            this.planLimitReached = false;
            return "planCreationDeniedError";
        }
        this.initVcsTypeSelectors(TaskRenderMode.SUCCESS);
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (this.planLimitReached) {
            this.planLimitReached = false;
            return "planCreationDeniedError";
        }
        VcsRepositoryModuleDescriptor repositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.getSelectedRepositoryKey());
        Preconditions.checkState((repositoryModuleDescriptor != null ? 1 : 0) != 0, (Object)"Null repository module - shall not happen");
        Preconditions.checkState((boolean)repositoryModuleDescriptor.supportsImportFromMaven(), (Object)"Plugin doesn't support importing form Maven");
        File tempDirectory = BambooFileUtils.createTempDirectory((Object)this);
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext();
        PartialVcsRepositoryData repositoryDataFromUi = (PartialVcsRepositoryData)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.vcsConfigurationHelper.temporaryVcsDataFromActionParams((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext(), true), repositoryModuleDescriptor, null, (Set)VcsConfigurationHelper.OVERRIDE_ALL));
        try {
            if (repositoryModuleDescriptor instanceof LegacyRepositoryModuleDescriptor) {
                MavenPomAccessorCapableRepository pomAccessorRepository = this.getCheckoutPomRepository();
                pomAccessorRepository.populateFromConfig((HierarchicalConfiguration)this.getBuildConfiguration());
                this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> {
                    File pomFile = pomAccessorRepository.getMavenPomAccessor().checkoutMavenPom(tempDirectory);
                    this.parsePom(pomFile, repositoryDataFromUi, repositoryModuleDescriptor);
                    return null;
                });
            } else {
                NoContextVcsWorkingCopyManager workingCopyManager = (NoContextVcsWorkingCopyManager)Narrow.downTo((Object)repositoryModuleDescriptor.getWorkingCopyManager(), NoContextVcsWorkingCopyManager.class);
                this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> {
                    VcsWorkingCopy workingCopy = workingCopyManager.updateToLatestRevision(repositoryDataFromUi.getCompleteData(), tempDirectory);
                    File pomFile = repositoryModuleDescriptor.getVcsMavenPomAccessor().findPomFileInWorkingCopy(workingCopy, StringUtils.defaultString((String)this.mavenPath, (String)""));
                    this.parsePom(pomFile, repositoryDataFromUi, repositoryModuleDescriptor);
                    return null;
                });
            }
        }
        catch (IOException e) {
            String MESSAGE = "Problem occurred while creating temporary directory for checkout";
            this.addActionError("Problem occurred while creating temporary directory for checkout");
            log.warn((Object)"Problem occurred while creating temporary directory for checkout", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.addActionError((Exception)((Object)e));
        }
        catch (MavenEmbedderException e) {
            String MESSAGE = "Problem during parsing POM file";
            this.addActionError("Problem during parsing POM file: " + e.getMessage());
            if (!(e.getCause() instanceof ModelBuildingException)) {
                log.warn((Object)"Problem during parsing POM file", (Throwable)e);
            }
        }
        catch (ProjectBuildingException e) {
            String MESSAGE = "Problem during parsing POM file";
            this.addActionError("Problem during parsing POM file: " + e.getMessage());
            log.warn((Object)"Problem during parsing POM file", (Throwable)e);
        }
        finally {
            if (tempDirectory != null) {
                try {
                    BambooFileUtils.deleteDirectory((File)tempDirectory);
                }
                catch (IOException e) {
                    log.warn((Object)("Problem occurred while removing temporary directory " + tempDirectory.getPath()), (Throwable)e);
                }
            }
        }
        if (this.hasErrors()) {
            this.initVcsTypeSelectors(TaskRenderMode.ERROR);
        }
        return this.hasErrors() ? "input" : "success";
    }

    @Nullable
    private MavenPomAccessorCapableRepository getCheckoutPomRepository() {
        return (MavenPomAccessorCapableRepository)Narrow.downTo((Object)this.repositoryManager.getNewRepositoryInstance(this.getSelectedRepositoryKey()), MavenPomAccessorCapableRepository.class);
    }

    private void parsePom(@NotNull File pomFile, PartialVcsRepositoryData repositoryDataFromUi, VcsRepositoryModuleDescriptor userSelectedModuleDescriptor) throws MavenEmbedderException {
        CiManagement ciManagement;
        Model model = this.mavenEmbedderService.buildModel(pomFile, MavenConfiguration.builder().build()).getEffectiveModel();
        Scm scm = model.getScm();
        BuildConfiguration buildConfiguration = this.getBuildConfiguration();
        Plan planInSession = this.getBambooSession().getPlan(this.chainCreationService.getNewInstance());
        StringBuilder planNameBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)model.getName())) {
            planNameBuilder.append(model.getName());
            if (StringUtils.isNotEmpty((CharSequence)model.getVersion())) {
                planNameBuilder.append(" ").append(model.getVersion());
            }
        } else {
            String gav = Stream.of(model.getGroupId(), model.getArtifactId(), model.getVersion()).filter(StringUtils::isNotEmpty).collect(Collectors.joining(":"));
            planNameBuilder.append(gav);
        }
        String planName = planNameBuilder.toString();
        planName = planName.replaceAll("-SNAPSHOT", "");
        planName = planName.replaceAll("SNAPSHOT", "");
        buildConfiguration.setProperty("chainKey", (Object)planName.toUpperCase().replaceAll("[^A-Z0-9]", ""));
        buildConfiguration.setProperty("chainName", (Object)planName);
        VcsRepositoryModuleDescriptor vcsAccordingToMaven = null;
        Map newServerConfiguration = null;
        VcsBranch newVcsBranch = null;
        String webRepositoryUrl = null;
        if (scm != null) {
            String[] scmStrings = StringUtils.split((String)scm.getConnection(), (String)":|", (int)3);
            if (scmStrings != null && scmStrings.length == 3) {
                String scmProvider = scmStrings[1];
                String scmConnection = scmStrings[2];
                vcsAccordingToMaven = this.vcsRepositoryManager.getRepositoryModuleDescriptorByMavenScmKey(scmProvider, repositoryDataFromUi.getPluginKey());
                if (vcsAccordingToMaven != null) {
                    VcsRepositoryData existingData = vcsAccordingToMaven.getCompleteKey().equals(repositoryDataFromUi.getPluginKey()) ? repositoryDataFromUi.getCompleteData() : null;
                    newServerConfiguration = vcsAccordingToMaven.getVcsMavenPomAccessor().parseMavenScmUrlToVcsLocation(scmConnection, existingData);
                    newVcsBranch = vcsAccordingToMaven.getVcsMavenPomAccessor().parseMavenScmUrlToVcsBranch(scmConnection, existingData);
                } else {
                    this.addActionMessage(this.getText("importWithMaven.info.notHandledScmSubstitutedWithDefault", Collections.singletonList(scmProvider)));
                }
            } else {
                this.addActionMessage(this.getText("importWithMaven.info.missingScmSubstitutedWithDefault"));
            }
            webRepositoryUrl = scm.getUrl();
        }
        PartialVcsRepositoryData bambooPlanRepository = this.vcsConfigurationHelper.reconfigureRepositoryWithMavenData(userSelectedModuleDescriptor, repositoryDataFromUi, vcsAccordingToMaven, newServerConfiguration, newVcsBranch, webRepositoryUrl);
        this.getBambooSession().setVcsRepositoryData(bambooPlanRepository);
        buildConfiguration.setProperty("selectedRepository", (Object)bambooPlanRepository.getPluginKey());
        buildConfiguration.clearTree("repository");
        buildConfiguration.clearTree("temporary");
        buildConfiguration.clearTree("webRepository");
        TopLevelPlan topLevelPlan = (TopLevelPlan)Narrow.to((Object)planInSession, TopLevelPlan.class);
        if (topLevelPlan != null && (ciManagement = model.getCiManagement()) != null) {
            ciManagement.getNotifiers().stream().map(this::toNotificationRule).forEach(nro -> nro.ifPresent(nr -> topLevelPlan.getNotificationSet().addNotification(nr)));
        }
    }

    private Optional<NotificationRule> toNotificationRule(Notifier notifier) {
        String notificationTransport = notifier.getType().toLowerCase();
        if ("mail".equals(notificationTransport)) {
            String emailAddress = notifier.getConfiguration().getProperty("address");
            if (notifier.isSendOnSuccess()) {
                return Optional.of(this.notificationManager.createNotificationRule(AllChainNotificationType.class, null, EmailRecipient.class, emailAddress));
            }
            if (notifier.isSendOnError() || notifier.isSendOnFailure() || notifier.isSendOnWarning()) {
                return Optional.of(this.notificationManager.createNotificationRule(ChainFailedAndFirstFixedNotificationType.class, null, EmailRecipient.class, emailAddress));
            }
        }
        return Optional.empty();
    }

    public String getMavenPath() {
        return this.mavenPath;
    }

    public void setMavenPath(String mavenPath) {
        this.mavenPath = mavenPath;
    }

    public String getNotLegacyRepositoriesSelector() {
        return this.vcsRepositoryManager.getAvailableRepositoryDescriptors().stream().filter(md -> md instanceof LegacyRepositoryModuleDescriptor).map(md -> "__" + md.getCompleteKey()).collect(Collectors.joining(" "));
    }
}

