/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.build.creation.ChainCreationService;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.PlanLimitAware;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalCreatePlanSecurityAware;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ImportMavenPlanAction
extends BambooActionSupport
implements GlobalCreatePlanSecurityAware,
BuildConfigurationAware,
Preparable,
PlanLimitAware {
    private static final Logger log = Logger.getLogger(ImportMavenPlanAction.class);
    private static final String MAVEN2_CAPABILITY_KEY = "mvn2";
    private static final String MAVEN3_CAPABILITY_KEY = "mvn3";
    protected static final String PLAN_CREATION_DENIED_ERROR = "planCreationDeniedError";
    protected String existingProjectKey;
    protected String projectKey;
    protected String projectName;
    protected String projectDescription;
    protected boolean planLimitReached = false;
    protected BuildConfiguration buildConfiguration;
    protected List<VcsUIConfigBean.VcsTypeSelector> vcsTypeSelectors;
    @Autowired
    protected TaskManager taskManager;
    @Autowired
    protected PlanValidationService planValidationService;
    @Autowired
    protected RepositoryManager repositoryManager;
    @Autowired
    protected ChainCreationService chainCreationService;
    @Autowired
    protected CustomVariableContext customVariableContext;
    @Autowired
    protected VariableSubstitutorFactory variableSubstitutorFactory;
    @Autowired
    protected VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    protected VcsUIConfigBean vcsUIConfigBean;
    @Autowired
    protected RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    protected VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    @Autowired
    protected UIConfigSupport uiConfigBean;
    @Autowired
    protected VcsViewerUIConfigBean vcsViewerUIConfigBean;

    public void prepare() throws Exception {
        this.buildConfiguration = this.getBambooSession().getBuildConfiguration();
    }

    protected abstract void initVcsTypeSelectors(@NotNull TaskRenderMode var1);

    public void validate() {
        super.validate();
        BuildConfiguration buildConfiguration = this.getBuildConfiguration();
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext();
        String repositoryKey = buildConfiguration.getString("selectedRepository");
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryKey);
        this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> this.lambda$validate$0(vcsRepositoryModuleDescriptor, (ErrorCollection)errorCollection));
        this.addErrorCollection((ErrorCollection)errorCollection);
        if (this.hasAnyErrors()) {
            this.initVcsTypeSelectors(TaskRenderMode.ERROR);
        }
    }

    @Override
    public boolean isPlanLimitReached() {
        return this.planLimitReached;
    }

    @Override
    public void setPlanLimitReached() {
        this.planLimitReached = true;
    }

    public Plan getImmutablePlan() {
        return null;
    }

    @Override
    @Deprecated
    public Plan getPlan() {
        return null;
    }

    @Override
    public Plan getMutablePlan() {
        return null;
    }

    @Override
    public void setPlan(ImmutablePlan plan) {
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        if (this.buildConfiguration == null) {
            this.buildConfiguration = this.getBambooSession().getBuildConfiguration();
        }
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public List<Repository> getRepositories() {
        return Comparators.getDescriptionProviderOrdering().sortedCopy((Iterable)this.repositoryManager.getRepositories());
    }

    public List<VcsUIConfigBean.VcsTypeSelector> getVcsTypeSelectors() {
        return this.vcsTypeSelectors;
    }

    @NotNull
    public Map<String, String> getAvailableMavenBuilders() {
        return this.uiConfigBean.getCapabilityKeyToLabelMap(MAVEN2_CAPABILITY_KEY, MAVEN3_CAPABILITY_KEY);
    }

    protected String getSelectedRepositoryKey() {
        return this.getBuildConfiguration().getString("selectedRepository");
    }

    protected String getSelectedWebRepositoryViewerKey() {
        return this.getBuildConfiguration().getString("selectedWebRepositoryViewer");
    }

    protected String getBuildKey() {
        return this.getBuildConfiguration().getString("buildKey");
    }

    protected String getBuildName() {
        return this.getBuildConfiguration().getString("buildName");
    }

    public String getExistingProjectKey() {
        return this.existingProjectKey;
    }

    public void setExistingProjectKey(String existingProjectKey) {
        this.existingProjectKey = existingProjectKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public UIConfigSupport getUiConfigBean() {
        return this.uiConfigBean;
    }

    public VcsUIConfigBean getVcsUIConfigBean() {
        return this.vcsUIConfigBean;
    }

    private /* synthetic */ void lambda$validate$0(VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor, ErrorCollection errorCollection) {
        this.vcsUIConfigBean.validateVcsConfiguration(vcsRepositoryModuleDescriptor, null, errorCollection, VcsConfigurationHelper.OVERRIDE_ALL);
    }
}

