/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterManager;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRule;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleEntity;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleManager;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleTypeModuleDescriptor;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleTypeUnsafeCodeDecorator;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.validation.ValidationService;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.struts.Preparable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class EditQuickFilterRuleAction
extends GlobalAdminAction
implements Preparable {
    private long quickFilterId;
    private long ruleId;
    private String ruleTypeKey;
    private String ruleName;
    private QuickFilter quickFilter;
    private Map<String, Object> ruleConfiguration;
    private AtomicReference<QuickFilterRule> rule = new AtomicReference();
    private AtomicReference<QuickFilterRuleType> ruleType = new AtomicReference();
    private AtomicReference<List<QuickFilterRuleType>> ruleTypes = new AtomicReference();
    private AtomicReference<Map<String, Object>> actionParameters = new AtomicReference();
    @Autowired
    private QuickFilterManager quickFilterManager;
    @Autowired
    private QuickFilterRuleManager quickFilterRuleManager;
    @Autowired
    private ValidationService validationService;

    public void prepare() throws Exception {
        this.quickFilter = this.quickFilterManager.findById(this.quickFilterId);
        if (this.quickFilter == null) {
            this.addActionError(this.getText("quick.filters.error.not.found", Collections.singletonList(String.valueOf(this.quickFilterId))));
        }
        this.addToActionInvocationStack(this.getActionParameters());
    }

    private void validateRuleId(boolean idRequired) {
        if (idRequired && this.ruleId <= 0L) {
            this.addActionError(this.getText("quick.filters.rule.error.id.required"));
        }
        if (this.ruleId > 0L && this.getRule() == null) {
            this.addActionError(this.getText("quick.filters.rule.error.not.found", Collections.singletonList(this.ruleId)));
        }
    }

    private void validateRuleName() {
        this.addErrorCollection(this.validationService.validateName("ruleName", "quick.filters.rule.error", this.ruleName));
    }

    private void validateRuleType(@NotNull Map<String, Object> configuration) {
        if (StringUtils.isEmpty((CharSequence)this.ruleTypeKey)) {
            this.addFieldError("ruleType", this.getText("quick.filters.rule.error.type.required"));
        } else if (this.getRuleType() == null) {
            this.addFieldError("ruleType", this.getText("quick.filters.rule.error.type.unknown"));
        } else {
            this.addErrorCollection(this.getRuleType().validate(configuration));
        }
    }

    public String input() {
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.ruleConfiguration = new HashMap<String, Object>();
        this.getRuleTypes().forEach(ruleType -> ruleType.addDefaults(this.ruleConfiguration));
        if (this.ruleId > 0L) {
            QuickFilterRule rule = this.getRule();
            this.ruleConfiguration.putAll(rule.getConfiguration());
            this.addToActionInvocationStack((Map<String, Object>)ImmutableMap.of((Object)"ruleName", (Object)rule.getName(), (Object)"ruleTypeKey", (Object)rule.getPluginKey()));
        }
        this.addToActionInvocationStack(this.ruleConfiguration);
        return "input";
    }

    public String execute() {
        this.ruleConfiguration = this.getActionParameters();
        Map filteredConfiguration = Maps.filterKeys(this.ruleConfiguration, this.getRuleType().getConfigurationKeys()::contains);
        this.validateRuleId(false);
        this.validateRuleName();
        this.validateRuleType(filteredConfiguration);
        if (this.hasAnyErrors()) {
            return "error";
        }
        QuickFilterRule rule = this.getRule();
        rule.setQuickFilter(this.quickFilter);
        rule.setPluginKey(this.ruleTypeKey);
        rule.setName(this.ruleName);
        rule.setConfiguration(filteredConfiguration);
        this.quickFilterRuleManager.save(rule);
        return "success";
    }

    public String confirm() {
        this.validateRuleId(true);
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "input";
    }

    public String delete() {
        this.validateRuleId(true);
        if (this.hasAnyErrors()) {
            return "error";
        }
        QuickFilterRule rule = this.getRule();
        this.quickFilter.getRules().remove(rule);
        this.quickFilterRuleManager.delete(rule);
        return "success";
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = this.buildJsonObject();
        QuickFilterRule rule = this.getRule();
        if (rule != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("id", rule.getId());
            result.put("name", rule.getName());
            jsonObject.put("ruleResult", result);
        }
        return jsonObject;
    }

    public List<QuickFilterRuleType> getRuleTypes() {
        return (List)BambooObjectUtils.getCached(this.ruleTypes, () -> this.pluginAccessor.getEnabledModulesByClass(QuickFilterRuleType.class).stream().map(QuickFilterRuleTypeUnsafeCodeDecorator::new).sorted(Comparator.comparing(QuickFilterRuleType::getName)).collect(Collectors.toList()));
    }

    private QuickFilterRuleType getRuleType() {
        return (QuickFilterRuleType)BambooObjectUtils.getCached(this.ruleType, () -> {
            ModuleDescriptor pluginModule = (ModuleDescriptor)Narrow.downTo((Object)this.pluginAccessor.getEnabledPluginModule(this.ruleTypeKey), QuickFilterRuleTypeModuleDescriptor.class);
            return Optional.ofNullable(pluginModule).map(ModuleDescriptor::getModule).map(QuickFilterRuleTypeUnsafeCodeDecorator::new).orElse(null);
        });
    }

    public QuickFilterRule getRule() {
        return (QuickFilterRule)BambooObjectUtils.getCached(this.rule, () -> this.ruleId > 0L ? this.quickFilterRuleManager.findById(this.ruleId) : new QuickFilterRuleEntity(this.quickFilter, this.ruleTypeKey, this.ruleName));
    }

    @NotNull
    public Map<String, Object> getRuleConfiguration() {
        return this.ruleConfiguration;
    }

    @NotNull
    private Map<String, Object> getActionParameters() {
        return (Map)BambooObjectUtils.getCached(this.actionParameters, () -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, String[]> actionParam : ActionParamsUtils.getStringArrayMap().entrySet()) {
                String key = actionParam.getKey();
                String[] value = actionParam.getValue();
                if (value == null || value.length <= 0) continue;
                if (value.length == 1) {
                    result.put(key, value[0]);
                    continue;
                }
                result.put(key, new ArrayList<String>(Arrays.asList(value)));
            }
            return result;
        });
    }

    private void addToActionInvocationStack(@NotNull Map<String, Object> configuration) {
        OgnlStackUtils.putAll(configuration);
    }

    public long getQuickFilterId() {
        return this.quickFilterId;
    }

    public void setQuickFilterId(long quickFilterId) {
        this.quickFilterId = quickFilterId;
    }

    public long getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(long ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleTypeKey() {
        return this.ruleTypeKey;
    }

    public void setRuleTypeKey(String ruleTypeKey) {
        this.ruleTypeKey = ruleTypeKey;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }
}

