/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.ConcurrentBuildConfig;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import org.apache.log4j.Logger;

public class ConfigureConcurrentBuilds
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ConfigureConcurrentBuilds.class);
    private int numberConcurrentBuilds;
    private ConcurrentBuildConfig concurrencyConfig;

    @Override
    public String doDefault() throws Exception {
        this.numberConcurrentBuilds = this.getConcurrencyConfig().getNumberConcurrentBuilds();
        return "input";
    }

    public String execute() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        ConcurrentBuildConfig concurrencyConfig = administrationConfiguration.getConcurrentBuildConfig();
        concurrencyConfig.setNumberConcurrentBuilds(this.numberConcurrentBuilds);
        concurrencyConfig.setEnabled(true);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        return "success";
    }

    public String disable() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        ConcurrentBuildConfig concurrencyConfig = administrationConfiguration.getConcurrentBuildConfig();
        concurrencyConfig.setEnabled(false);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        return "success";
    }

    public void validate() {
        if (this.numberConcurrentBuilds < 1) {
            this.addFieldError("numberConcurrentBuilds", this.getText("admin.concurrentBuilds.number.error"));
        }
    }

    public ConcurrentBuildConfig getConcurrencyConfig() {
        if (this.concurrencyConfig == null) {
            this.concurrencyConfig = this.getAdministrationConfiguration().getConcurrentBuildConfig();
        }
        return this.concurrencyConfig;
    }

    public int getNumberConcurrentBuilds() {
        return this.numberConcurrentBuilds;
    }

    public void setNumberConcurrentBuilds(int numberConcurrentBuilds) {
        this.numberConcurrentBuilds = numberConcurrentBuilds;
    }
}

