/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlerConfigurator;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersFunctions;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersServiceImpl;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.MessageCollection;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.admin.elastic.BambooAwsUtils;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigureArtifactStorage
extends GlobalAdminAction {
    private String selectedArtifactStorage;
    private boolean configurationUpdated;
    @Autowired
    private TemplateRenderer templateRenderer;
    @Autowired
    private ArtifactHandlersService artifactHandlersService;

    public String input() throws Exception {
        Map configuration = this.artifactHandlersService.getConfiguration();
        OgnlStackUtils.putAll((Map)configuration);
        this.selectedArtifactStorage = (String)this.artifactHandlersService.getEnabledArtifactHandlerKeys().iterator().next();
        return "input";
    }

    public String save() throws Exception {
        final ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext());
        actionParametersMap.recreateCheckboxValues();
        for (final ArtifactHandlerConfigurator configurator : this.getArtifactHandlerConfigurators()) {
            String errorMessage = configurator.getClass() + " wasn't able to process configuration before save";
            BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Runnable(errorMessage){

                public void run() {
                    configurator.postProcessConfiguration((ActionParametersMap)actionParametersMap);
                }
            });
        }
        Map<String, String> artifactHandlerConfigurationToSave = this.prepareArtifactHandlersConfiguration((ActionParametersMap)actionParametersMap);
        ErrorCollection errorCollection = this.artifactHandlersService.validateConfiguration(artifactHandlerConfigurationToSave);
        if (errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
            return "error";
        }
        MessageCollection feedback = this.artifactHandlersService.saveConfiguration(artifactHandlerConfigurationToSave);
        feedback.forEach(arg_0 -> ((ConfigureArtifactStorage)this).addActionMessage(arg_0));
        this.configurationUpdated = true;
        this.input();
        return "success";
    }

    private Map<String, String> prepareArtifactHandlersConfiguration(ActionParametersMap actionParametersMap) {
        Map artifactHandlerConfigurationToSave = this.artifactHandlersService.getConfiguration();
        String artifactHandlerConfigurationPrefix = this.getArtifactHandlerConfigurationPrefix(this.selectedArtifactStorage);
        Map modifiedArtifactHandlerConfiguration = Maps.filterKeys((Map)actionParametersMap, (com.google.common.base.Predicate)Predicates.and(ArtifactHandlersFunctions::isArtifactHandlerConfiguration, TextPredicates.startsWith((String)artifactHandlerConfigurationPrefix)::test));
        for (String key2 : modifiedArtifactHandlerConfiguration.keySet()) {
            artifactHandlerConfigurationToSave.put(key2, actionParametersMap.getString(key2));
        }
        Predicate keyFilter = TextPredicates.endsWithAny((String[])new String[]{ArtifactHandlersServiceImpl.ENABLED_FOR_SHARED, ArtifactHandlersServiceImpl.ENABLED_FOR_NON_SHARED});
        artifactHandlerConfigurationToSave.replaceAll((key, value) -> keyFilter.test(key) ? Boolean.FALSE.toString() : value);
        artifactHandlerConfigurationToSave.put(ArtifactHandlingUtils.getConfigKey((String)artifactHandlerConfigurationPrefix, (String)ArtifactHandlersServiceImpl.ENABLED_FOR_SHARED), Boolean.TRUE.toString());
        artifactHandlerConfigurationToSave.put(ArtifactHandlingUtils.getConfigKey((String)artifactHandlerConfigurationPrefix, (String)ArtifactHandlersServiceImpl.ENABLED_FOR_NON_SHARED), Boolean.TRUE.toString());
        return artifactHandlerConfigurationToSave;
    }

    @Nullable
    public String getEditHtml(ArtifactHandlerModuleDescriptor moduleDescriptor) {
        HashMap<String, Collection<AwsSupportConstants.Region>> freemarkerContext = new HashMap<String, Collection<AwsSupportConstants.Region>>();
        freemarkerContext.putAll(this.artifactHandlersService.getConfiguration());
        moduleDescriptor.getConfigurator().populateContextForEdit(freemarkerContext);
        freemarkerContext.put("availableRegions", BambooAwsUtils.getBambooSupportedRegions());
        OgnlStackUtils.putAllIfAbsent(freemarkerContext);
        Map ognlContext = OgnlStackUtils.getOgnlContext();
        Object parameters = ognlContext.get("parameters");
        if (parameters != null) {
            Map parameterMap = (Map)parameters;
            OgnlStackUtils.putAllIfPresent((Map)parameterMap);
        }
        return this.templateRenderer.render(moduleDescriptor.getEditTemplate(), freemarkerContext);
    }

    public List<ArtifactHandlerConfigurator> getArtifactHandlerConfigurators() {
        return this.artifactHandlersService.getArtifactHandlerConfigurators();
    }

    public List<ArtifactHandlerModuleDescriptor> getArtifactHandlerModuleDescriptors() {
        return this.artifactHandlersService.getArtifactHandlerModuleDescriptors();
    }

    public List<Pair<String, String>> getArtifactHandlerDescriptors() {
        List artifactHandlerModuleDescriptors = this.artifactHandlersService.getArtifactHandlerModuleDescriptors();
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (ArtifactHandlerModuleDescriptor artifactHandlerModuleDescriptor : artifactHandlerModuleDescriptors) {
            Pair pair = Pair.make((Object)artifactHandlerModuleDescriptor.getCompleteKey(), (Object)this.getLocationLabel(artifactHandlerModuleDescriptor));
            result.add((Pair<String, String>)pair);
        }
        return result;
    }

    public void setSelectedArtifactStorage(String selectedArtifactStorage) {
        this.selectedArtifactStorage = selectedArtifactStorage;
    }

    public String getSelectedArtifactStorage() {
        return this.selectedArtifactStorage;
    }

    public boolean isConfigurationUpdated() {
        return this.configurationUpdated;
    }

    public void setConfigurationUpdated(boolean configurationUpdated) {
        this.configurationUpdated = configurationUpdated;
    }

    private String getLocationLabel(ArtifactHandlerModuleDescriptor artifactHandlerModuleDescriptor) {
        String key = "admin.artifactstorage.location." + artifactHandlerModuleDescriptor.getConfigurationPrefix().replaceAll(":", ".") + ".server";
        return this.getText(key);
    }

    private Object getSingleValue(Object value) {
        String[] ar;
        if (value instanceof String[] && (ar = (String[])value).length > 0) {
            return ar[0];
        }
        return value;
    }

    private String getArtifactHandlerConfigurationPrefix(String artifactStorageKey) {
        for (ArtifactHandlerModuleDescriptor artifactHandlerModuleDescriptor : this.getArtifactHandlerModuleDescriptors()) {
            if (!artifactHandlerModuleDescriptor.getCompleteKey().equals(artifactStorageKey)) continue;
            return artifactHandlerModuleDescriptor.getConfigurationPrefix();
        }
        return artifactStorageKey;
    }
}

