/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlerConfigurator;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersFunctions;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.plugins.web.conditions.ArtifactHandlersConfigurableCondition;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.MessageCollection;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.admin.elastic.BambooAwsUtils;
import com.atlassian.bamboo.ww2.aware.ConditionallyAvailable;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.atlassian.struts.Preparable;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConditionallyAvailable(condition={ArtifactHandlersConfigurableCondition.class})
public class ConfigureArtifactHandlers
extends GlobalAdminAction
implements Preparable {
    @Inject
    private ArtifactHandlersService artifactHandlersService;
    @Inject
    private TemplateRenderer templateRenderer;
    private final Predicate<ModuleDescriptor<ArtifactHandler>> artifactHandlerModuleDescriptorPredicate = new ModuleOfClassPredicate(ArtifactHandler.class).and((Predicate)new EnabledModulePredicate());
    private boolean configurationUpdated = false;

    public void prepare() throws Exception {
    }

    public String execute() throws Exception {
        OgnlStackUtils.putAll((Map)this.artifactHandlersService.getConfiguration());
        return "input";
    }

    public String save() {
        final ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext());
        actionParametersMap.recreateCheckboxValues();
        actionParametersMap.detachFromActionContext();
        for (final ArtifactHandlerConfigurator configurator : this.getArtifactHandlerConfigurators()) {
            String errorMessage = configurator.getClass() + " wasn't able to process configuration before save";
            BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Runnable(errorMessage){

                public void run() {
                    configurator.postProcessConfiguration((ActionParametersMap)actionParametersMap);
                }
            });
        }
        Map artifactHandlerConfigurationToSave = this.artifactHandlersService.getConfiguration();
        Map modifiedArtifactHandlerConfiguration = Maps.filterKeys((Map)((Object)actionParametersMap), ArtifactHandlersFunctions::isArtifactHandlerConfiguration);
        for (String key : modifiedArtifactHandlerConfiguration.keySet()) {
            artifactHandlerConfigurationToSave.put(key, actionParametersMap.getString(key));
        }
        OgnlStackUtils.putAll((Map)artifactHandlerConfigurationToSave);
        ErrorCollection errorCollection = this.artifactHandlersService.validateConfiguration(artifactHandlerConfigurationToSave);
        if (errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
            return "error";
        }
        MessageCollection feedback = this.artifactHandlersService.saveConfiguration(artifactHandlerConfigurationToSave);
        feedback.forEach(arg_0 -> ((ConfigureArtifactHandlers)this).addActionMessage(arg_0));
        this.configurationUpdated = true;
        return "success";
    }

    @NotNull
    public List<ArtifactHandlerConfigurator> getArtifactHandlerConfigurators() {
        return (List)this.getArtifactHandlerDescriptors().stream().map(ArtifactHandlerModuleDescriptor::getConfigurator).collect(CollectorsUtil.toImmutableList());
    }

    public List<ArtifactHandlerModuleDescriptor> getArtifactHandlerDescriptors() {
        return (List)this.pluginAccessor.getModuleDescriptors(this.artifactHandlerModuleDescriptorPredicate).stream().flatMap(OptionalNarrow.down(ArtifactHandlerModuleDescriptor.class)).collect(CollectorsUtil.toImmutableList());
    }

    @Nullable
    public String getEditHtml(ArtifactHandlerModuleDescriptor moduleDescriptor) {
        HashMap<String, Collection<AwsSupportConstants.Region>> freemarkerContext = new HashMap<String, Collection<AwsSupportConstants.Region>>();
        moduleDescriptor.getConfigurator().populateContextForEdit(freemarkerContext);
        freemarkerContext.put("availableRegions", BambooAwsUtils.getBambooSupportedRegions());
        OgnlStackUtils.putAllIfAbsent(freemarkerContext);
        return this.templateRenderer.render(moduleDescriptor.getEditTemplate(), freemarkerContext);
    }

    public boolean isConfigurationUpdated() {
        return this.configurationUpdated;
    }
}

