/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;

public class ViewActivityLog
extends PlanActionSupport
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewActivityLog.class);
    public static final int DEFAULT_DISPLAY_LINES = 10;
    public static final int DEFAULT_REFRESH_RATE = 1;
    private BuildLoggerManager buildLoggerManager;
    public static final String BAMBOO_MAX_DISPLAY_LINES = "BAMBOO-MAX-DISPLAY-LINES";
    public static final String BAMBOO_LOG_REFRESH = "BAMBOO-LOG-REFRESH";
    private List<LogEntry> activityLog;
    private int secondsToRefresh = -1;
    private int linesToDisplay = -1;

    @Override
    public String doDefault() throws Exception {
        return this.execute();
    }

    public String execute() throws Exception {
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            this.addActionError("Could not find the \"" + this.getPlanKey() + "\" build");
            return "error";
        }
        if (this.secondsToRefresh == -1) {
            this.secondsToRefresh = NumberUtils.toInt((String)this.cookieCutter.getValueFromCookie(BAMBOO_LOG_REFRESH), (int)1);
        }
        this.cookieCutter.saveValueInCookie(BAMBOO_LOG_REFRESH, String.valueOf(this.secondsToRefresh));
        if (this.linesToDisplay == -1) {
            this.linesToDisplay = NumberUtils.toInt((String)this.cookieCutter.getValueFromCookie(BAMBOO_MAX_DISPLAY_LINES), (int)10);
        } else if (this.linesToDisplay < 10) {
            this.linesToDisplay = 10;
        }
        this.cookieCutter.saveValueInCookie(BAMBOO_MAX_DISPLAY_LINES, String.valueOf(this.linesToDisplay));
        return "input";
    }

    public int getSecondsToRefresh() {
        return this.secondsToRefresh;
    }

    public void setSecondsToRefresh(int secondsToRefresh) {
        this.secondsToRefresh = secondsToRefresh;
    }

    public List<LogEntry> getActivityLog() {
        if (this.activityLog == null) {
            this.activityLog = this.buildLoggerManager.getLogger((Key)PlanKeys.getPlanKey((String)this.getBuildKey())).getLastNLogEntries(this.linesToDisplay);
        }
        return this.activityLog;
    }

    public int getLinesToDisplay() {
        return this.linesToDisplay;
    }

    public void setLinesToDisplay(int linesToDisplay) {
        this.linesToDisplay = linesToDisplay;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }
}

