/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions;

import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.chains.BuildContextFactory;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.logger.DecoratingErrorAccessorImpl;
import com.atlassian.bamboo.logger.ErrorAccessor;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanExecutionConfigImpl;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.bamboo.ww2.aware.ProjectAware;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanActionSupport
extends BambooActionSupport
implements ProjectAware,
PlanAware {
    private static final Logger log = Logger.getLogger(PlanActionSupport.class);
    private ImmutablePlan plan;
    private final Supplier<Plan> mutablePlan = Lazy.supplier((Supplier)new Supplier<Plan>(){

        @Override
        @Nullable
        public Plan get() {
            Plan mutablePlan = PlanActionSupport.this.plan == null ? null : PlanActionSupport.this.planManager.getPlanById(PlanActionSupport.this.plan.getId());
            PlanActionSupport.this.plan = mutablePlan;
            return mutablePlan;
        }
    });
    private String planKey;
    private String buildKey;
    private String planResultKey;
    protected Integer buildNumber;
    protected ResultsSummaryManager resultsSummaryManager;
    protected VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    private ErrorAccessor errorAccessor;
    protected JiraApplinksService jiraApplinksService;
    protected RepositoryDefinitionManager repositoryDefinitionManager;
    private BuildContextFactory buildContextFactory;

    @Override
    public Project getProject() {
        if (this.getImmutablePlan() != null) {
            return this.getImmutablePlan().getProject();
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutablePlan getImmutablePlan() {
        return this.plan;
    }

    @Override
    @Deprecated
    public Plan getPlan() {
        return this.getMutablePlan();
    }

    @Override
    public Plan getMutablePlan() {
        return this.mutablePlan.get();
    }

    @Override
    public void setPlan(ImmutablePlan plan) {
        this.plan = plan;
    }

    public String getPlanKey() {
        return StringUtils.defaultString((String)this.planKey, (String)this.buildKey);
    }

    public void setPlanKey(String planKey) {
        this.planKey = planKey;
    }

    public String getBuildKey() {
        return StringUtils.defaultString((String)this.buildKey, (String)this.planKey);
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    public String getPlanResultKey() {
        return this.planResultKey;
    }

    @Nullable
    public PlanKey getTypedPlanKey() {
        String planKey = this.getPlanKey();
        if (StringUtils.isNotBlank((CharSequence)planKey)) {
            return PlanKeys.getPlanKey((String)planKey);
        }
        return null;
    }

    @Nullable
    public PlanResultKey getTypedPlanResultKey() {
        if (StringUtils.isNotBlank((CharSequence)this.planResultKey)) {
            return PlanKeys.getPlanResultKey((String)this.planResultKey);
        }
        if (StringUtils.isNotBlank((CharSequence)this.planKey) && this.buildNumber != null) {
            return PlanKeys.getPlanResultKey((String)this.planKey, (int)this.buildNumber);
        }
        return null;
    }

    public void setPlanResultKey(String planResultKey) {
        this.planResultKey = planResultKey;
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    public Collection<? extends ExecutionStatus> getCurrentlyBuildingPlans(@NotNull PlanKey planKey) {
        return this.planExecutionManager.getExecutionStatus(planKey);
    }

    @Override
    public Object getSecuredDomainObject() {
        return this.getImmutablePlan();
    }

    public boolean isJiraApplicationLinkDefined() {
        return this.jiraApplinksService.hasJiraApplicationLink();
    }

    protected ResultsSummaryManager getResultsSummaryManager() {
        return this.resultsSummaryManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    @Override
    public void setPlanExecutionManager(PlanExecutionManager planExecutionManager) {
        this.planExecutionManager = planExecutionManager;
    }

    public ErrorAccessor getErrorAccessor() {
        return this.errorAccessor;
    }

    public void setDecoratingErrorAccessor(DecoratingErrorAccessorImpl errorAccessor) {
        this.errorAccessor = errorAccessor;
    }

    @Override
    @NotNull
    protected Map<String, Object> buildWebPanelContext(@NotNull String location) {
        Map<String, Object> objectMap = super.buildWebPanelContext(location);
        if (this.plan != null) {
            objectMap.put("plan", this.plan);
        }
        return objectMap;
    }

    protected String planNotFound() {
        this.addActionError(this.getTextWithArgs("error.plan.not.found", this.getPlanKey()));
        return "error";
    }

    public Map<WebItemModuleDescriptor, String> getJobsWebItemsForSection(String sectionName, HttpServletRequest req) {
        List jobs;
        Iterable displayableItems;
        Iterable pluginItems;
        ImmutableChain chain;
        LinkedHashMap<WebItemModuleDescriptor, String> descriptors = new LinkedHashMap<WebItemModuleDescriptor, String>();
        Map<String, Object> fragmentsContextMap = this.getWebFragmentsContextMap();
        if ((fragmentsContextMap.containsKey("planKey") || fragmentsContextMap.containsKey("buildKey")) && (chain = (ImmutableChain)this.cachedPlanManager.getPlanByKey(this.getTypedPlanKey(), ImmutableChain.class)) != null && !Iterables.isEmpty((Iterable)(pluginItems = Iterables.filter((Iterable)this.webInterfaceManager.getItems(sectionName), (com.google.common.base.Predicate)new com.google.common.base.Predicate<WebItemModuleDescriptor>(){

            public boolean apply(@Nullable WebItemModuleDescriptor input) {
                return !input.getCompleteKey().startsWith("bamboo.sections.global.admin");
            }
        }))) && !Iterables.isEmpty((Iterable)(displayableItems = Iterables.filter((Iterable)pluginItems, (com.google.common.base.Predicate)new com.google.common.base.Predicate<WebItemModuleDescriptor>(jobs = chain.getAllJobs(), fragmentsContextMap){
            final /* synthetic */ List val$jobs;
            final /* synthetic */ Map val$fragmentsContextMap;
            {
                this.val$jobs = list;
                this.val$fragmentsContextMap = map;
            }

            public boolean apply(WebItemModuleDescriptor input) {
                for (ImmutableJob job : this.val$jobs) {
                    HashMap<String, String> jobFragmentsContextMap = new HashMap<String, String>(this.val$fragmentsContextMap);
                    jobFragmentsContextMap.put("planKey", job.getKey());
                    jobFragmentsContextMap.put("buildKey", job.getKey());
                    try {
                        if (input.getCondition() != null && !input.getCondition().shouldDisplay(jobFragmentsContextMap)) continue;
                        return true;
                    }
                    catch (Throwable t) {
                        log.error((Object)("Could not evaluate condition '" + input.getCondition() + "' for descriptor: " + input), t);
                    }
                }
                return false;
            }
        })))) {
            String contextPath = ServletActionContext.getRequest().getContextPath();
            for (WebItemModuleDescriptor displayableItem : displayableItems) {
                descriptors.put(displayableItem, String.format(contextPath + "/browse/%s/aggregate?%s=%s", chain.getKey(), "pluginKey", displayableItem.getCompleteKey()));
            }
        }
        return descriptors;
    }

    public boolean isRestartable(@NotNull ResultsSummary resultsSummary) {
        return this.canRun(resultsSummary, PlanExecutionConfig.PlanExecutionType.RESTART, arg_0 -> ((VcsRepositoryConfigurationService)this.vcsRepositoryConfigurationService).validateRestartableStatus(arg_0));
    }

    public boolean isContinuable(@NotNull ResultsSummary resultsSummary) {
        return this.canRun(resultsSummary, PlanExecutionConfig.PlanExecutionType.CONTINUE, arg_0 -> ((VcsRepositoryConfigurationService)this.vcsRepositoryConfigurationService).validateContinuableStatus(arg_0));
    }

    @Nullable
    public String getFirstNotRunnableStage(@NotNull ResultsSummary resultsSummary) {
        ImmutableChainResultsSummary crs = (ImmutableChainResultsSummary)Narrow.downTo((Object)resultsSummary, ImmutableChainResultsSummary.class);
        if (crs != null && crs.isContinuable()) {
            boolean notRunnableStageFound = false;
            for (ChainStageResult chainStageResult : crs.getStageResults()) {
                if (chainStageResult.isFinished()) continue;
                if (!chainStageResult.isAllJobsExist()) {
                    notRunnableStageFound = true;
                }
                if (!notRunnableStageFound || !chainStageResult.isManual()) continue;
                return chainStageResult.getName();
            }
        }
        return null;
    }

    private boolean canRun(@NotNull ResultsSummary resultsSummary, PlanExecutionConfig.PlanExecutionType planExecutionType, Predicate<ResultsSummary> vcsConfigurationTest) {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)resultsSummary, ChainResultsSummary.class);
        if (chainResultsSummary == null) {
            return false;
        }
        PlanExecutionConfig planExecutionConfig = new PlanExecutionConfigImpl(planExecutionType).setChainResultSummary(chainResultsSummary).build();
        return this.buildContextFactory.canRestartOrContinueBuild(chainResultsSummary.getImmutableChain(), chainResultsSummary, planExecutionConfig) && vcsConfigurationTest.test(resultsSummary);
    }

    public void setJiraApplinksService(JiraApplinksService jiraApplinksService) {
        this.jiraApplinksService = jiraApplinksService;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setVcsRepositoryConfigurationService(VcsRepositoryConfigurationService vcsRepositoryConfigurationService) {
        this.vcsRepositoryConfigurationService = vcsRepositoryConfigurationService;
    }

    public void setBuildContextFactory(BuildContextFactory buildContextFactory) {
        this.buildContextFactory = buildContextFactory;
    }
}

