/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions;

import com.atlassian.bamboo.schedule.BambooCronEditorBean;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.core.cron.CronEditorBean;
import com.atlassian.core.cron.generator.CronExpressionDescriptor;
import com.atlassian.core.cron.generator.CronExpressionGenerator;
import com.atlassian.core.cron.parser.CronExpressionParser;
import com.atlassian.core.i18n.I18nTextProvider;
import com.atlassian.xwork.ParameterSafe;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;

public class CronExpressionGeneratorAction
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(CronExpressionGeneratorAction.class);
    private BambooCronEditorBean cronEditorBean;
    private String cronExpression;

    public void validate() {
        if ("advanced".equals(this.getCronEditorBean().getMode()) && StringUtils.isEmpty((CharSequence)this.getCronEditorBean().getCronString())) {
            this.addFieldError("cronEditorBean.cronString", this.getText("backup.cronExpression.error.blank"));
        } else if (this.getCronEditorBean().getMode().equals("advanced")) {
            try {
                CronExpression cronExpr = new CronExpression(this.getCronEditorBean().getCronString());
                cronExpr.getNextValidTimeAfter(new Date());
            }
            catch (ParseException e) {
                this.addFieldError("cronEditorBean.cronString", this.getText("backup.cronExpression.error.invalid"));
            }
            catch (UnsupportedOperationException e) {
                this.addFieldError("cronEditorBean.cronString", this.getText("backup.cronExpression.error.unsupported"));
            }
            catch (Exception e) {
                this.addFieldError("cronEditorBean.cronString", this.getText("backup.cronExpression.error.failure"));
                log.error((Object)"Validation of Cron Expression Failed", (Throwable)e);
            }
        } else {
            try {
                CronExpressionGenerator cronExpressionGenerator = new CronExpressionGenerator();
                cronExpressionGenerator.getCronExpressionFromInput((CronEditorBean)this.getCronEditorBean());
            }
            catch (Exception e) {
                this.addFieldError("cronEditorBean.cronString", this.getText("backup.cronExpression.error.invalid") + ": " + e.getMessage());
            }
        }
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject json = super.getJsonObject();
        try {
            CronExpressionGenerator cronExpressionGenerator = new CronExpressionGenerator();
            String cronExpressionStr = cronExpressionGenerator.getCronExpressionFromInput((CronEditorBean)this.getCronEditorBean());
            json.put("cronExpression", (Object)cronExpressionStr);
            CronExpressionDescriptor descriptor = new CronExpressionDescriptor((I18nTextProvider)this);
            String prettyVersion = descriptor.getPrettySchedule((CronEditorBean)this.getCronEditorBean());
            json.put("prettyCronExpression", (Object)prettyVersion);
            try {
                CronExpression cronExpression = new CronExpression(cronExpressionStr);
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).build();
                json.put("nextFireTime", trigger.getFireTimeAfter(new Date()).getTime());
            }
            catch (Exception e) {
                json.put("nextFireTime", (Object)"");
            }
        }
        catch (Exception e) {
            json.put("cronExpression", (Object)"");
            json.put("prettyCronExpression", (Object)"");
            json.put("nextFireTime", (Object)"");
        }
        return json;
    }

    @ParameterSafe
    public BambooCronEditorBean getCronEditorBean() {
        if (this.cronEditorBean == null) {
            if (StringUtils.isNotBlank((CharSequence)this.cronExpression)) {
                try {
                    CronExpressionParser parser = new CronExpressionParser(this.cronExpression);
                    this.cronEditorBean = new BambooCronEditorBean(parser.getCronEditorBean());
                }
                catch (Exception e) {
                    log.error((Object)("Failed to parse the cron expression '" + this.cronExpression + "': " + e));
                }
            } else {
                this.cronEditorBean = new BambooCronEditorBean("", new HashMap());
                this.cronEditorBean.setMode("daily");
            }
        }
        return this.cronEditorBean;
    }

    public CronEditorBean getBeanFromCronExpression(String backupCronExpression) {
        CronExpressionParser parser = new CronExpressionParser(backupCronExpression);
        return parser.getCronEditorBean();
    }

    public void setCronEditorBean(BambooCronEditorBean cronEditorBean) {
        this.cronEditorBean = cronEditorBean;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }
}

