/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.StageStatusHelper;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.logger.DecoratingErrorAccessorImpl;
import com.atlassian.bamboo.logger.ErrorAccessor;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanIdentifierImpl;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.ChainAwareContextHolder;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.ChainAware;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.Lazy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ChainActionSupport
extends PlanActionSupport
implements ChainAware {
    private final ChainAwareContextHolder chainAwareContextHolder = new ChainAwareContextHolder();
    protected ChainExecutionManager chainExecutionManager;
    protected StageStatusHelper stageStatusHelper;
    protected ExecutableAgentsHelper executableAgentsHelper;
    private ErrorAccessor decoratedAggregatedChainErrorAccessor;
    private List<ChainBranch> chainBranches;
    private List<ImmutableChainBranch> immutableChainBranches;
    private List<PlanIdentifier> chainBranchIdentifiers;
    private List<PlanIdentifier> siblingChainBranchIdentifiers;
    private final Supplier<Chain> mutableChain = Lazy.supplier(() -> {
        Chain mutableChain = (Chain)Narrow.downTo((Object)this.getMutablePlan(), Chain.class);
        this.chainAwareContextHolder.setChain((ImmutableChain)mutableChain);
        return mutableChain;
    });
    private final Supplier<ChainStage> mutableChainStage = Lazy.supplier((Supplier)new Supplier<ChainStage>(){

        @Override
        @Nullable
        public ChainStage get() {
            ImmutableChainStage chainStage = ChainActionSupport.this.getImmutableChainStage();
            if (chainStage == null) {
                return null;
            }
            for (ChainStage mutableStage : ChainActionSupport.this.getMutableChain().getStages()) {
                if (chainStage.getId() != mutableStage.getId()) continue;
                ChainActionSupport.this.chainAwareContextHolder.setChainStage((ImmutableChainStage)mutableStage);
                return mutableStage;
            }
            return null;
        }
    });
    protected ChainBranchManager chainBranchManager;

    @Override
    public ImmutableChain getImmutableChain() {
        return this.chainAwareContextHolder.getImmutableChain();
    }

    @Deprecated
    public Chain getChain() {
        return this.getMutableChain();
    }

    public Chain getMutableChain() {
        return this.mutableChain.get();
    }

    @Override
    public void setChain(ImmutableChain chain) {
        this.chainAwareContextHolder.setChain(chain);
    }

    @Override
    @Nullable
    public ImmutableChainStage getImmutableChainStage() {
        return this.chainAwareContextHolder.getImmutableChainStage();
    }

    public ChainStage getMutableChainStage() {
        return this.mutableChainStage.get();
    }

    @Override
    public void setChainStage(ImmutableChainStage chainStage) {
        this.chainAwareContextHolder.setChainStage(chainStage);
    }

    @Override
    public ChainResultsSummary getChainResult() {
        return this.chainAwareContextHolder.getChainResult();
    }

    @Override
    public void setChainResult(ChainResultsSummary chainResult) {
        this.chainAwareContextHolder.setChainResult(chainResult);
    }

    @Override
    public int getChainResultNumber() {
        return this.chainAwareContextHolder.getChainResultNumber();
    }

    @Override
    public void setChainResultNumber(int chainResultNumber) {
        this.chainAwareContextHolder.setChainResultNumber(chainResultNumber);
    }

    public void setChainExecutionManager(ChainExecutionManager chainExecutionManager) {
        this.chainExecutionManager = chainExecutionManager;
    }

    public StageStatusHelper getStageStatusHelper() {
        return this.stageStatusHelper;
    }

    public void setStageStatusHelper(StageStatusHelper stageStatusHelper) {
        this.stageStatusHelper = stageStatusHelper;
    }

    public void setExecutableAgentsHelper(ExecutableAgentsHelper executableAgentsHelper) {
        this.executableAgentsHelper = executableAgentsHelper;
    }

    @Override
    public ErrorAccessor getErrorAccessor() {
        return this.decoratedAggregatedChainErrorAccessor;
    }

    public void setDecoratingAggregatedChainErrorAccessor(DecoratingErrorAccessorImpl errorAccessor) {
        this.decoratedAggregatedChainErrorAccessor = errorAccessor;
    }

    public List<ChainBranch> getChainBranches() {
        if (this.chainBranches == null) {
            this.chainBranches = this.chainBranchManager.getBranchesForChain(this.getImmutableChain());
        }
        return this.chainBranches;
    }

    public List<ImmutableChainBranch> getImmutableChainBranches() {
        if (this.immutableChainBranches == null) {
            this.immutableChainBranches = this.cachedPlanManager.getBranchesForChain((PlanIdentifier)this.getImmutableChain());
        }
        return this.immutableChainBranches;
    }

    public ImmutableList<ImmutableChainBranch> getChainBranchesByDate() {
        return Comparators.getBranchUpdatedDateOrdering().reverse().immutableSortedCopy(this.getImmutableChainBranches());
    }

    public List<PlanIdentifier> getBranchIdentifiers() {
        if (this.chainBranchIdentifiers == null) {
            ImmutableChain chain = this.getImmutableChain();
            if (chain.hasMaster()) {
                chain = chain.getMaster();
            }
            this.chainBranchIdentifiers = Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy(Iterables.concat((Iterable)this.chainBranchManager.getBranchIdentifiersForChain((PlanIdentifier)chain), Collections.singleton(new PlanIdentifierImpl((PlanIdentifier)chain))));
        }
        return this.chainBranchIdentifiers;
    }

    public List<PlanIdentifier> getSiblingBranchIdentifiers() {
        if (this.siblingChainBranchIdentifiers == null) {
            ImmutableChain chain = this.getImmutableChain();
            this.siblingChainBranchIdentifiers = chain.hasMaster() ? (List<Object>)this.getBranchIdentifiers().stream().filter(PlanPredicates.hasEqualPlanKey((PlanKey)chain.getPlanKey()).negate()).collect(Collectors.toCollection(ArrayList::new)) : this.getBranchIdentifiers();
        }
        return this.siblingChainBranchIdentifiers;
    }

    public void setChainBranchManager(ChainBranchManager chainBranchManager) {
        this.chainBranchManager = chainBranchManager;
    }
}

