/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions;

import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.ww2.actions.BuildableAwareContextHolder;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.BuildableAware;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class BuildActionSupport
extends PlanActionSupport
implements BuildableAware {
    private final BuildableAwareContextHolder buildableAwareContextHolder = new BuildableAwareContextHolder();
    protected BuildExecutionManager buildExecutionManager;
    private final Supplier<Buildable> mutableBuild = Lazy.supplier((Supplier)new Supplier<Buildable>(){

        @Override
        @Nullable
        public Buildable get() {
            Plan mutablePlan = BuildActionSupport.this.getMutablePlan();
            Buildable mutableBuildable = mutablePlan == null ? null : (Buildable)Narrow.downTo((Object)mutablePlan, Buildable.class);
            BuildActionSupport.this.buildableAwareContextHolder.setBuild((ImmutableBuildable)mutableBuildable);
            return mutableBuildable;
        }
    });

    public String getBuildResultKey() {
        return this.buildableAwareContextHolder.getBuildResultKey();
    }

    public void setBuildResultKey(String buildResultKey) {
        this.buildableAwareContextHolder.setBuildResultKey(buildResultKey);
    }

    @Override
    public ImmutableBuildable getImmutableBuild() {
        return this.buildableAwareContextHolder.getImmutableBuild();
    }

    public Buildable getMutableBuild() {
        return this.mutableBuild.get();
    }

    @Override
    public void setBuild(ImmutableBuildable build) {
        this.buildableAwareContextHolder.setBuild(build);
    }

    public List<CurrentlyBuilding> getCurrentlyBuildingList() {
        return Lists.newArrayList((Iterable)Narrow.iterableTo(this.getCurrentlyBuildingPlans(this.getImmutablePlan().getPlanKey()), CurrentlyBuilding.class));
    }

    public CurrentlyBuilding getCurrentlyBuilding() {
        return this.buildExecutionManager.getCurrentlyBuildingByBuildResultKey(this.getBuildResultKey());
    }

    public Collection<String> getCurrentlyRunningBuildResultKeys() {
        return Collections2.transform(this.getCurrentlyBuildingList(), (Function)new Function<CurrentlyBuilding, String>(){

            public String apply(CurrentlyBuilding from) {
                return from.getBuildIdentifier().getBuildResultKey();
            }
        });
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }
}

